/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lib;

import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class ForwardWalker
extends DefaultGraphWalker {
    public ForwardWalker(Dispatcher disp) {
        super(disp);
    }

    protected boolean allParentsDispatched(Node nd) {
        Operator op = (Operator)nd;
        if (op.getParentOperators() == null) {
            return true;
        }
        for (Operator<OperatorDesc> pNode : op.getParentOperators()) {
            if (this.getDispatchedList().contains(pNode)) continue;
            return false;
        }
        return true;
    }

    protected void addAllParents(Node nd) {
        Operator op = (Operator)nd;
        if (op.getParentOperators() == null) {
            return;
        }
        this.getToWalk().removeAll(op.getParentOperators());
        this.getToWalk().addAll(0, op.getParentOperators());
    }

    @Override
    public void walk(Node nd) throws SemanticException {
        if (this.opStack.empty() || nd != this.opStack.peek()) {
            this.opStack.push(nd);
        }
        if (this.allParentsDispatched(nd)) {
            if (!this.getDispatchedList().contains(nd)) {
                this.getToWalk().addAll(nd.getChildren());
                this.dispatch(nd, this.opStack);
            }
            this.opStack.pop();
            return;
        }
        this.getToWalk().add(0, nd);
        this.addAllParents(nd);
    }
}

