/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.rcfile.merge;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileBlockMergeInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileMergeMapper;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.mapred.Mapper;

@Explain(displayName="Block level merge")
public class MergeWork
extends MapWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient List<Path> inputPaths;
    private transient Path outputDir;
    private boolean hasDynamicPartitions;
    private DynamicPartitionCtx dynPartCtx;
    private boolean isListBucketingAlterTableConcatenate;
    private ListBucketingCtx listBucketingCtx;

    public MergeWork() {
    }

    public MergeWork(List<Path> inputPaths, Path outputDir) {
        this(inputPaths, outputDir, false, null);
    }

    public MergeWork(List<Path> inputPaths, Path outputDir, boolean hasDynamicPartitions, DynamicPartitionCtx dynPartCtx) {
        this.inputPaths = inputPaths;
        this.outputDir = outputDir;
        this.hasDynamicPartitions = hasDynamicPartitions;
        this.dynPartCtx = dynPartCtx;
        PartitionDesc partDesc = new PartitionDesc();
        partDesc.setInputFileFormatClass(RCFileBlockMergeInputFormat.class);
        if (this.getPathToPartitionInfo() == null) {
            this.setPathToPartitionInfo(new LinkedHashMap<String, PartitionDesc>());
        }
        for (Path path : this.inputPaths) {
            this.getPathToPartitionInfo().put(path.toString(), partDesc);
        }
    }

    public List<Path> getInputPaths() {
        return this.inputPaths;
    }

    public void setInputPaths(List<Path> inputPaths) {
        this.inputPaths = inputPaths;
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(Path outputDir) {
        this.outputDir = outputDir;
    }

    public Class<? extends Mapper> getMapperClass() {
        return RCFileMergeMapper.class;
    }

    @Override
    public Long getMinSplitSize() {
        return null;
    }

    @Override
    public String getInputformat() {
        return CombineHiveInputFormat.class.getName();
    }

    @Override
    public boolean isGatheringStats() {
        return false;
    }

    public boolean hasDynamicPartitions() {
        return this.hasDynamicPartitions;
    }

    public void setHasDynamicPartitions(boolean hasDynamicPartitions) {
        this.hasDynamicPartitions = hasDynamicPartitions;
    }

    @Override
    public void resolveDynamicPartitionStoredAsSubDirsMerge(HiveConf conf, Path path, TableDesc tblDesc, ArrayList<String> aliases, PartitionDesc partDesc) {
        String inputFormatClass = conf.getVar(HiveConf.ConfVars.HIVEMERGEINPUTFORMATBLOCKLEVEL);
        try {
            partDesc.setInputFileFormatClass(Class.forName(inputFormatClass));
        }
        catch (ClassNotFoundException e) {
            String msg = "Merge input format class not found";
            throw new RuntimeException(msg);
        }
        super.resolveDynamicPartitionStoredAsSubDirsMerge(conf, path, tblDesc, aliases, partDesc);
        this.inputPaths.add(path);
    }

    public void resolveConcatenateMerge(HiveConf conf) {
        boolean bl = this.isListBucketingAlterTableConcatenate = this.listBucketingCtx == null ? false : this.listBucketingCtx.isSkewedStoredAsDir();
        if (this.isListBucketingAlterTableConcatenate) {
            assert (this.inputPaths != null && this.inputPaths.size() == 1) : "alter table ... concatenate should only have one directory inside inputpaths";
            Path dirPath = this.inputPaths.get(0);
            try {
                FileSystem inpFs = dirPath.getFileSystem((Configuration)conf);
                FileStatus[] status = HiveStatsUtils.getFileStatusRecurse((Path)dirPath, (int)this.listBucketingCtx.getSkewedColNames().size(), (FileSystem)inpFs);
                ArrayList<Path> newInputPath = new ArrayList<Path>();
                boolean succeed = true;
                for (int i = 0; i < status.length; ++i) {
                    if (status[i].isDir()) {
                        newInputPath.add(status[i].getPath());
                        continue;
                    }
                    succeed = false;
                }
                assert (succeed || !succeed && newInputPath.isEmpty()) : "This partition has  inconsistent file structure: it is stored-as-subdir and expected all files in the same depth of subdirectories.";
                if (succeed) {
                    this.inputPaths.clear();
                    this.inputPaths.addAll(newInputPath);
                }
            }
            catch (IOException e) {
                String msg = "Fail to get filesystem for directory name : " + dirPath.toUri();
                throw new RuntimeException(msg, e);
            }
        }
    }

    public DynamicPartitionCtx getDynPartCtx() {
        return this.dynPartCtx;
    }

    public void setDynPartCtx(DynamicPartitionCtx dynPartCtx) {
        this.dynPartCtx = dynPartCtx;
    }

    public ListBucketingCtx getListBucketingCtx() {
        return this.listBucketingCtx;
    }

    public void setListBucketingCtx(ListBucketingCtx listBucketingCtx) {
        this.listBucketingCtx = listBucketingCtx;
    }

    public boolean isListBucketingAlterTableConcatenate() {
        return this.isListBucketingAlterTableConcatenate;
    }
}

