/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde.primitive;

import org.apache.hadoop.hive.ql.io.parquet.writable.BinaryWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableStringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import parquet.io.api.Binary;

public class ParquetStringInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableStringObjectInspector {
    ParquetStringInspector() {
        super(TypeInfoFactory.stringTypeInfo);
    }

    public Text getPrimitiveWritableObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BinaryWritable) {
            return new Text(((BinaryWritable)o).getBytes());
        }
        if (o instanceof Text) {
            return (Text)o;
        }
        if (o instanceof String) {
            return new Text((String)o);
        }
        throw new UnsupportedOperationException("Cannot inspect " + o.getClass().getCanonicalName());
    }

    public String getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BinaryWritable) {
            return ((BinaryWritable)o).getString();
        }
        if (o instanceof Text) {
            return ((Text)o).toString();
        }
        if (o instanceof String) {
            return (String)o;
        }
        throw new UnsupportedOperationException("Cannot inspect " + o.getClass().getCanonicalName());
    }

    public Object set(Object o, Text text) {
        return new BinaryWritable(text == null ? null : Binary.fromByteArray((byte[])text.getBytes()));
    }

    public Object set(Object o, String string) {
        return new BinaryWritable(string == null ? null : Binary.fromString((String)string));
    }

    public Object create(Text text) {
        if (text == null) {
            return null;
        }
        return text.toString();
    }

    public Object create(String string) {
        return string;
    }
}

