/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidTxnListImpl;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.StatsProvidingRecordReader;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.Metadata;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcRawRecordMerger;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.ql.io.orc.StripeStatistics;
import org.apache.hadoop.hive.ql.io.orc.VectorizedOrcAcidRowReader;
import org.apache.hadoop.hive.ql.io.orc.VectorizedOrcInputFormat;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.StringUtils;

public class OrcInputFormat
implements InputFormat<NullWritable, OrcStruct>,
InputFormatChecker,
VectorizedInputFormatInterface,
AcidInputFormat<OrcStruct> {
    private static final Log LOG = LogFactory.getLog(OrcInputFormat.class);
    static final HadoopShims SHIMS = ShimLoader.getHadoopShims();
    static final String MIN_SPLIT_SIZE = (String)SHIMS.getHadoopConfNames().get("MAPREDMINSPLITSIZE");
    static final String MAX_SPLIT_SIZE = (String)SHIMS.getHadoopConfNames().get("MAPREDMAXSPLITSIZE");
    static final String SARG_PUSHDOWN = "sarg.pushdown";
    private static final long DEFAULT_MIN_SPLIT_SIZE = 0x1000000L;
    private static final long DEFAULT_MAX_SPLIT_SIZE = 0x10000000L;
    private static final PerfLogger perfLogger = PerfLogger.getPerfLogger();
    private static final String CLASS_NAME = ReaderImpl.class.getName();
    private static final double MIN_INCLUDED_LOCATION = 0.8;

    private static int getRootColumn(boolean isOriginal) {
        return isOriginal ? 0 : 6;
    }

    public static RecordReader createReaderFromFile(Reader file, Configuration conf, long offset, long length) throws IOException {
        Reader.Options options = new Reader.Options().range(offset, length);
        boolean isOriginal = !file.hasMetadataValue("hive.acid.key.index");
        List<OrcProto.Type> types = file.getTypes();
        OrcInputFormat.setIncludedColumns(options, types, conf, isOriginal);
        OrcInputFormat.setSearchArgument(options, types, conf, isOriginal);
        return file.rowsOptions(options);
    }

    private static void includeColumnRecursive(List<OrcProto.Type> types, boolean[] result, int typeId, int rootColumn) {
        result[typeId - rootColumn] = true;
        OrcProto.Type type = types.get(typeId);
        int children = type.getSubtypesCount();
        for (int i = 0; i < children; ++i) {
            OrcInputFormat.includeColumnRecursive(types, result, type.getSubtypes(i), rootColumn);
        }
    }

    static void setIncludedColumns(Reader.Options options, List<OrcProto.Type> types, Configuration conf, boolean isOriginal) {
        int rootColumn = OrcInputFormat.getRootColumn(isOriginal);
        if (!ColumnProjectionUtils.isReadAllColumns((Configuration)conf)) {
            int numColumns = types.size() - rootColumn;
            boolean[] result = new boolean[numColumns];
            result[0] = true;
            OrcProto.Type root = types.get(rootColumn);
            List included = ColumnProjectionUtils.getReadColumnIDs((Configuration)conf);
            for (int i = 0; i < root.getSubtypesCount(); ++i) {
                if (!included.contains(i)) continue;
                OrcInputFormat.includeColumnRecursive(types, result, root.getSubtypes(i), rootColumn);
            }
            options.include(result);
        } else {
            options.include(null);
        }
    }

    static void setSearchArgument(Reader.Options options, List<OrcProto.Type> types, Configuration conf, boolean isOriginal) {
        int rootColumn = OrcInputFormat.getRootColumn(isOriginal);
        String serializedPushdown = conf.get("hive.io.filter.expr.serialized");
        String sargPushdown = conf.get(SARG_PUSHDOWN);
        String columnNamesString = conf.get("hive.io.file.readcolumn.names");
        if (sargPushdown == null && serializedPushdown == null || columnNamesString == null) {
            LOG.debug((Object)"No ORC pushdown predicate");
            options.searchArgument(null, null);
        } else {
            SearchArgument sarg = serializedPushdown != null ? SearchArgument.FACTORY.create(Utilities.deserializeExpression(serializedPushdown)) : SearchArgument.FACTORY.create(sargPushdown);
            LOG.info((Object)("ORC pushdown predicate: " + sarg));
            String[] neededColumnNames = columnNamesString.split(",");
            String[] columnNames = new String[types.size() - rootColumn];
            boolean[] includedColumns = options.getInclude();
            int i = 0;
            for (int columnId : types.get(rootColumn).getSubtypesList()) {
                if (includedColumns != null && !includedColumns[columnId - rootColumn]) continue;
                columnNames[columnId - rootColumn] = neededColumnNames[i++];
            }
            options.searchArgument(sarg, columnNames);
        }
    }

    @Override
    public boolean validateInput(FileSystem fs, HiveConf conf, ArrayList<FileStatus> files) throws IOException {
        if (Utilities.isVectorMode((Configuration)conf)) {
            return new VectorizedOrcInputFormat().validateInput(fs, conf, files);
        }
        if (files.size() <= 0) {
            return false;
        }
        for (FileStatus file : files) {
            try {
                OrcFile.createReader(file.getPath(), OrcFile.readerOptions((Configuration)conf).filesystem(fs));
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    static Path[] getInputPaths(Configuration conf) throws IOException {
        String dirs = conf.get("mapred.input.dir");
        if (dirs == null) {
            throw new IOException("Configuration mapred.input.dir is not defined.");
        }
        String[] list = StringUtils.split((String)dirs);
        Path[] result = new Path[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = new Path(StringUtils.unEscapeString((String)list[i]));
        }
        return result;
    }

    static List<OrcSplit> generateSplitsInfo(Configuration conf) throws IOException {
        Context context = new Context(conf);
        for (Path dir : OrcInputFormat.getInputPaths(conf)) {
            FileSystem fs = dir.getFileSystem(conf);
            context.schedule(new FileGenerator(context, fs, dir));
        }
        context.waitForTasks();
        if (!context.errors.isEmpty()) {
            ArrayList<IOException> errors = new ArrayList<IOException>(context.errors.size());
            for (Throwable th : context.errors) {
                if (th instanceof IOException) {
                    errors.add((IOException)th);
                    continue;
                }
                throw new RuntimeException("serious problem", th);
            }
            throw new InvalidInputException(errors);
        }
        if (context.cacheStripeDetails) {
            LOG.info((Object)("FooterCacheHitRatio: " + context.cacheHitCounter.get() + "/" + context.numFilesCounter.get()));
        }
        return context.splits;
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        perfLogger.PerfLogBegin(CLASS_NAME, "OrcGetSplits");
        List<OrcSplit> result = OrcInputFormat.generateSplitsInfo((Configuration)job);
        perfLogger.PerfLogEnd(CLASS_NAME, "OrcGetSplits");
        return result.toArray(new InputSplit[result.size()]);
    }

    private org.apache.hadoop.mapred.RecordReader<NullWritable, OrcStruct> createVectorizedReader(InputSplit split, JobConf conf, Reporter reporter) throws IOException {
        return new VectorizedOrcInputFormat().getRecordReader(split, conf, reporter);
    }

    public org.apache.hadoop.mapred.RecordReader<NullWritable, OrcStruct> getRecordReader(InputSplit inputSplit, JobConf conf, Reporter reporter) throws IOException {
        boolean vectorMode = Utilities.isVectorMode((Configuration)conf);
        if (inputSplit.getClass() == FileSplit.class) {
            if (vectorMode) {
                return this.createVectorizedReader(inputSplit, conf, reporter);
            }
            return new OrcRecordReader(OrcFile.createReader(((FileSplit)inputSplit).getPath(), OrcFile.readerOptions((Configuration)conf)), (Configuration)conf, (FileSplit)inputSplit);
        }
        OrcSplit split = (OrcSplit)inputSplit;
        reporter.setStatus(inputSplit.toString());
        if (split.isOriginal() && split.getDeltas().isEmpty()) {
            if (vectorMode) {
                return this.createVectorizedReader(inputSplit, conf, reporter);
            }
            return new OrcRecordReader(OrcFile.createReader(split.getPath(), OrcFile.readerOptions((Configuration)conf)), (Configuration)conf, split);
        }
        AcidInputFormat.Options options = new AcidInputFormat.Options((Configuration)conf).reporter(reporter);
        final AcidInputFormat.RowReader<OrcStruct> inner = this.getReader(inputSplit, options);
        if (vectorMode) {
            return new VectorizedOrcAcidRowReader(inner, (Configuration)conf, (FileSplit)inputSplit);
        }
        final RecordIdentifier id = (RecordIdentifier)inner.createKey();
        return new org.apache.hadoop.mapred.RecordReader<NullWritable, OrcStruct>(){

            public boolean next(NullWritable nullWritable, OrcStruct orcStruct) throws IOException {
                return inner.next(id, orcStruct);
            }

            public NullWritable createKey() {
                return NullWritable.get();
            }

            public OrcStruct createValue() {
                return (OrcStruct)inner.createValue();
            }

            public long getPos() throws IOException {
                return inner.getPos();
            }

            public void close() throws IOException {
                inner.close();
            }

            public float getProgress() throws IOException {
                return inner.getProgress();
            }
        };
    }

    @Override
    public AcidInputFormat.RowReader<OrcStruct> getReader(InputSplit inputSplit, AcidInputFormat.Options options) throws IOException {
        Reader reader;
        int bucket;
        OrcSplit split = (OrcSplit)inputSplit;
        Path path = split.getPath();
        Path root = split.hasBase() ? (split.isOriginal() ? path.getParent() : path.getParent().getParent()) : path;
        Path[] deltas = AcidUtils.deserializeDeltas(root, split.getDeltas());
        Configuration conf = options.getConfiguration();
        Reader.Options readOptions = new Reader.Options();
        readOptions.range(split.getStart(), split.getLength());
        if (split.hasBase()) {
            bucket = AcidUtils.parseBaseBucketFilename(split.getPath(), conf).getBucket();
            reader = OrcFile.createReader(path, OrcFile.readerOptions(conf));
            List<OrcProto.Type> types = reader.getTypes();
            OrcInputFormat.setIncludedColumns(readOptions, types, conf, split.isOriginal());
            OrcInputFormat.setSearchArgument(readOptions, types, conf, split.isOriginal());
        } else {
            bucket = (int)split.getStart();
            reader = null;
        }
        String txnString = conf.get("hive.txn.valid.txns", "9223372036854775807:");
        ValidTxnListImpl validTxnList = new ValidTxnListImpl(txnString);
        final OrcRawRecordMerger records = new OrcRawRecordMerger(conf, true, reader, split.isOriginal(), bucket, (ValidTxnList)validTxnList, readOptions, deltas);
        return new AcidInputFormat.RowReader<OrcStruct>(){
            OrcStruct innerRecord;
            {
                this.innerRecord = records.createValue();
            }

            @Override
            public ObjectInspector getObjectInspector() {
                return ((StructField)((StructObjectInspector)reader.getObjectInspector()).getAllStructFieldRefs().get(5)).getFieldObjectInspector();
            }

            public boolean next(RecordIdentifier recordIdentifier, OrcStruct orcStruct) throws IOException {
                boolean result;
                while ((result = records.next(recordIdentifier, this.innerRecord)) && OrcRecordUpdater.getOperation(this.innerRecord) == 2) {
                }
                if (result) {
                    orcStruct.linkFields(OrcRecordUpdater.getRow(this.innerRecord));
                }
                return result;
            }

            public RecordIdentifier createKey() {
                return records.createKey();
            }

            public OrcStruct createValue() {
                return new OrcStruct(records.getColumns());
            }

            public long getPos() throws IOException {
                return records.getPos();
            }

            public void close() throws IOException {
                records.close();
            }

            public float getProgress() throws IOException {
                return records.getProgress();
            }
        };
    }

    static Path findOriginalBucket(FileSystem fs, Path directory, int bucket) throws IOException {
        for (FileStatus stat : fs.listStatus(directory)) {
            String name = stat.getPath().getName();
            if (Integer.parseInt(name.substring(0, name.indexOf(95))) != bucket) continue;
            return stat.getPath();
        }
        throw new IllegalArgumentException("Can't find bucket " + bucket + " in " + directory);
    }

    @Override
    public AcidInputFormat.RawReader<OrcStruct> getRawReader(Configuration conf, boolean collapseEvents, int bucket, ValidTxnList validTxnList, Path baseDirectory, Path[] deltaDirectory) throws IOException {
        Reader reader = null;
        boolean isOriginal = false;
        if (baseDirectory != null) {
            Path bucketFile;
            if (baseDirectory.getName().startsWith("base_")) {
                bucketFile = AcidUtils.createBucketFile(baseDirectory, bucket);
            } else {
                isOriginal = true;
                bucketFile = OrcInputFormat.findOriginalBucket(baseDirectory.getFileSystem(conf), baseDirectory, bucket);
            }
            reader = OrcFile.createReader(bucketFile, OrcFile.readerOptions(conf));
        }
        return new OrcRawRecordMerger(conf, collapseEvents, reader, isOriginal, bucket, validTxnList, new Reader.Options(), deltaDirectory);
    }

    private static class FileInfo {
        long modificationTime;
        long size;
        List<StripeInformation> stripeInfos;
        ReaderImpl.FileMetaInfo fileMetaInfo;
        Metadata metadata;
        List<OrcProto.Type> types;

        FileInfo(long modificationTime, long size, List<StripeInformation> stripeInfos, Metadata metadata, List<OrcProto.Type> types, ReaderImpl.FileMetaInfo fileMetaInfo) {
            this.modificationTime = modificationTime;
            this.size = size;
            this.stripeInfos = stripeInfos;
            this.fileMetaInfo = fileMetaInfo;
            this.metadata = metadata;
            this.types = types;
        }
    }

    static final class SplitGenerator
    implements Runnable {
        private final Context context;
        private final FileSystem fs;
        private final FileStatus file;
        private final long blockSize;
        private final BlockLocation[] locations;
        private final FileInfo fileInfo;
        private List<StripeInformation> stripes;
        private ReaderImpl.FileMetaInfo fileMetaInfo;
        private Metadata metadata;
        private List<OrcProto.Type> types;
        private final boolean isOriginal;
        private final List<Long> deltas;
        private final boolean hasBase;

        SplitGenerator(Context context, FileSystem fs, FileStatus file, FileInfo fileInfo, boolean isOriginal, List<Long> deltas, boolean hasBase) throws IOException {
            this.context = context;
            this.fs = fs;
            this.file = file;
            this.blockSize = file.getBlockSize();
            this.fileInfo = fileInfo;
            this.locations = SHIMS.getLocations(fs, file);
            this.isOriginal = isOriginal;
            this.deltas = deltas;
            this.hasBase = hasBase;
        }

        Path getPath() {
            return this.file.getPath();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schedule() throws IOException {
            if (this.locations.length == 1 && this.file.getLen() < this.context.maxSize) {
                String[] hosts = this.locations[0].getHosts();
                List list = this.context.splits;
                synchronized (list) {
                    this.context.splits.add(new OrcSplit(this.file.getPath(), 0L, this.file.getLen(), hosts, this.fileMetaInfo, this.isOriginal, this.hasBase, this.deltas));
                }
            } else {
                this.context.schedule(this);
            }
        }

        public String toString() {
            return "splitter(" + this.file.getPath() + ")";
        }

        static long getOverlap(long offset1, long length1, long offset2, long length2) {
            long end1 = offset1 + length1;
            long end2 = offset2 + length2;
            if (end2 <= offset1 || end1 <= offset2) {
                return 0L;
            }
            return Math.min(end1, end2) - Math.max(offset1, offset2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void createSplit(long offset, long length, ReaderImpl.FileMetaInfo fileMetaInfo) throws IOException {
            String[] hosts;
            if (offset % this.blockSize + length <= this.blockSize) {
                hosts = this.locations[(int)(offset / this.blockSize)].getHosts();
            } else {
                HashMap<String, LongWritable> sizes = new HashMap<String, LongWritable>();
                long maxSize = 0L;
                for (BlockLocation block : this.locations) {
                    long overlap = SplitGenerator.getOverlap(offset, length, block.getOffset(), block.getLength());
                    if (overlap <= 0L) continue;
                    for (String host : block.getHosts()) {
                        LongWritable val = (LongWritable)sizes.get(host);
                        if (val == null) {
                            val = new LongWritable();
                            sizes.put(host, val);
                        }
                        val.set(val.get() + overlap);
                        maxSize = Math.max(maxSize, val.get());
                    }
                }
                long threshold = (long)((double)maxSize * 0.8);
                ArrayList<String> hostList = new ArrayList<String>();
                for (BlockLocation block : this.locations) {
                    for (String host : block.getHosts()) {
                        if (!sizes.containsKey(host)) continue;
                        if (((LongWritable)sizes.get(host)).get() >= threshold) {
                            hostList.add(host);
                        }
                        sizes.remove(host);
                    }
                }
                hosts = new String[hostList.size()];
                hostList.toArray(hosts);
            }
            List list = this.context.splits;
            synchronized (list) {
                this.context.splits.add(new OrcSplit(this.file.getPath(), offset, length, hosts, fileMetaInfo, this.isOriginal, this.hasBase, this.deltas));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.populateAndCacheStripeDetails();
                boolean[] includeStripe = null;
                if (this.deltas.isEmpty()) {
                    Reader.Options options = new Reader.Options();
                    OrcInputFormat.setIncludedColumns(options, this.types, this.context.conf, this.isOriginal);
                    OrcInputFormat.setSearchArgument(options, this.types, this.context.conf, this.isOriginal);
                    if (options.getSearchArgument() != null) {
                        SearchArgument sarg = options.getSearchArgument();
                        List<PredicateLeaf> sargLeaves = sarg.getLeaves();
                        List<StripeStatistics> stripeStats = this.metadata.getStripeStatistics();
                        int[] filterColumns = RecordReaderImpl.mapSargColumns(sargLeaves, options.getColumnNames(), OrcInputFormat.getRootColumn(this.isOriginal));
                        if (stripeStats != null) {
                            includeStripe = new boolean[this.stripes.size()];
                            for (int i = 0; i < this.stripes.size(); ++i) {
                                boolean bl = includeStripe[i] = i >= stripeStats.size() || this.isStripeSatisfyPredicate(stripeStats.get(i), sarg, filterColumns);
                                if (!LOG.isDebugEnabled() || includeStripe[i]) continue;
                                LOG.debug((Object)("Eliminating ORC stripe-" + i + " of file '" + this.file.getPath() + "'  as it did not satisfy " + "predicate condition."));
                            }
                        }
                    }
                }
                if (includeStripe == null) {
                    includeStripe = new boolean[this.stripes.size()];
                    Arrays.fill(includeStripe, true);
                }
                long currentOffset = -1L;
                long currentLength = 0L;
                int idx = -1;
                for (StripeInformation stripe : this.stripes) {
                    if (!includeStripe[++idx]) {
                        if (currentOffset == -1L) continue;
                        this.createSplit(currentOffset, currentLength, this.fileMetaInfo);
                        currentOffset = -1L;
                        continue;
                    }
                    if (currentOffset != -1L && currentLength > this.context.minSize && currentOffset / this.blockSize != stripe.getOffset() / this.blockSize) {
                        this.createSplit(currentOffset, currentLength, this.fileMetaInfo);
                        currentOffset = -1L;
                    }
                    if (currentOffset == -1L) {
                        currentOffset = stripe.getOffset();
                        currentLength = stripe.getLength();
                    } else {
                        currentLength = stripe.getOffset() + stripe.getLength() - currentOffset;
                    }
                    if (currentLength < this.context.maxSize) continue;
                    this.createSplit(currentOffset, currentLength, this.fileMetaInfo);
                    currentOffset = -1L;
                }
                if (currentOffset != -1L) {
                    this.createSplit(currentOffset, currentLength, this.fileMetaInfo);
                }
            }
            catch (Throwable th) {
                if (!(th instanceof IOException)) {
                    LOG.error((Object)"Unexpected Exception", th);
                }
                List list = this.context.errors;
                synchronized (list) {
                    this.context.errors.add(th);
                }
                if (!(th instanceof IOException)) {
                    this.context.notifyOnNonIOException(th);
                }
            }
            finally {
                this.context.decrementSchedulers();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void populateAndCacheStripeDetails() {
            block10: {
                try {
                    if (this.fileInfo != null) {
                        this.stripes = this.fileInfo.stripeInfos;
                        this.fileMetaInfo = this.fileInfo.fileMetaInfo;
                        this.metadata = this.fileInfo.metadata;
                        this.types = this.fileInfo.types;
                        if (this.fileMetaInfo == null && this.context.footerInSplits) {
                            Reader orcReader = OrcFile.createReader(this.file.getPath(), OrcFile.readerOptions(this.context.conf).filesystem(this.fs));
                            this.fileInfo.fileMetaInfo = ((ReaderImpl)orcReader).getFileMetaInfo();
                            this.fileInfo.metadata = orcReader.getMetadata();
                            this.fileInfo.types = orcReader.getTypes();
                        }
                    } else {
                        Reader orcReader = OrcFile.createReader(this.file.getPath(), OrcFile.readerOptions(this.context.conf).filesystem(this.fs));
                        this.stripes = orcReader.getStripes();
                        this.metadata = orcReader.getMetadata();
                        this.types = orcReader.getTypes();
                        ReaderImpl.FileMetaInfo fileMetaInfo = this.fileMetaInfo = this.context.footerInSplits ? ((ReaderImpl)orcReader).getFileMetaInfo() : null;
                        if (this.context.cacheStripeDetails) {
                            Context.footerCache.put((Object)this.file.getPath(), (Object)new FileInfo(this.file.getModificationTime(), this.file.getLen(), this.stripes, this.metadata, this.types, this.fileMetaInfo));
                        }
                    }
                }
                catch (Throwable th) {
                    if (!(th instanceof IOException)) {
                        LOG.error((Object)"Unexpected Exception", th);
                    }
                    List list = this.context.errors;
                    synchronized (list) {
                        this.context.errors.add(th);
                    }
                    if (th instanceof IOException) break block10;
                    this.context.notifyOnNonIOException(th);
                }
            }
        }

        private boolean isStripeSatisfyPredicate(StripeStatistics stripeStatistics, SearchArgument sarg, int[] filterColumns) {
            List<PredicateLeaf> predLeaves = sarg.getLeaves();
            SearchArgument.TruthValue[] truthValues = new SearchArgument.TruthValue[predLeaves.size()];
            for (int pred = 0; pred < truthValues.length; ++pred) {
                if (filterColumns[pred] != -1) {
                    ColumnStatistics stats = stripeStatistics.getColumnStatistics()[filterColumns[pred]];
                    Object minValue = RecordReaderImpl.getMin(stats);
                    Object maxValue = RecordReaderImpl.getMax(stats);
                    truthValues[pred] = RecordReaderImpl.evaluatePredicateRange(predLeaves.get(pred), minValue, maxValue);
                    continue;
                }
                truthValues[pred] = SearchArgument.TruthValue.YES_NO_NULL;
            }
            return sarg.evaluate(truthValues).isNeeded();
        }
    }

    static final class FileGenerator
    implements Runnable {
        private final Context context;
        private final FileSystem fs;
        private final Path dir;

        FileGenerator(Context context, FileSystem fs, Path dir) {
            this.context = context;
            this.fs = fs;
            this.dir = dir;
        }

        private void scheduleSplits(FileStatus file, boolean isOriginal, boolean hasBase, List<Long> deltas) throws IOException {
            FileInfo info = null;
            if (this.context.cacheStripeDetails) {
                info = this.verifyCachedFileInfo(file);
            }
            new SplitGenerator(this.context, this.fs, file, info, isOriginal, deltas, hasBase).schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean isOriginal;
                AcidUtils.Directory dirInfo = AcidUtils.getAcidState(this.dir, this.context.conf, this.context.transactionList);
                List<Long> deltas = AcidUtils.serializeDeltas(dirInfo.getCurrentDirectories());
                Path base = dirInfo.getBaseDirectory();
                List original = dirInfo.getOriginalFiles();
                boolean[] covered = new boolean[this.context.numBuckets];
                boolean bl = isOriginal = base == null;
                if (base != null || !original.isEmpty()) {
                    List children = original;
                    if (base != null) {
                        children = SHIMS.listLocatedStatus(this.fs, base, AcidUtils.hiddenFileFilter);
                    }
                    for (FileStatus child : children) {
                        AcidOutputFormat.Options opts = AcidUtils.parseBaseBucketFilename(child.getPath(), this.context.conf);
                        this.scheduleSplits(child, isOriginal, true, deltas);
                        int b = opts.getBucket();
                        if (b < 0 || b >= covered.length) continue;
                        covered[b] = true;
                    }
                }
                if (!deltas.isEmpty()) {
                    for (int b = 0; b < this.context.numBuckets; ++b) {
                        if (covered[b]) continue;
                        this.context.splits.add(new OrcSplit(this.dir, b, 0L, new String[0], null, false, false, deltas));
                    }
                }
            }
            catch (Throwable th) {
                if (!(th instanceof IOException)) {
                    LOG.error((Object)"Unexpected Exception", th);
                }
                List list = this.context.errors;
                synchronized (list) {
                    this.context.errors.add(th);
                }
                if (!(th instanceof IOException)) {
                    this.context.notifyOnNonIOException(th);
                }
            }
            finally {
                this.context.decrementSchedulers();
            }
        }

        private FileInfo verifyCachedFileInfo(FileStatus file) {
            this.context.numFilesCounter.incrementAndGet();
            FileInfo fileInfo = (FileInfo)Context.footerCache.getIfPresent((Object)file.getPath());
            if (fileInfo != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Info cached for path: " + file.getPath()));
                }
                if (fileInfo.modificationTime == file.getModificationTime() && fileInfo.size == file.getLen()) {
                    this.context.cacheHitCounter.incrementAndGet();
                    return fileInfo;
                }
                Context.footerCache.invalidate((Object)file.getPath());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Meta-Info for : " + file.getPath() + " changed. CachedModificationTime: " + fileInfo.modificationTime + ", CurrentModificationTime: " + file.getModificationTime() + ", CachedLength: " + fileInfo.size + ", CurrentLength: " + file.getLen()));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Info not cached for path: " + file.getPath()));
            }
            return null;
        }
    }

    static class Context {
        private final Configuration conf;
        private static Cache<Path, FileInfo> footerCache;
        private final ExecutorService threadPool;
        private final List<OrcSplit> splits = new ArrayList<OrcSplit>(10000);
        private final int numBuckets;
        private final List<Throwable> errors = new ArrayList<Throwable>();
        private final long maxSize;
        private final long minSize;
        private final boolean footerInSplits;
        private final boolean cacheStripeDetails;
        private final AtomicInteger cacheHitCounter = new AtomicInteger(0);
        private final AtomicInteger numFilesCounter = new AtomicInteger(0);
        private Throwable fatalError = null;
        private ValidTxnList transactionList;
        private int schedulers = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Context(Configuration conf) {
            this.conf = conf;
            this.minSize = conf.getLong(MIN_SPLIT_SIZE, 0x1000000L);
            this.maxSize = conf.getLong(MAX_SPLIT_SIZE, 0x10000000L);
            this.footerInSplits = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ORC_INCLUDE_FILE_FOOTER_IN_SPLITS);
            this.numBuckets = Math.max(conf.getInt("bucket_count", 0), 0);
            int cacheStripeDetailsSize = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ORC_CACHE_STRIPE_DETAILS_SIZE);
            int numThreads = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ORC_COMPUTE_SPLITS_NUM_THREADS);
            this.cacheStripeDetails = cacheStripeDetailsSize > 0;
            this.threadPool = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ORC_GET_SPLITS #%d").build());
            Class<Context> clazz = Context.class;
            synchronized (Context.class) {
                if (footerCache == null && this.cacheStripeDetails) {
                    footerCache = CacheBuilder.newBuilder().concurrencyLevel(numThreads).initialCapacity(cacheStripeDetailsSize).softValues().build();
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                String value = conf.get("hive.txn.valid.txns", "9223372036854775807:");
                this.transactionList = new ValidTxnListImpl(value);
                return;
            }
        }

        int getSchedulers() {
            return this.schedulers;
        }

        OrcSplit getResult(int index) {
            if (index >= 0) {
                return this.splits.get(index);
            }
            return this.splits.get(this.splits.size() + index);
        }

        List<Throwable> getErrors() {
            return this.errors;
        }

        synchronized void schedule(Runnable runnable) {
            if (this.fatalError == null) {
                if (runnable instanceof FileGenerator || runnable instanceof SplitGenerator) {
                    ++this.schedulers;
                }
            } else {
                throw new RuntimeException("serious problem", this.fatalError);
            }
            this.threadPool.execute(runnable);
        }

        synchronized void decrementSchedulers() {
            --this.schedulers;
            if (this.schedulers == 0) {
                this.notify();
            }
        }

        synchronized void notifyOnNonIOException(Throwable th) {
            this.fatalError = th;
            this.notify();
        }

        synchronized void waitForTasks() {
            try {
                while (this.schedulers != 0) {
                    this.wait();
                    if (this.fatalError == null) continue;
                    this.threadPool.shutdownNow();
                    throw new RuntimeException("serious problem", this.fatalError);
                }
                this.threadPool.shutdown();
                this.threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (InterruptedException ie) {
                throw new IllegalStateException("interrupted", ie);
            }
        }
    }

    private static class OrcRecordReader
    implements org.apache.hadoop.mapred.RecordReader<NullWritable, OrcStruct>,
    StatsProvidingRecordReader {
        private final RecordReader reader;
        private final long offset;
        private final long length;
        private final int numColumns;
        private float progress = 0.0f;
        private final Reader file;
        private final SerDeStats stats;

        OrcRecordReader(Reader file, Configuration conf, FileSplit split) throws IOException {
            List<OrcProto.Type> types = file.getTypes();
            this.file = file;
            this.numColumns = types.size() == 0 ? 0 : types.get(0).getSubtypesCount();
            this.offset = split.getStart();
            this.length = split.getLength();
            this.reader = OrcInputFormat.createReaderFromFile(file, conf, this.offset, this.length);
            this.stats = new SerDeStats();
        }

        public boolean next(NullWritable key, OrcStruct value) throws IOException {
            if (this.reader.hasNext()) {
                this.reader.next(value);
                this.progress = this.reader.getProgress();
                return true;
            }
            return false;
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public OrcStruct createValue() {
            return new OrcStruct(this.numColumns);
        }

        public long getPos() throws IOException {
            return this.offset + (long)(this.progress * (float)this.length);
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException {
            return this.progress;
        }

        @Override
        public SerDeStats getStats() {
            this.stats.setRawDataSize(this.file.getRawDataSize());
            this.stats.setRowCount(this.file.getNumberOfRows());
            return this.stats;
        }
    }
}

