/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;

public class AcidUtils {
    private static final Log LOG = LogFactory.getLog((String)AcidUtils.class.getName());
    public static final String BASE_PREFIX = "base_";
    public static final String DELTA_PREFIX = "delta_";
    public static final String BUCKET_PREFIX = "bucket_";
    public static final String BUCKET_DIGITS = "%05d";
    public static final String DELTA_DIGITS = "%07d";
    private static final Pattern ORIGINAL_PATTERN = Pattern.compile("[0-9]+_[0-9]+");
    public static final Pattern BUCKET_DIGIT_PATTERN = Pattern.compile("[0-9]{5}$");
    public static final Pattern LEGACY_BUCKET_DIGIT_PATTERN = Pattern.compile("^[0-9]{5}");
    public static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };
    public static final PathFilter bucketFileFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.BUCKET_PREFIX);
        }
    };
    private static final HadoopShims SHIMS = ShimLoader.getHadoopShims();

    private AcidUtils() {
    }

    public static Path createBucketFile(Path subdir, int bucket) {
        return new Path(subdir, BUCKET_PREFIX + String.format(BUCKET_DIGITS, bucket));
    }

    private static String deltaSubdir(long min, long max) {
        return DELTA_PREFIX + String.format(DELTA_DIGITS, min) + "_" + String.format(DELTA_DIGITS, max);
    }

    public static Path createFilename(Path directory, AcidOutputFormat.Options options) {
        if (options.getOldStyle()) {
            return new Path(directory, String.format(BUCKET_DIGITS, options.getBucket()) + "_0");
        }
        String subdir = options.isWritingBase() ? BASE_PREFIX + String.format(DELTA_DIGITS, options.getMaximumTransactionId()) : AcidUtils.deltaSubdir(options.getMinimumTransactionId(), options.getMaximumTransactionId());
        return AcidUtils.createBucketFile(new Path(directory, subdir), options.getBucket());
    }

    static long parseBase(Path path) {
        String filename = path.getName();
        if (filename.startsWith(BASE_PREFIX)) {
            return Long.parseLong(filename.substring(BASE_PREFIX.length()));
        }
        throw new IllegalArgumentException(filename + " does not start with " + BASE_PREFIX);
    }

    public static AcidOutputFormat.Options parseBaseBucketFilename(Path bucketFile, Configuration conf) {
        AcidOutputFormat.Options result = new AcidOutputFormat.Options(conf);
        String filename = bucketFile.getName();
        result.writingBase(true);
        if (ORIGINAL_PATTERN.matcher(filename).matches()) {
            int bucket = Integer.parseInt(filename.substring(0, filename.indexOf(95)));
            result.setOldStyle(true).minimumTransactionId(0L).maximumTransactionId(0L).bucket(bucket);
        } else if (filename.startsWith(BUCKET_PREFIX)) {
            int bucket = Integer.parseInt(filename.substring(filename.indexOf(95) + 1));
            result.setOldStyle(false).minimumTransactionId(0L).maximumTransactionId(AcidUtils.parseBase(bucketFile.getParent())).bucket(bucket);
        } else {
            result.setOldStyle(true).bucket(-1).minimumTransactionId(0L).maximumTransactionId(0L);
        }
        return result;
    }

    public static Path[] getPaths(List<ParsedDelta> deltas) {
        Path[] result = new Path[deltas.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = deltas.get(i).getPath();
        }
        return result;
    }

    public static List<Long> serializeDeltas(List<ParsedDelta> deltas) {
        ArrayList<Long> result = new ArrayList<Long>(deltas.size() * 2);
        for (ParsedDelta delta : deltas) {
            result.add(delta.minTransaction);
            result.add(delta.maxTransaction);
        }
        return result;
    }

    public static Path[] deserializeDeltas(Path root, List<Long> deltas) {
        int deltaSize = deltas.size() / 2;
        Path[] result = new Path[deltaSize];
        for (int i = 0; i < deltaSize; ++i) {
            result[i] = new Path(root, AcidUtils.deltaSubdir(deltas.get(i * 2), deltas.get(i * 2 + 1)));
        }
        return result;
    }

    static ParsedDelta parseDelta(FileStatus path) {
        String filename = path.getPath().getName();
        if (filename.startsWith(DELTA_PREFIX)) {
            String rest = filename.substring(DELTA_PREFIX.length());
            int split = rest.indexOf(95);
            long min = Long.parseLong(rest.substring(0, split));
            long max = Long.parseLong(rest.substring(split + 1));
            return new ParsedDelta(min, max, path);
        }
        throw new IllegalArgumentException(path + " does not start with " + DELTA_PREFIX);
    }

    public static Directory getAcidState(Path directory, Configuration conf, ValidTxnList txnList) throws IOException {
        FileSystem fs = directory.getFileSystem(conf);
        FileStatus bestBase = null;
        long bestBaseTxn = 0L;
        final ArrayList<ParsedDelta> deltas = new ArrayList<ParsedDelta>();
        ArrayList<ParsedDelta> working = new ArrayList<ParsedDelta>();
        final ArrayList<FileStatus> original = new ArrayList<FileStatus>();
        final ArrayList<FileStatus> obsolete = new ArrayList<FileStatus>();
        List children = SHIMS.listLocatedStatus(fs, directory, hiddenFileFilter);
        for (FileStatus child : children) {
            Path p = child.getPath();
            String fn = p.getName();
            if (fn.startsWith(BASE_PREFIX) && child.isDir()) {
                long txn = AcidUtils.parseBase(p);
                if (bestBase == null) {
                    bestBase = child;
                    bestBaseTxn = txn;
                    continue;
                }
                if (bestBaseTxn < txn) {
                    obsolete.add(bestBase);
                    bestBase = child;
                    bestBaseTxn = txn;
                    continue;
                }
                obsolete.add(child);
                continue;
            }
            if (fn.startsWith(DELTA_PREFIX) && child.isDir()) {
                ParsedDelta delta = AcidUtils.parseDelta(child);
                if (txnList.isTxnRangeCommitted(delta.minTransaction, delta.maxTransaction) == ValidTxnList.RangeResponse.NONE) continue;
                working.add(delta);
                continue;
            }
            AcidUtils.findOriginals(fs, child, original);
        }
        if (bestBase != null) {
            obsolete.addAll(original);
            original.clear();
        }
        Collections.sort(working);
        long current = bestBaseTxn;
        for (ParsedDelta next : working) {
            if (next.maxTransaction > current) {
                if (txnList.isTxnRangeCommitted(current + 1L, next.maxTransaction) == ValidTxnList.RangeResponse.NONE) continue;
                deltas.add(next);
                current = next.maxTransaction;
                continue;
            }
            obsolete.add(next.path);
        }
        final Path base = bestBase == null ? null : bestBase.getPath();
        LOG.debug((Object)("base = " + base + " deltas = " + deltas.size()));
        return new Directory(){

            @Override
            public Path getBaseDirectory() {
                return base;
            }

            @Override
            public List<FileStatus> getOriginalFiles() {
                return original;
            }

            @Override
            public List<ParsedDelta> getCurrentDirectories() {
                return deltas;
            }

            @Override
            public List<FileStatus> getObsolete() {
                return obsolete;
            }
        };
    }

    private static void findOriginals(FileSystem fs, FileStatus stat, List<FileStatus> original) throws IOException {
        if (stat.isDir()) {
            for (FileStatus child : SHIMS.listLocatedStatus(fs, stat.getPath(), hiddenFileFilter)) {
                AcidUtils.findOriginals(fs, child, original);
            }
        } else {
            original.add(stat);
        }
    }

    public static class ParsedDelta
    implements Comparable<ParsedDelta> {
        final long minTransaction;
        final long maxTransaction;
        final FileStatus path;

        ParsedDelta(long min, long max, FileStatus path) {
            this.minTransaction = min;
            this.maxTransaction = max;
            this.path = path;
        }

        public long getMinTransaction() {
            return this.minTransaction;
        }

        public long getMaxTransaction() {
            return this.maxTransaction;
        }

        public Path getPath() {
            return this.path.getPath();
        }

        @Override
        public int compareTo(ParsedDelta parsedDelta) {
            if (this.minTransaction != parsedDelta.minTransaction) {
                if (this.minTransaction < parsedDelta.minTransaction) {
                    return -1;
                }
                return 1;
            }
            if (this.maxTransaction != parsedDelta.maxTransaction) {
                if (this.maxTransaction < parsedDelta.maxTransaction) {
                    return 1;
                }
                return -1;
            }
            return this.path.compareTo((Object)parsedDelta.path);
        }
    }

    public static interface Directory {
        public Path getBaseDirectory();

        public List<FileStatus> getOriginalFiles();

        public List<ParsedDelta> getCurrentDirectories();

        public List<FileStatus> getObsolete();
    }
}

