/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongToStringUnaryUDF;
import org.apache.hadoop.hive.serde2.io.DateWritable;

public class VectorUDFDateLong
extends LongToStringUnaryUDF {
    private static final long serialVersionUID = 1L;
    private transient SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private transient Date date = new Date(0L);

    public VectorUDFDateLong() {
    }

    public VectorUDFDateLong(int inputColumn, int outputColumn) {
        super(inputColumn, outputColumn);
    }

    @Override
    protected void func(BytesColumnVector outV, long[] vector, int i) {
        switch (this.inputTypes[0]) {
            case DATE: {
                this.date.setTime(DateWritable.daysToMillis((int)((int)vector[i])));
                break;
            }
            case TIMESTAMP: {
                this.date.setTime(vector[i] / 1000000L);
            }
        }
        try {
            byte[] bytes = this.formatter.format(this.date).getBytes("UTF-8");
            outV.setRef(i, bytes, 0, bytes.length);
        }
        catch (UnsupportedEncodingException e) {
            outV.vector[i] = null;
            outV.isNull[i] = true;
        }
    }
}

