/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.io.Text;

public class VectorUDFDateAddColCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;
    private int outputColumn;
    protected boolean isPositive = true;
    private final transient Calendar calendar = Calendar.getInstance();
    private transient SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private final transient Text text = new Text();

    public VectorUDFDateAddColCol(int colNum1, int colNum2, int outputColumn) {
        this();
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
        this.outputColumn = outputColumn;
    }

    public VectorUDFDateAddColCol() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        ColumnVector inputColVector1 = batch.cols[this.colNum1];
        LongColumnVector inputColVector2 = (LongColumnVector)batch.cols[this.colNum2];
        int[] sel = batch.selected;
        int n = batch.size;
        long[] vector2 = inputColVector2.vector;
        BytesColumnVector outV = (BytesColumnVector)batch.cols[this.outputColumn];
        byte[][] outputVector = outV.vector;
        if (n <= 0) {
            return;
        }
        NullUtil.propagateNullsColCol(inputColVector1, inputColVector2, outV, batch.selected, batch.size, batch.selectedInUse);
        switch (this.inputTypes[0]) {
            case DATE: {
                if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                    outV.isRepeating = true;
                    outputVector[0] = this.evaluateDate(inputColVector1, 0, vector2[0]);
                    outV.start[0] = 0;
                    outV.length[0] = outputVector[0].length;
                    break;
                }
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = this.evaluateDate(inputColVector1, i, vector2[i]);
                        outV.start[i] = 0;
                        outV.length[i] = outputVector[0].length;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = this.evaluateDate(inputColVector1, i, vector2[i]);
                        outV.start[i] = 0;
                        outV.length[i] = outputVector[0].length;
                    }
                }
                break;
            }
            case TIMESTAMP: {
                if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                    outV.isRepeating = true;
                    outputVector[0] = this.evaluateTimestamp(inputColVector1, 0, vector2[0]);
                    break;
                }
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = this.evaluateTimestamp(inputColVector1, i, vector2[i]);
                        outV.start[i] = 0;
                        outV.length[i] = outputVector[0].length;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = this.evaluateTimestamp(inputColVector1, i, vector2[i]);
                        outV.start[i] = 0;
                        outV.length[i] = outputVector[0].length;
                    }
                }
                break;
            }
            case STRING: {
                if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                    outV.isRepeating = true;
                    this.evaluateString((BytesColumnVector)inputColVector1, inputColVector2, outV, 0);
                    break;
                }
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.evaluateString((BytesColumnVector)inputColVector1, inputColVector2, outV, i);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        this.evaluateString((BytesColumnVector)inputColVector1, inputColVector2, outV, i);
                    }
                }
                break;
            }
        }
    }

    protected byte[] evaluateDate(ColumnVector columnVector, int index, long numDays) {
        LongColumnVector lcv = (LongColumnVector)columnVector;
        if (this.isPositive) {
            this.calendar.setTimeInMillis(DateWritable.daysToMillis((int)((int)lcv.vector[index] + (int)numDays)));
        } else {
            this.calendar.setTimeInMillis(DateWritable.daysToMillis((int)((int)lcv.vector[index] - (int)numDays)));
        }
        Date newDate = this.calendar.getTime();
        this.text.set(this.formatter.format(newDate));
        return Arrays.copyOf(this.text.getBytes(), this.text.getLength());
    }

    protected byte[] evaluateTimestamp(ColumnVector columnVector, int index, long numDays) {
        LongColumnVector lcv = (LongColumnVector)columnVector;
        this.calendar.setTimeInMillis(lcv.vector[index] / 1000000L);
        if (this.isPositive) {
            this.calendar.add(5, (int)numDays);
        } else {
            this.calendar.add(5, (int)(-numDays));
        }
        Date newDate = this.calendar.getTime();
        this.text.set(this.formatter.format(newDate));
        return Arrays.copyOf(this.text.getBytes(), this.text.getLength());
    }

    protected void evaluateString(BytesColumnVector inputColumnVector1, LongColumnVector inputColumnVector2, BytesColumnVector outputVector, int i) {
        if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i]) {
            outputVector.noNulls = false;
            outputVector.isNull[i] = true;
        } else {
            this.text.set(inputColumnVector1.vector[i], inputColumnVector1.start[i], inputColumnVector1.length[i]);
            try {
                this.calendar.setTime(this.formatter.parse(this.text.toString()));
            }
            catch (ParseException e) {
                outputVector.noNulls = false;
                outputVector.isNull[i] = true;
            }
            if (this.isPositive) {
                this.calendar.add(5, (int)inputColumnVector2.vector[i]);
            } else {
                this.calendar.add(5, -((int)inputColumnVector2.vector[i]));
            }
            Date newDate = this.calendar.getTime();
            this.text.set(this.formatter.format(newDate));
            outputVector.vector[i] = Arrays.copyOf(this.text.getBytes(), this.text.getLength());
            outputVector.start[i] = 0;
            outputVector.length[i] = this.text.getLength();
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "string";
    }

    public int getColNum1() {
        return this.colNum1;
    }

    public void setColNum1(int colNum1) {
        this.colNum1 = colNum1;
    }

    public int getColNum2() {
        return this.colNum2;
    }

    public void setColNum2(int colNum2) {
        this.colNum2 = colNum2;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.ANY, VectorExpressionDescriptor.ArgumentType.LONG).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

