/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public abstract class FuncDoubleToDecimal
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    int inputColumn;
    int outputColumn;

    public FuncDoubleToDecimal(int inputColumn, int outputColumn) {
        this.inputColumn = inputColumn;
        this.outputColumn = outputColumn;
        this.outputType = "decimal";
    }

    public FuncDoubleToDecimal() {
        this.outputType = "decimal";
    }

    protected abstract void func(DecimalColumnVector var1, DoubleColumnVector var2, int var3);

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DoubleColumnVector inV = (DoubleColumnVector)batch.cols[this.inputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        DecimalColumnVector outV = (DecimalColumnVector)batch.cols[this.outputColumn];
        if (n == 0) {
            return;
        }
        if (inV.noNulls) {
            outV.noNulls = true;
            if (inV.isRepeating) {
                outV.isRepeating = true;
                this.func(outV, inV, 0);
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.func(outV, inV, i);
                }
                outV.isRepeating = false;
            } else {
                for (int i = 0; i != n; ++i) {
                    this.func(outV, inV, i);
                }
                outV.isRepeating = false;
            }
        } else {
            outV.noNulls = false;
            if (inV.isRepeating) {
                outV.isRepeating = true;
                outV.isNull[0] = inV.isNull[0];
                if (!inV.isNull[0]) {
                    this.func(outV, inV, 0);
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outV.isNull[i] = inV.isNull[i];
                    if (inV.isNull[i]) continue;
                    this.func(outV, inV, i);
                }
                outV.isRepeating = false;
            } else {
                System.arraycopy(inV.isNull, 0, outV.isNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inV.isNull[i]) continue;
                    this.func(outV, inV, i);
                }
                outV.isRepeating = false;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public int getInputColumn() {
        return this.inputColumn;
    }

    public void setInputColumn(int inputColumn) {
        this.inputColumn = inputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.DOUBLE).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

