/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;

public class VectorizedRowBatch
implements Writable {
    public int numCols;
    public ColumnVector[] cols;
    public int size;
    public int[] selected;
    public int[] projectedColumns;
    public int projectionSize;
    public boolean selectedInUse;
    public boolean endOfFile;
    public static final int DEFAULT_SIZE = 1024;
    public VectorExpressionWriter[] valueWriters = null;

    public VectorizedRowBatch(int numCols) {
        this(numCols, 1024);
    }

    public VectorizedRowBatch(int numCols, int size) {
        this.numCols = numCols;
        this.size = size;
        this.selected = new int[size];
        this.selectedInUse = false;
        this.cols = new ColumnVector[numCols];
        this.projectedColumns = new int[numCols];
        this.projectionSize = numCols;
        for (int i = 0; i < numCols; ++i) {
            this.projectedColumns[i] = i;
        }
    }

    public long count() {
        return this.size;
    }

    private String toUTF8(Object o) {
        if (o == null || o instanceof NullWritable) {
            return "\\N";
        }
        return o.toString();
    }

    public String toString() {
        if (this.size == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        try {
            if (this.selectedInUse) {
                for (int j = 0; j < this.size; ++j) {
                    int i = this.selected[j];
                    for (int k = 0; k < this.projectionSize; ++k) {
                        int projIndex = this.projectedColumns[k];
                        ColumnVector cv = this.cols[projIndex];
                        if (k > 0) {
                            b.append('\u0001');
                        }
                        if (cv.isRepeating) {
                            b.append(this.toUTF8(this.valueWriters[k].writeValue(cv, 0)));
                            continue;
                        }
                        b.append(this.toUTF8(this.valueWriters[k].writeValue(cv, i)));
                    }
                    if (j >= this.size - 1) continue;
                    b.append('\n');
                }
            } else {
                for (int i = 0; i < this.size; ++i) {
                    for (int k = 0; k < this.projectionSize; ++k) {
                        int projIndex = this.projectedColumns[k];
                        ColumnVector cv = this.cols[projIndex];
                        if (k > 0) {
                            b.append('\u0001');
                        }
                        if (cv.isRepeating) {
                            b.append(this.toUTF8(this.valueWriters[k].writeValue(cv, 0)));
                            continue;
                        }
                        b.append(this.toUTF8(this.valueWriters[k].writeValue(cv, i)));
                    }
                    if (i >= this.size - 1) continue;
                    b.append('\n');
                }
            }
        }
        catch (HiveException ex) {
            throw new RuntimeException(ex);
        }
        return b.toString();
    }

    public void readFields(DataInput arg0) throws IOException {
        throw new UnsupportedOperationException("Do you really need me?");
    }

    public void write(DataOutput arg0) throws IOException {
        throw new UnsupportedOperationException("Don't call me");
    }

    public void setValueWriters(VectorExpressionWriter[] valueWriters) {
        this.valueWriters = valueWriters;
    }

    public void reset() {
        this.selectedInUse = false;
        this.size = 0;
        this.endOfFile = false;
        for (ColumnVector vc : this.cols) {
            if (vc == null) continue;
            vc.reset();
        }
    }
}

