/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class VectorReduceSinkOperator
extends ReduceSinkOperator {
    private static final Log LOG = LogFactory.getLog((String)VectorReduceSinkOperator.class.getName());
    private static final long serialVersionUID = 1L;
    private VectorExpression[] keyEval;
    private transient VectorExpressionWriter[] keyWriters;
    private VectorExpression[] valueEval;
    private transient VectorExpressionWriter[] valueWriters;
    private VectorExpression[] partitionEval;
    private VectorExpression[] bucketEval;
    private int buckColIdxInKey;
    private transient VectorExpressionWriter[] partitionWriters;
    private transient VectorExpressionWriter[] bucketWriters = null;

    public VectorReduceSinkOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        this();
        ReduceSinkDesc desc = (ReduceSinkDesc)conf;
        this.conf = desc;
        this.keyEval = vContext.getVectorExpressions(desc.getKeyCols());
        this.valueEval = vContext.getVectorExpressions(desc.getValueCols());
        this.partitionEval = vContext.getVectorExpressions(desc.getPartitionCols());
        this.bucketEval = null;
        if (desc.getBucketCols() != null && !desc.getBucketCols().isEmpty()) {
            this.bucketEval = vContext.getVectorExpressions(desc.getBucketCols());
            this.buckColIdxInKey = desc.getPartitionCols().size();
        }
    }

    public VectorReduceSinkOperator() {
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        try {
            this.numDistributionKeys = ((ReduceSinkDesc)this.conf).getNumDistributionKeys();
            this.distinctColIndices = ((ReduceSinkDesc)this.conf).getDistinctColumnIndices();
            this.numDistinctExprs = this.distinctColIndices.size();
            TableDesc keyTableDesc = ((ReduceSinkDesc)this.conf).getKeySerializeInfo();
            this.keySerializer = (Serializer)keyTableDesc.getDeserializerClass().newInstance();
            this.keySerializer.initialize(null, keyTableDesc.getProperties());
            this.keyIsText = this.keySerializer.getSerializedClass().equals(Text.class);
            VectorExpressionWriterFactory.processVectorExpressions(((ReduceSinkDesc)this.conf).getKeyCols(), ((ReduceSinkDesc)this.conf).getOutputKeyColumnNames(), new VectorExpressionWriterFactory.SingleOIDClosure(){

                @Override
                public void assign(VectorExpressionWriter[] writers, ObjectInspector objectInspector) {
                    VectorReduceSinkOperator.access$002(VectorReduceSinkOperator.this, writers);
                    VectorReduceSinkOperator.this.keyObjectInspector = objectInspector;
                }
            });
            String colNames = "";
            for (String colName : ((ReduceSinkDesc)this.conf).getOutputKeyColumnNames()) {
                colNames = String.format("%s %s", colNames, colName);
            }
            LOG.debug((Object)String.format("keyObjectInspector [%s]%s => %s", this.keyObjectInspector.getClass(), this.keyObjectInspector, colNames));
            this.partitionWriters = VectorExpressionWriterFactory.getExpressionWriters(((ReduceSinkDesc)this.conf).getPartitionCols());
            if (((ReduceSinkDesc)this.conf).getBucketCols() != null && !((ReduceSinkDesc)this.conf).getBucketCols().isEmpty()) {
                this.bucketWriters = VectorExpressionWriterFactory.getExpressionWriters(((ReduceSinkDesc)this.conf).getBucketCols());
            }
            TableDesc valueTableDesc = ((ReduceSinkDesc)this.conf).getValueSerializeInfo();
            this.valueSerializer = (Serializer)valueTableDesc.getDeserializerClass().newInstance();
            this.valueSerializer.initialize(null, valueTableDesc.getProperties());
            VectorExpressionWriterFactory.processVectorExpressions(((ReduceSinkDesc)this.conf).getValueCols(), ((ReduceSinkDesc)this.conf).getOutputValueColumnNames(), new VectorExpressionWriterFactory.SingleOIDClosure(){

                @Override
                public void assign(VectorExpressionWriter[] writers, ObjectInspector objectInspector) {
                    VectorReduceSinkOperator.access$202(VectorReduceSinkOperator.this, writers);
                    VectorReduceSinkOperator.this.valueObjectInspector = objectInspector;
                }
            });
            colNames = "";
            for (String colName : ((ReduceSinkDesc)this.conf).getOutputValueColumnNames()) {
                colNames = String.format("%s %s", colNames, colName);
            }
            LOG.debug((Object)String.format("valueObjectInspector [%s]%s => %s", this.valueObjectInspector.getClass(), this.valueObjectInspector, colNames));
            int numKeys = this.numDistinctExprs > 0 ? this.numDistinctExprs : 1;
            int keyLen = this.numDistinctExprs > 0 ? this.numDistributionKeys + 1 : this.numDistributionKeys;
            this.cachedKeys = new Object[numKeys][keyLen];
            this.cachedValues = new Object[this.valueEval.length];
            int tag = ((ReduceSinkDesc)this.conf).getTag();
            this.tagByte[0] = (byte)tag;
            LOG.info((Object)("Using tag = " + tag));
            int limit = ((ReduceSinkDesc)this.conf).getTopN();
            float memUsage = ((ReduceSinkDesc)this.conf).getTopNMemoryUsage();
            if (limit >= 0 && memUsage > 0.0f) {
                this.reducerHash.initialize(limit, memUsage, ((ReduceSinkDesc)this.conf).isMapGroupBy(), this);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        VectorizedRowBatch vrg = (VectorizedRowBatch)row;
        LOG.debug((Object)String.format("sinking %d rows, %d values, %d keys, %d parts", vrg.size, this.valueEval.length, this.keyEval.length, this.partitionEval.length));
        try {
            int batchIndex;
            int i;
            for (int i2 = 0; i2 < this.keyEval.length; ++i2) {
                this.keyEval[i2].evaluate(vrg);
            }
            int startResult = this.reducerHash.startVectorizedBatch(vrg.size);
            if (startResult == -2) {
                return;
            }
            for (i = 0; i < this.partitionEval.length; ++i) {
                this.partitionEval[i].evaluate(vrg);
            }
            if (this.bucketEval != null) {
                for (i = 0; i < this.bucketEval.length; ++i) {
                    this.bucketEval[i].evaluate(vrg);
                }
            }
            for (i = 0; i < this.valueEval.length; ++i) {
                this.valueEval[i].evaluate(vrg);
            }
            boolean useTopN = startResult != -1;
            for (batchIndex = 0; batchIndex < vrg.size; ++batchIndex) {
                int rowIndex = batchIndex;
                if (vrg.selectedInUse) {
                    rowIndex = vrg.selected[batchIndex];
                }
                this.populatedCachedDistributionKeys(vrg, rowIndex, 0);
                int buckNum = 0;
                if (this.bucketEval != null && this.bucketEval.length != 0) {
                    buckNum = this.computeBucketNumber(vrg, rowIndex, ((ReduceSinkDesc)this.conf).getNumBuckets());
                    this.cachedKeys[0][this.buckColIdxInKey] = new IntWritable(buckNum);
                }
                HiveKey firstKey = this.toHiveKey(this.cachedKeys[0], tag, null);
                int distKeyLength = firstKey.getDistKeyLength();
                if (this.numDistinctExprs > 0) {
                    this.populateCachedDistinctKeys(vrg, rowIndex, 0);
                    firstKey = this.toHiveKey(this.cachedKeys[0], tag, distKeyLength);
                }
                if (useTopN) {
                    this.reducerHash.tryStoreVectorizedKey(firstKey, batchIndex);
                    continue;
                }
                int hashCode = 0;
                hashCode = this.bucketEval != null && this.bucketEval.length != 0 ? this.computeHashCode(vrg, rowIndex, buckNum) : this.computeHashCode(vrg, rowIndex);
                firstKey.setHashCode(hashCode);
                BytesWritable value = this.makeValueWritable(vrg, rowIndex);
                this.collect(firstKey, (Writable)value);
                this.forwardExtraDistinctRows(vrg, rowIndex, hashCode, value, distKeyLength, tag, 0);
            }
            if (!useTopN) {
                return;
            }
            for (batchIndex = 0; batchIndex < vrg.size; ++batchIndex) {
                int result = this.reducerHash.getVectorizedBatchResult(batchIndex);
                if (result == -2) continue;
                int rowIndex = batchIndex;
                if (vrg.selectedInUse) {
                    rowIndex = vrg.selected[batchIndex];
                }
                int hashCode = this.computeHashCode(vrg, rowIndex);
                BytesWritable value = this.makeValueWritable(vrg, rowIndex);
                int distKeyLength = -1;
                if (result == -1) {
                    HiveKey firstKey = this.reducerHash.getVectorizedKeyToForward(batchIndex);
                    firstKey.setHashCode(hashCode);
                    distKeyLength = firstKey.getDistKeyLength();
                    this.collect(firstKey, (Writable)value);
                } else {
                    this.reducerHash.storeValue(result, value, hashCode, true);
                    distKeyLength = this.reducerHash.getVectorizedKeyDistLength(batchIndex);
                }
                if (this.numDistinctExprs <= 1) continue;
                this.populatedCachedDistributionKeys(vrg, rowIndex, 1);
                this.forwardExtraDistinctRows(vrg, rowIndex, hashCode, value, distKeyLength, tag, 1);
            }
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private void forwardExtraDistinctRows(VectorizedRowBatch vrg, int rowIndex, int hashCode, BytesWritable value, int distKeyLength, int tag, int baseIndex) throws HiveException, SerDeException, IOException {
        for (int i = 1; i < this.numDistinctExprs; ++i) {
            if (i != baseIndex) {
                System.arraycopy(this.cachedKeys[baseIndex], 0, this.cachedKeys[i], 0, this.numDistributionKeys);
            }
            this.populateCachedDistinctKeys(vrg, rowIndex, i);
            HiveKey hiveKey = this.toHiveKey(this.cachedKeys[i], tag, distKeyLength);
            hiveKey.setHashCode(hashCode);
            this.collect(hiveKey, (Writable)value);
        }
    }

    private void populatedCachedDistributionKeys(VectorizedRowBatch vrg, int rowIndex, int index) throws HiveException {
        for (int i = 0; i < this.numDistributionKeys; ++i) {
            int batchColumn = this.keyEval[i].getOutputColumn();
            ColumnVector vectorColumn = vrg.cols[batchColumn];
            this.cachedKeys[index][i] = this.keyWriters[i].writeValue(vectorColumn, rowIndex);
        }
        if (this.cachedKeys[index].length > this.numDistributionKeys) {
            this.cachedKeys[index][this.numDistributionKeys] = null;
        }
    }

    private void populateCachedDistinctKeys(VectorizedRowBatch vrg, int rowIndex, int index) throws HiveException {
        StandardUnionObjectInspector.StandardUnion union = new StandardUnionObjectInspector.StandardUnion((byte)index, (Object)new Object[((List)this.distinctColIndices.get(index)).size()]);
        this.cachedKeys[index][this.numDistributionKeys] = union;
        Object[] distinctParameters = (Object[])union.getObject();
        for (int distinctParamI = 0; distinctParamI < distinctParameters.length; ++distinctParamI) {
            int distinctColIndex = (Integer)((List)this.distinctColIndices.get(index)).get(distinctParamI);
            int batchColumn = this.keyEval[distinctColIndex].getOutputColumn();
            distinctParameters[distinctParamI] = this.keyWriters[distinctColIndex].writeValue(vrg.cols[batchColumn], rowIndex);
        }
        union.setTag((byte)index);
    }

    private BytesWritable makeValueWritable(VectorizedRowBatch vrg, int rowIndex) throws HiveException, SerDeException {
        for (int i = 0; i < this.valueEval.length; ++i) {
            int batchColumn = this.valueEval[i].getOutputColumn();
            ColumnVector vectorColumn = vrg.cols[batchColumn];
            this.cachedValues[i] = this.valueWriters[i].writeValue(vectorColumn, rowIndex);
        }
        return (BytesWritable)this.valueSerializer.serialize((Object)this.cachedValues, this.valueObjectInspector);
    }

    private int computeHashCode(VectorizedRowBatch vrg, int rowIndex) throws HiveException {
        int keyHashCode = 0;
        if (this.partitionEval.length == 0) {
            if (this.random == null) {
                this.random = new Random(12345L);
            }
            keyHashCode = this.random.nextInt();
        } else {
            for (int p = 0; p < this.partitionEval.length; ++p) {
                ColumnVector columnVector = vrg.cols[this.partitionEval[p].getOutputColumn()];
                Object partitionValue = this.partitionWriters[p].writeValue(columnVector, rowIndex);
                keyHashCode = keyHashCode * 31 + ObjectInspectorUtils.hashCode((Object)partitionValue, (ObjectInspector)this.partitionWriters[p].getObjectInspector());
            }
        }
        return keyHashCode;
    }

    private int computeHashCode(VectorizedRowBatch vrg, int rowIndex, int buckNum) throws HiveException {
        int keyHashCode = this.computeHashCode(vrg, rowIndex);
        keyHashCode = keyHashCode * 31 + buckNum;
        return keyHashCode;
    }

    private int computeBucketNumber(VectorizedRowBatch vrg, int rowIndex, int numBuckets) throws HiveException {
        int bucketNum = 0;
        for (int p = 0; p < this.bucketEval.length; ++p) {
            ColumnVector columnVector = vrg.cols[this.bucketEval[p].getOutputColumn()];
            Object bucketValue = this.bucketWriters[p].writeValue(columnVector, rowIndex);
            bucketNum = bucketNum * 31 + ObjectInspectorUtils.hashCode((Object)bucketValue, (ObjectInspector)this.bucketWriters[p].getObjectInspector());
        }
        if (bucketNum < 0) {
            bucketNum = -1 * bucketNum;
        }
        return bucketNum % numBuckets;
    }

    public static String getOperatorName() {
        return "RS";
    }

    public VectorExpression[] getPartitionEval() {
        return this.partitionEval;
    }

    public void setPartitionEval(VectorExpression[] partitionEval) {
        this.partitionEval = partitionEval;
    }

    public VectorExpression[] getValueEval() {
        return this.valueEval;
    }

    public void setValueEval(VectorExpression[] valueEval) {
        this.valueEval = valueEval;
    }

    public VectorExpression[] getKeyEval() {
        return this.keyEval;
    }

    public void setKeyEval(VectorExpression[] keyEval) {
        this.keyEval = keyEval;
    }

    static /* synthetic */ VectorExpressionWriter[] access$002(VectorReduceSinkOperator x0, VectorExpressionWriter[] x1) {
        x0.keyWriters = x1;
        return x1;
    }

    static /* synthetic */ VectorExpressionWriter[] access$202(VectorReduceSinkOperator x0, VectorExpressionWriter[] x1) {
        x0.valueWriters = x1;
        return x1;
    }
}

