/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Arrays;
import org.apache.hadoop.hive.common.type.Decimal128;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class VectorHashKeyWrapper
extends KeyWrapper {
    private long[] longValues;
    private double[] doubleValues;
    private byte[][] byteValues;
    private int[] byteStarts;
    private int[] byteLengths;
    private Decimal128[] decimalValues;
    private boolean[] isNull;
    private int hashcode;

    public VectorHashKeyWrapper(int longValuesCount, int doubleValuesCount, int byteValuesCount, int decimalValuesCount) {
        this.longValues = new long[longValuesCount];
        this.doubleValues = new double[doubleValuesCount];
        this.decimalValues = new Decimal128[decimalValuesCount];
        for (int i = 0; i < decimalValuesCount; ++i) {
            this.decimalValues[i] = new Decimal128();
        }
        this.byteValues = new byte[byteValuesCount][];
        this.byteStarts = new int[byteValuesCount];
        this.byteLengths = new int[byteValuesCount];
        this.isNull = new boolean[longValuesCount + doubleValuesCount + byteValuesCount + decimalValuesCount];
    }

    private VectorHashKeyWrapper() {
    }

    @Override
    public void getNewKey(Object row, ObjectInspector rowInspector) throws HiveException {
        throw new HiveException("Should not be called");
    }

    @Override
    public void setHashKey() {
        this.hashcode = Arrays.hashCode(this.longValues) ^ Arrays.hashCode(this.doubleValues) ^ Arrays.hashCode(this.decimalValues) ^ Arrays.hashCode(this.isNull);
        for (int i = 0; i < this.byteValues.length; ++i) {
            if (this.isNull[this.longValues.length + this.doubleValues.length + i]) continue;
            byte[] bytes = this.byteValues[i];
            int start = this.byteStarts[i];
            int length = this.byteLengths[i];
            if (length == bytes.length && start == 0) {
                this.hashcode ^= Arrays.hashCode(bytes);
                continue;
            }
            for (int j = start; j < start + length; ++j) {
                this.hashcode ^= 461 * bytes[j];
            }
        }
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object that) {
        if (that instanceof VectorHashKeyWrapper) {
            VectorHashKeyWrapper keyThat = (VectorHashKeyWrapper)that;
            return this.hashcode == keyThat.hashcode && Arrays.equals(this.longValues, keyThat.longValues) && Arrays.equals(this.doubleValues, keyThat.doubleValues) && Arrays.equals(this.decimalValues, keyThat.decimalValues) && Arrays.equals(this.isNull, keyThat.isNull) && this.byteValues.length == keyThat.byteValues.length && (0 == this.byteValues.length || this.bytesEquals(keyThat));
        }
        return false;
    }

    private boolean bytesEquals(VectorHashKeyWrapper keyThat) {
        for (int i = 0; i < this.byteValues.length; ++i) {
            if (this.isNull[this.longValues.length + this.doubleValues.length + i] || 0 == StringExpr.compare(this.byteValues[i], this.byteStarts[i], this.byteLengths[i], keyThat.byteValues[i], keyThat.byteStarts[i], keyThat.byteLengths[i])) continue;
            return false;
        }
        return true;
    }

    protected Object clone() {
        VectorHashKeyWrapper clone = new VectorHashKeyWrapper();
        this.duplicateTo(clone);
        return clone;
    }

    public void duplicateTo(VectorHashKeyWrapper clone) {
        int i;
        clone.longValues = (long[])this.longValues.clone();
        clone.doubleValues = (double[])this.doubleValues.clone();
        clone.isNull = (boolean[])this.isNull.clone();
        clone.decimalValues = new Decimal128[this.decimalValues.length];
        for (i = 0; i < this.decimalValues.length; ++i) {
            clone.decimalValues[i] = new Decimal128().update(this.decimalValues[i]);
        }
        clone.byteValues = new byte[this.byteValues.length][];
        clone.byteStarts = new int[this.byteValues.length];
        clone.byteLengths = (int[])this.byteLengths.clone();
        for (i = 0; i < this.byteValues.length; ++i) {
            if (this.isNull[this.longValues.length + this.doubleValues.length + i]) continue;
            clone.byteValues[i] = Arrays.copyOfRange(this.byteValues[i], this.byteStarts[i], this.byteStarts[i] + this.byteLengths[i]);
        }
        clone.hashcode = this.hashcode;
        assert (clone.equals(this));
    }

    @Override
    public KeyWrapper copyKey() {
        return (KeyWrapper)this.clone();
    }

    @Override
    public void copyKey(KeyWrapper oldWrapper) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] getKeyArray() {
        throw new UnsupportedOperationException();
    }

    public void assignDouble(int index, double d) {
        this.doubleValues[index] = d;
        this.isNull[this.longValues.length + index] = false;
    }

    public void assignNullDouble(int index) {
        this.doubleValues[index] = 0.0;
        this.isNull[this.longValues.length + index] = true;
    }

    public void assignLong(int index, long v) {
        this.longValues[index] = v;
        this.isNull[index] = false;
    }

    public void assignNullLong(int index) {
        this.longValues[index] = 0L;
        this.isNull[index] = true;
    }

    public void assignString(int index, byte[] bytes, int start, int length) {
        this.byteValues[index] = bytes;
        this.byteStarts[index] = start;
        this.byteLengths[index] = length;
        this.isNull[this.longValues.length + this.doubleValues.length + index] = false;
    }

    public void assignNullString(int index) {
        this.isNull[this.longValues.length + this.doubleValues.length + index] = true;
    }

    public void assignDecimal(int index, Decimal128 value) {
        this.decimalValues[index].update(value);
        this.isNull[this.longValues.length + this.doubleValues.length + this.byteValues.length + index] = false;
    }

    public void assignNullDecimal(int index) {
        this.isNull[this.longValues.length + this.doubleValues.length + this.byteValues.length + index] = true;
    }

    public String toString() {
        return String.format("%d[%s] %d[%s] %d[%s] %d[%s]", this.longValues.length, Arrays.toString(this.longValues), this.doubleValues.length, Arrays.toString(this.doubleValues), this.byteValues.length, Arrays.toString((Object[])this.byteValues), this.decimalValues.length, Arrays.toString(this.decimalValues));
    }

    public boolean getIsLongNull(int i) {
        return this.isNull[i];
    }

    public boolean getIsDoubleNull(int i) {
        return this.isNull[this.longValues.length + i];
    }

    public boolean getIsBytesNull(int i) {
        return this.isNull[this.longValues.length + this.doubleValues.length + i];
    }

    public long getLongValue(int i) {
        return this.longValues[i];
    }

    public double getDoubleValue(int i) {
        return this.doubleValues[i];
    }

    public byte[] getBytes(int i) {
        return this.byteValues[i];
    }

    public int getByteStart(int i) {
        return this.byteStarts[i];
    }

    public int getByteLength(int i) {
        return this.byteLengths[i];
    }

    public int getVariableSize() {
        int variableSize = 0;
        for (int i = 0; i < this.byteLengths.length; ++i) {
            JavaDataModel model = JavaDataModel.get();
            variableSize += model.lengthForByteArrayOfSize(this.byteLengths[i]);
        }
        return variableSize;
    }

    public boolean getIsDecimalNull(int i) {
        return this.isNull[this.longValues.length + this.doubleValues.length + this.byteValues.length + i];
    }

    public Decimal128 getDecimal(int i) {
        return this.decimalValues[i];
    }
}

