/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class VectorExpressionDescriptor {
    static final int MAX_NUM_ARGUMENTS = 3;

    public Class<?> getVectorExpressionClass(Class<?> udf, Descriptor descriptor) throws HiveException {
        Class<? extends VectorExpression>[] list;
        VectorizedExpressions annotation = udf.getAnnotation(VectorizedExpressions.class);
        if (annotation == null || annotation.value() == null) {
            return null;
        }
        for (Class<? extends VectorExpression> ve : list = annotation.value()) {
            try {
                if (!ve.newInstance().getDescriptor().equals(descriptor)) continue;
                return ve;
            }
            catch (Exception ex) {
                throw new HiveException(ex);
            }
        }
        return null;
    }

    public static final class Descriptor {
        private final Mode mode;
        private final ArgumentType[] argTypes;
        private final InputExpressionType[] exprTypes;
        private final int argCount;

        public boolean equals(Object o) {
            Descriptor other = (Descriptor)o;
            if (!this.mode.equals((Object)other.mode) || this.argCount != other.argCount) {
                return false;
            }
            for (int i = 0; i < this.argCount; ++i) {
                if (!(this.argTypes[i].equals((Object)other.argTypes[i]) || this.argTypes[i].equals((Object)ArgumentType.ANY) || other.argTypes[i].equals((Object)ArgumentType.ANY))) {
                    return false;
                }
                if (this.exprTypes[i].equals((Object)other.exprTypes[i])) continue;
                return false;
            }
            return true;
        }

        private Descriptor(Mode mode, int argCount, ArgumentType[] argTypes, InputExpressionType[] exprTypes) {
            this.mode = mode;
            this.argTypes = (ArgumentType[])argTypes.clone();
            this.exprTypes = (InputExpressionType[])exprTypes.clone();
            this.argCount = argCount;
        }

        public String toString() {
            int i;
            StringBuilder b = new StringBuilder("Argument Count = ");
            b.append(this.argCount);
            b.append(", mode = ");
            b.append((Object)this.mode);
            b.append(", Argument Types = {");
            for (i = 0; i < this.argCount; ++i) {
                if (i != 0) {
                    b.append(",");
                }
                b.append((Object)this.argTypes[i]);
            }
            b.append("}");
            b.append(", Input Expression Types = {");
            for (i = 0; i < this.argCount; ++i) {
                if (i != 0) {
                    b.append(",");
                }
                b.append((Object)this.exprTypes[i]);
            }
            b.append("}");
            return b.toString();
        }
    }

    public static class Builder {
        private Mode mode = Mode.PROJECTION;
        ArgumentType[] argTypes = new ArgumentType[3];
        InputExpressionType[] exprTypes = new InputExpressionType[3];
        private int argCount = 0;

        public Builder() {
            for (int i = 0; i < 3; ++i) {
                this.argTypes[i] = ArgumentType.NONE;
                this.exprTypes[i] = InputExpressionType.NONE;
            }
        }

        public Builder setMode(Mode m) {
            this.mode = m;
            return this;
        }

        public Builder setNumArguments(int argCount) {
            this.argCount = argCount;
            return this;
        }

        public Builder setArgumentTypes(ArgumentType ... types) {
            for (int i = 0; i < types.length; ++i) {
                this.argTypes[i] = types[i];
            }
            return this;
        }

        public Builder setArgumentTypes(String ... types) {
            for (int i = 0; i < types.length; ++i) {
                this.argTypes[i] = ArgumentType.getType(types[i]);
            }
            return this;
        }

        public Builder setArgumentType(int index, ArgumentType type) {
            this.argTypes[index] = type;
            return this;
        }

        public Builder setArgumentType(int index, String type) {
            this.argTypes[index] = ArgumentType.getType(type);
            return this;
        }

        public Builder setInputExpressionTypes(InputExpressionType ... types) {
            for (int i = 0; i < types.length; ++i) {
                this.exprTypes[i] = types[i];
            }
            return this;
        }

        public Builder setInputExpressionType(int index, InputExpressionType type) {
            this.exprTypes[index] = type;
            return this;
        }

        public Descriptor build() {
            return new Descriptor(this.mode, this.argCount, this.argTypes, this.exprTypes);
        }
    }

    public static enum Mode {
        PROJECTION(0),
        FILTER(1);

        private final int value;

        private Mode(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum InputExpressionType {
        NONE(0),
        COLUMN(1),
        SCALAR(2);

        private final int value;

        private InputExpressionType(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ArgumentType {
        NONE(0),
        LONG(1),
        DOUBLE(2),
        STRING(3),
        DECIMAL(4),
        ANY(7);

        private final int value;

        private ArgumentType(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public static ArgumentType getType(String inType) {
            String type = VectorizationContext.getNormalizedTypeName(inType);
            if (VectorizationContext.decimalTypePattern.matcher(type).matches()) {
                type = "decimal";
            }
            return ArgumentType.valueOf(type.toUpperCase());
        }
    }
}

