/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.sql.Timestamp;

public final class TimestampUtils {
    public static void assignTimeInNanoSec(long timeInNanoSec, Timestamp t) {
        long integralSecInMillis = timeInNanoSec / 1000000000L * 1000L;
        long nanos = timeInNanoSec % 1000000000L;
        if (nanos < 0L) {
            nanos = 1000000000L + nanos;
            integralSecInMillis = (timeInNanoSec / 1000000000L - 1L) * 1000L;
        }
        t.setTime(integralSecInMillis);
        t.setNanos((int)nanos);
    }

    public static long getTimeNanoSec(Timestamp t) {
        long time = t.getTime();
        int nanos = t.getNanos();
        return time * 1000000L + (long)(nanos % 1000000);
    }
}

