/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Arrays;
import org.apache.hadoop.io.Writable;

public abstract class ColumnVector {
    public boolean[] isNull;
    public boolean noNulls;
    public boolean isRepeating;
    private boolean preFlattenIsRepeating;
    private boolean preFlattenNoNulls;

    public abstract Writable getWritableObject(int var1);

    public ColumnVector(int len) {
        this.isNull = new boolean[len];
        this.noNulls = true;
        this.isRepeating = false;
    }

    public void reset() {
        if (!this.noNulls) {
            Arrays.fill(this.isNull, false);
        }
        this.noNulls = true;
        this.isRepeating = false;
    }

    public abstract void flatten(boolean var1, int[] var2, int var3);

    public void flattenRepeatingNulls(boolean selectedInUse, int[] sel, int size) {
        boolean nullFillValue = this.noNulls ? false : this.isNull[0];
        if (selectedInUse) {
            for (int j = 0; j < size; ++j) {
                int i = sel[j];
                this.isNull[i] = nullFillValue;
            }
        } else {
            Arrays.fill(this.isNull, 0, size, nullFillValue);
        }
        this.noNulls = false;
    }

    public void flattenNoNulls(boolean selectedInUse, int[] sel, int size) {
        if (this.noNulls) {
            this.noNulls = false;
            if (selectedInUse) {
                for (int j = 0; j < size; ++j) {
                    int i = sel[j];
                    this.isNull[i] = false;
                }
            } else {
                Arrays.fill(this.isNull, 0, size, false);
            }
        }
    }

    public void unFlatten() {
        this.isRepeating = this.preFlattenIsRepeating;
        this.noNulls = this.preFlattenNoNulls;
    }

    protected void flattenPush() {
        this.preFlattenIsRepeating = this.isRepeating;
        this.preFlattenNoNulls = this.noNulls;
    }

    public abstract void setElement(int var1, int var2, ColumnVector var3);

    public void init() {
    }
}

