/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.DagUtils;
import org.apache.hadoop.hive.ql.exec.tez.TezJobMonitor;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.TezEdgeProperty;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.UnionWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.GroupInputEdge;
import org.apache.tez.dag.api.SessionNotRunning;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.StatusGetOpts;

public class TezTask
extends Task<TezWork> {
    private static final String CLASS_NAME = TezTask.class.getName();
    private final PerfLogger perfLogger = PerfLogger.getPerfLogger();
    private TezCounters counters;
    private final DagUtils utils;

    public TezTask() {
        this(DagUtils.getInstance());
    }

    public TezTask(DagUtils utils) {
        this.utils = utils;
    }

    public TezCounters getTezCounters() {
        return this.counters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(DriverContext driverContext) {
        int rc = 1;
        boolean cleanContext = false;
        Context ctx = null;
        DAGClient client = null;
        TezSessionState session = null;
        try {
            ctx = driverContext.getCtx();
            if (ctx == null) {
                ctx = new Context((Configuration)this.conf);
                cleanContext = true;
            }
            SessionState ss = SessionState.get();
            session = ss.getTezSession();
            session = TezSessionPoolManager.getInstance().getSession(session, this.conf, false);
            ss.setTezSession(session);
            JobConf jobConf = this.utils.createConfiguration(this.conf);
            String[] inputOutputJars = ((TezWork)this.work).configureJobConfAndExtractJars(jobConf);
            Path scratchDir = ctx.getMRScratchDir();
            scratchDir = this.utils.createTezDir(scratchDir, (Configuration)this.conf);
            boolean hasResources = session.hasResources(inputOutputJars);
            if (ss.hasAddedResource()) {
                hasResources = false;
                ss.setAddedResource(false);
            }
            if (!hasResources && session.isOpen()) {
                LOG.info((Object)"Tez session being reopened to pass custom jars to AM");
                TezSessionPoolManager.getInstance().close(session);
                session = TezSessionPoolManager.getInstance().getSession(null, this.conf, false);
                ss.setTezSession(session);
            }
            if (!session.isOpen()) {
                LOG.info((Object)"Tez session hasn't been created yet. Opening session");
                session.open(this.conf, inputOutputJars);
            }
            List<LocalResource> additionalLr = session.getLocalizedResources();
            LocalResource appJarLr = session.getAppJarLr();
            DAG dag = this.build(jobConf, (TezWork)this.work, scratchDir, appJarLr, additionalLr, ctx);
            client = this.submit(jobConf, dag, scratchDir, appJarLr, session);
            TezJobMonitor monitor = new TezJobMonitor();
            rc = monitor.monitorExecution(client, ctx.getHiveTxnManager(), this.conf);
            EnumSet<StatusGetOpts> statusGetOpts = EnumSet.of(StatusGetOpts.GET_COUNTERS);
            this.counters = client.getDAGStatus(statusGetOpts).getDAGCounters();
            TezSessionPoolManager.getInstance().returnSession(session);
            if (LOG.isInfoEnabled()) {
                for (CounterGroup group : this.counters) {
                    LOG.info((Object)(group.getDisplayName() + ":"));
                    for (TezCounter counter : group) {
                        LOG.info((Object)("   " + counter.getDisplayName() + ": " + counter.getValue()));
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to execute tez graph.", (Throwable)e);
        }
        finally {
            Utilities.clearWork((Configuration)this.conf);
            if (cleanContext) {
                try {
                    ctx.clear();
                }
                catch (Exception e) {
                    LOG.warn((Object)"Failed to clean up after tez job");
                }
            }
            if (client != null) {
                rc = this.close((TezWork)this.work, rc);
            }
        }
        return rc;
    }

    DAG build(JobConf conf, TezWork work, Path scratchDir, LocalResource appJarLr, List<LocalResource> additionalLr, Context ctx) throws Exception {
        this.perfLogger.PerfLogBegin(CLASS_NAME, "TezBuildDag");
        HashMap<BaseWork, Vertex> workToVertex = new HashMap<BaseWork, Vertex>();
        HashMap<BaseWork, JobConf> workToConf = new HashMap<BaseWork, JobConf>();
        List<BaseWork> ws = work.getAllWork();
        Collections.reverse(ws);
        FileSystem fs = scratchDir.getFileSystem((Configuration)conf);
        DAG dag = new DAG(work.getName());
        for (BaseWork w : ws) {
            boolean isFinal = work.getLeaves().contains(w);
            this.perfLogger.PerfLogBegin(CLASS_NAME, "TezCreateVertex." + w.getName());
            if (w instanceof UnionWork) {
                LinkedList<BaseWork> unionWorkItems = new LinkedList<BaseWork>();
                LinkedList<BaseWork> children = new LinkedList<BaseWork>();
                for (BaseWork v : work.getChildren(w)) {
                    TezEdgeProperty.EdgeType type = work.getEdgeProperty(w, v).getEdgeType();
                    if (type == TezEdgeProperty.EdgeType.CONTAINS) {
                        unionWorkItems.add(v);
                        continue;
                    }
                    children.add(v);
                }
                Vertex[] vertexArray = new Vertex[unionWorkItems.size()];
                int i = 0;
                for (BaseWork v : unionWorkItems) {
                    vertexArray[i++] = (Vertex)workToVertex.get(v);
                }
                VertexGroup group = dag.createVertexGroup(w.getName(), vertexArray);
                for (BaseWork v : children) {
                    for (BaseWork part : unionWorkItems) {
                        this.utils.updateConfigurationForEdge((JobConf)workToConf.get(part), (Vertex)workToVertex.get(part), (JobConf)workToConf.get(v), (Vertex)workToVertex.get(v));
                    }
                    GroupInputEdge e = this.utils.createEdge(group, (JobConf)workToConf.get(v), (Vertex)workToVertex.get(v), work.getEdgeProperty(w, v));
                    dag.addEdge(e);
                }
                continue;
            }
            JobConf wxConf = this.utils.initializeVertexConf(conf, w);
            Vertex wx = this.utils.createVertex(wxConf, w, scratchDir, appJarLr, additionalLr, fs, ctx, !isFinal, work);
            dag.addVertex(wx);
            this.utils.addCredentials(w, dag);
            this.perfLogger.PerfLogEnd(CLASS_NAME, "TezCreateVertex." + w.getName());
            workToVertex.put(w, wx);
            workToConf.put(w, wxConf);
            for (BaseWork v : work.getChildren(w)) {
                assert (workToVertex.containsKey(v));
                Edge e = null;
                TezEdgeProperty edgeProp = work.getEdgeProperty(w, v);
                e = this.utils.createEdge(wxConf, wx, (JobConf)workToConf.get(v), (Vertex)workToVertex.get(v), edgeProp);
                dag.addEdge(e);
            }
        }
        this.perfLogger.PerfLogEnd(CLASS_NAME, "TezBuildDag");
        return dag;
    }

    DAGClient submit(JobConf conf, DAG dag, Path scratchDir, LocalResource appJarLr, TezSessionState sessionState) throws IOException, TezException, InterruptedException, LoginException, URISyntaxException, HiveException {
        this.perfLogger.PerfLogBegin(CLASS_NAME, "TezSubmitDag");
        DAGClient dagClient = null;
        try {
            dagClient = sessionState.getSession().submitDAG(dag);
        }
        catch (SessionNotRunning nr) {
            this.console.printInfo("Tez session was closed. Reopening...");
            sessionState.close(true);
            sessionState.open(this.conf);
            this.console.printInfo("Session re-established.");
            dagClient = sessionState.getSession().submitDAG(dag);
        }
        this.perfLogger.PerfLogEnd(CLASS_NAME, "TezSubmitDag");
        return dagClient;
    }

    int close(TezWork work, int rc) {
        block4: {
            try {
                List<BaseWork> ws = work.getAllWork();
                for (BaseWork w : ws) {
                    for (Operator<?> op : w.getAllOperators()) {
                        op.jobClose((Configuration)this.conf, rc == 0);
                    }
                }
            }
            catch (Exception e) {
                if (rc != 0) break block4;
                rc = 3;
                String mesg = "Job Commit failed with exception '" + Utilities.getNameMessage(e) + "'";
                this.console.printError(mesg, "\n" + StringUtils.stringifyException((Throwable)e));
            }
        }
        return rc;
    }

    @Override
    public boolean isMapRedTask() {
        return true;
    }

    @Override
    public StageType getType() {
        return StageType.MAPRED;
    }

    @Override
    public String getName() {
        return "TEZ";
    }
}

