/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.tez.MapRecordProcessor;
import org.apache.hadoop.hive.ql.exec.tez.RecordProcessor;
import org.apache.hadoop.hive.ql.exec.tez.ReduceRecordProcessor;
import org.apache.hadoop.hive.ql.exec.tez.TezCacheAccess;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.tez.common.TezUtils;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalIOProcessor;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.TezProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueWriter;

public class TezProcessor
implements LogicalIOProcessor {
    private static final Log LOG = LogFactory.getLog(TezProcessor.class);
    private boolean isMap = false;
    RecordProcessor rproc = null;
    private JobConf jobConf;
    private static final String CLASS_NAME = TezProcessor.class.getName();
    private final PerfLogger perfLogger = PerfLogger.getPerfLogger();
    private TezProcessorContext processorContext;
    protected static final NumberFormat taskIdFormat = NumberFormat.getInstance();
    protected static final NumberFormat jobIdFormat = NumberFormat.getInstance();

    public TezProcessor(boolean isMap) {
        this.isMap = isMap;
    }

    public void close() throws IOException {
    }

    public void handleEvents(List<Event> arg0) {
    }

    public void initialize(TezProcessorContext processorContext) throws IOException {
        this.perfLogger.PerfLogBegin(CLASS_NAME, "TezInitializeProcessor");
        this.processorContext = processorContext;
        byte[] userPayload = processorContext.getUserPayload();
        Configuration conf = TezUtils.createConfFromUserPayload((byte[])userPayload);
        this.jobConf = new JobConf(conf);
        this.setupMRLegacyConfigs(processorContext);
        this.perfLogger.PerfLogEnd(CLASS_NAME, "TezInitializeProcessor");
    }

    private void setupMRLegacyConfigs(TezProcessorContext processorContext) {
        StringBuilder taskAttemptIdBuilder = new StringBuilder("task");
        taskAttemptIdBuilder.append(processorContext.getApplicationId().getClusterTimestamp()).append("_").append(jobIdFormat.format(processorContext.getApplicationId().getId())).append("_");
        if (this.isMap) {
            taskAttemptIdBuilder.append("m_");
        } else {
            taskAttemptIdBuilder.append("r_");
        }
        taskAttemptIdBuilder.append(taskIdFormat.format(processorContext.getTaskIndex())).append("_").append(processorContext.getTaskAttemptNumber());
        String taskAttemptIdStr = taskAttemptIdBuilder.toString();
        this.jobConf.set("mapred.task.id", taskAttemptIdStr);
        this.jobConf.set("mapreduce.task.attempt.id", taskAttemptIdStr);
        this.jobConf.setInt("mapred.task.partition", processorContext.getTaskIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        block18: {
            Exception processingException = null;
            try {
                this.perfLogger.PerfLogBegin(CLASS_NAME, "TezRunProcessor");
                LOG.info((Object)("Running task: " + this.processorContext.getUniqueIdentifier()));
                if (this.isMap) {
                    this.rproc = new MapRecordProcessor();
                    MRInputLegacy mrInput = TezProcessor.getMRInput(inputs);
                    try {
                        mrInput.init();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed while initializing MRInput", e);
                    }
                } else {
                    this.rproc = new ReduceRecordProcessor();
                }
                TezCacheAccess cacheAccess = TezCacheAccess.createInstance((Configuration)this.jobConf);
                for (Map.Entry<String, LogicalInput> inputEntry : inputs.entrySet()) {
                    if (!cacheAccess.isInputCached(inputEntry.getKey())) {
                        LOG.info((Object)("Input: " + inputEntry.getKey() + " is not cached"));
                        inputEntry.getValue().start();
                        continue;
                    }
                    LOG.info((Object)("Input: " + inputEntry.getKey() + " is already cached. Skipping start"));
                }
                MRTaskReporter mrReporter = new MRTaskReporter(this.processorContext);
                this.rproc.init(this.jobConf, this.processorContext, mrReporter, inputs, outputs);
                this.rproc.run();
                this.perfLogger.PerfLogEnd(CLASS_NAME, "TezRunProcessor");
            }
            catch (Exception e) {
                processingException = e;
            }
            finally {
                block19: {
                    try {
                        if (this.rproc != null) {
                            this.rproc.close();
                        }
                    }
                    catch (Exception e) {
                        if (processingException != null) break block19;
                        processingException = e;
                    }
                }
                if (processingException == null) break block18;
                throw processingException;
            }
        }
    }

    static MRInputLegacy getMRInput(Map<String, LogicalInput> inputs) {
        MRInputLegacy theMRInput = null;
        for (LogicalInput inp : inputs.values()) {
            if (!(inp instanceof MRInputLegacy)) continue;
            if (theMRInput != null) {
                throw new IllegalArgumentException("Only one MRInput is expected");
            }
            theMRInput = (MRInputLegacy)inp;
        }
        return theMRInput;
    }

    static {
        taskIdFormat.setGroupingUsed(false);
        taskIdFormat.setMinimumIntegerDigits(6);
        jobIdFormat.setGroupingUsed(false);
        jobIdFormat.setMinimumIntegerDigits(4);
    }

    static class TezKVOutputCollector
    implements OutputCollector {
        private KeyValueWriter writer;
        private final LogicalOutput output;

        TezKVOutputCollector(LogicalOutput logicalOutput) {
            this.output = logicalOutput;
        }

        void initialize() throws Exception {
            this.writer = (KeyValueWriter)this.output.getWriter();
        }

        public void collect(Object key, Object value) throws IOException {
            this.writer.write(key, value);
        }
    }
}

