/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.tez.RecordProcessor;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.exec.tez.TezProcessor;
import org.apache.hadoop.hive.ql.exec.tez.tools.InputMerger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.TezProcessorContext;
import org.apache.tez.runtime.library.api.KeyValuesReader;

public class ReduceRecordProcessor
extends RecordProcessor {
    private static final String REDUCE_PLAN_KEY = "__REDUCE_PLAN__";
    public static final Log l4j = LogFactory.getLog(ReduceRecordProcessor.class);
    private final ExecMapperContext execContext = new ExecMapperContext();
    private boolean abort = false;
    private Deserializer inputKeyDeserializer;
    private final SerDe[] inputValueDeserializer = new SerDe[127];
    TableDesc keyTableDesc;
    TableDesc[] valueTableDesc;
    ObjectInspector[] rowObjectInspector;
    private Operator<?> reducer;
    private boolean isTagged = false;
    private Object keyObject = null;
    private BytesWritable groupKey;
    private ReduceWork redWork;
    List<Object> row = new ArrayList<Object>(Utilities.reduceFieldNameList.size());

    @Override
    void init(JobConf jconf, TezProcessorContext processorContext, MRTaskReporter mrReporter, Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        this.perfLogger.PerfLogBegin(this.CLASS_NAME, "TezInitializeOperators");
        super.init(jconf, processorContext, mrReporter, inputs, outputs);
        ObjectCache cache = ObjectCacheFactory.getCache((Configuration)jconf);
        this.rowObjectInspector = new ObjectInspector[127];
        ObjectInspector[] valueObjectInspector = new ObjectInspector[127];
        this.redWork = (ReduceWork)cache.retrieve(REDUCE_PLAN_KEY);
        if (this.redWork == null) {
            this.redWork = Utilities.getReduceWork((Configuration)jconf);
            cache.cache(REDUCE_PLAN_KEY, this.redWork);
        } else {
            Utilities.setReduceWork((Configuration)jconf, this.redWork);
        }
        this.reducer = this.redWork.getReducer();
        this.reducer.setParentOperators(null);
        this.isTagged = this.redWork.getNeedsTagging();
        try {
            this.keyTableDesc = this.redWork.getKeyDesc();
            this.inputKeyDeserializer = (SerDe)ReflectionUtils.newInstance(this.keyTableDesc.getDeserializerClass(), null);
            this.inputKeyDeserializer.initialize(null, this.keyTableDesc.getProperties());
            ObjectInspector keyObjectInspector = this.inputKeyDeserializer.getObjectInspector();
            this.reducer.setGroupKeyObjectInspector(keyObjectInspector);
            this.valueTableDesc = new TableDesc[this.redWork.getTagToValueDesc().size()];
            for (int tag = 0; tag < this.redWork.getTagToValueDesc().size(); ++tag) {
                this.valueTableDesc[tag] = this.redWork.getTagToValueDesc().get(tag);
                this.inputValueDeserializer[tag] = (SerDe)ReflectionUtils.newInstance(this.valueTableDesc[tag].getDeserializerClass(), null);
                this.inputValueDeserializer[tag].initialize(null, this.valueTableDesc[tag].getProperties());
                valueObjectInspector[tag] = this.inputValueDeserializer[tag].getObjectInspector();
                ArrayList<ObjectInspector> ois = new ArrayList<ObjectInspector>();
                ois.add(keyObjectInspector);
                ois.add(valueObjectInspector[tag]);
                this.rowObjectInspector[tag] = ObjectInspectorFactory.getStandardStructObjectInspector(Utilities.reduceFieldNameList, ois);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MapredContext.init(false, new JobConf((Configuration)jconf));
        ((TezContext)MapredContext.get()).setInputs(inputs);
        try {
            l4j.info((Object)this.reducer.dump(0));
            this.reducer.initialize((Configuration)jconf, this.rowObjectInspector);
            List<HashTableDummyOperator> dummyOps = this.redWork.getDummyOps();
            if (dummyOps != null) {
                for (HashTableDummyOperator dummyOp : dummyOps) {
                    dummyOp.setExecContext(this.execContext);
                    dummyOp.initialize((Configuration)jconf, null);
                }
            }
            LinkedList<Operator<? extends OperatorDesc>> children = new LinkedList<Operator<? extends OperatorDesc>>();
            children.add(this.reducer);
            if (dummyOps != null) {
                children.addAll(dummyOps);
            }
            this.createOutputMap();
            OperatorUtils.setChildrenCollector(children, this.outMap);
            this.reducer.setReporter((Reporter)this.reporter);
            MapredContext.get().setReporter((Reporter)this.reporter);
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            throw new RuntimeException("Reduce operator initialization failed", e);
        }
        this.perfLogger.PerfLogEnd(this.CLASS_NAME, "TezInitializeOperators");
    }

    @Override
    void run() throws Exception {
        Iterable values;
        Object key;
        boolean needMore;
        InputMerger kvsReader;
        List<LogicalInput> shuffleInputs = this.getShuffleInputs(this.inputs);
        if (shuffleInputs != null) {
            l4j.info((Object)"Waiting for ShuffleInputs to become ready");
            this.processorContext.waitForAllInputsReady(new ArrayList<LogicalInput>(shuffleInputs));
        }
        for (Map.Entry outputEntry : this.outputs.entrySet()) {
            l4j.info((Object)("Starting Output: " + (String)outputEntry.getKey()));
            ((LogicalOutput)outputEntry.getValue()).start();
            ((TezProcessor.TezKVOutputCollector)this.outMap.get(outputEntry.getKey())).initialize();
        }
        try {
            kvsReader = shuffleInputs.size() == 1 ? (KeyValuesReader)shuffleInputs.get(0).getReader() : new InputMerger(shuffleInputs);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        while (kvsReader.next() && (needMore = this.processKeyValues(key = kvsReader.getCurrentKey(), values = kvsReader.getCurrentValues()))) {
        }
    }

    private List<LogicalInput> getShuffleInputs(Map<String, LogicalInput> inputs) {
        Map<Integer, String> tag2input = this.redWork.getTagToInput();
        ArrayList<LogicalInput> shuffleInputs = new ArrayList<LogicalInput>();
        for (String inpStr : tag2input.values()) {
            shuffleInputs.add(inputs.get(inpStr));
        }
        return shuffleInputs;
    }

    private boolean processKeyValues(Object key, Iterable<Object> values) {
        if (this.reducer.getDone()) {
            return false;
        }
        this.execContext.resetRow();
        try {
            BytesWritable keyWritable = (BytesWritable)key;
            byte tag = 0;
            if (this.isTagged) {
                int size = keyWritable.getSize() - 1;
                tag = keyWritable.get()[size];
                keyWritable.setSize(size);
            }
            if (!keyWritable.equals((Object)this.groupKey)) {
                if (this.groupKey == null) {
                    this.groupKey = new BytesWritable();
                } else {
                    l4j.trace((Object)"End Group");
                    this.reducer.endGroup();
                }
                try {
                    this.keyObject = this.inputKeyDeserializer.deserialize((Writable)keyWritable);
                }
                catch (Exception e) {
                    throw new HiveException("Hive Runtime Error: Unable to deserialize reduce input key from " + Utilities.formatBinaryString(keyWritable.get(), 0, keyWritable.getSize()) + " with properties " + this.keyTableDesc.getProperties(), e);
                }
                this.groupKey.set(keyWritable.get(), 0, keyWritable.getSize());
                l4j.trace((Object)"Start Group");
                this.reducer.setGroupKeyObject(this.keyObject);
                this.reducer.startGroup();
            }
            for (BytesWritable bytesWritable : values) {
                Object valueObj;
                try {
                    valueObj = this.inputValueDeserializer[tag].deserialize((Writable)bytesWritable);
                }
                catch (SerDeException e) {
                    throw new HiveException("Hive Runtime Error: Unable to deserialize reduce input value (tag=" + tag + ") from " + Utilities.formatBinaryString(bytesWritable.get(), 0, bytesWritable.getSize()) + " with properties " + this.valueTableDesc[tag].getProperties(), e);
                }
                this.row.clear();
                this.row.add(this.keyObject);
                this.row.add(valueObj);
                try {
                    this.reducer.processOp(this.row, tag);
                }
                catch (Exception e) {
                    String rowString = null;
                    try {
                        rowString = SerDeUtils.getJSONString(this.row, (ObjectInspector)this.rowObjectInspector[tag]);
                    }
                    catch (Exception e2) {
                        rowString = "[Error getting row data with exception " + StringUtils.stringifyException((Throwable)e2) + " ]";
                    }
                    throw new HiveException("Hive Runtime Error while processing row (tag=" + tag + ") " + rowString, e);
                }
                if (!this.isLogInfoEnabled) continue;
                this.logProgress();
            }
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            l4j.fatal((Object)StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        if (!this.abort) {
            this.abort = this.execContext.getIoCxt().getIOExceptions();
        }
        try {
            if (this.groupKey != null) {
                l4j.trace((Object)"End Group");
                this.reducer.endGroup();
            }
            if (this.isLogInfoEnabled) {
                this.logCloseInfo();
            }
            this.reducer.close(this.abort);
            List<HashTableDummyOperator> dummyOps = this.redWork.getDummyOps();
            if (dummyOps != null) {
                for (HashTableDummyOperator dummyOp : dummyOps) {
                    dummyOp.close(this.abort);
                }
            }
            ExecMapper.reportStats rps = new ExecMapper.reportStats((Reporter)this.reporter);
            this.reducer.preorderMap(rps);
        }
        catch (Exception e) {
            if (!this.abort) {
                l4j.error((Object)"Hit error while closing operators - failing tree");
                throw new RuntimeException("Hive Runtime Error while closing operators: " + e.getMessage(), e);
            }
        }
        finally {
            Utilities.clearWorkMap();
            MapredContext.close();
        }
    }
}

