/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.tez.CustomEdgeConfiguration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.tez.dag.api.EdgeManager;
import org.apache.tez.dag.api.EdgeManagerContext;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;

public class CustomPartitionEdge
implements EdgeManager {
    private static final Log LOG = LogFactory.getLog((String)CustomPartitionEdge.class.getName());
    CustomEdgeConfiguration conf = null;

    public int getNumDestinationTaskPhysicalInputs(int numSourceTasks, int destinationTaskIndex) {
        return numSourceTasks;
    }

    public int getNumSourceTaskPhysicalOutputs(int numDestinationTasks, int sourceTaskIndex) {
        return this.conf.getNumBuckets();
    }

    public int getNumDestinationConsumerTasks(int sourceTaskIndex, int numDestinationTasks) {
        return numDestinationTasks;
    }

    public void initialize(EdgeManagerContext context) {
        byte[] payload = context.getUserPayload();
        LOG.info((Object)("Initializing the edge, payload: " + payload));
        if (payload == null) {
            throw new RuntimeException("Invalid payload");
        }
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(payload, payload.length);
        this.conf = new CustomEdgeConfiguration();
        try {
            this.conf.readFields((DataInput)dib);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOG.info((Object)("Routing table: " + this.conf.getRoutingTable() + " num Buckets: " + this.conf.getNumBuckets()));
    }

    public void routeDataMovementEventToDestination(DataMovementEvent event, int sourceTaskIndex, int numDestinationTasks, Map<Integer, List<Integer>> mapDestTaskIndices) {
        int srcIndex = event.getSourceIndex();
        ArrayList destTaskIndices = new ArrayList();
        destTaskIndices.addAll(this.conf.getRoutingTable().get((Object)srcIndex));
        mapDestTaskIndices.put(new Integer(sourceTaskIndex), destTaskIndices);
    }

    public void routeInputSourceTaskFailedEventToDestination(int sourceTaskIndex, int numDestinationTasks, Map<Integer, List<Integer>> mapDestTaskIndices) {
        ArrayList<Integer> destTaskIndices = new ArrayList<Integer>();
        this.addAllDestinationTaskIndices(numDestinationTasks, destTaskIndices);
        mapDestTaskIndices.put(new Integer(sourceTaskIndex), destTaskIndices);
    }

    public int routeInputErrorEventToSource(InputReadErrorEvent event, int destinationTaskIndex) {
        return event.getIndex();
    }

    void addAllDestinationTaskIndices(int numDestinationTasks, List<Integer> taskIndices) {
        for (int i = 0; i < numDestinationTasks; ++i) {
            taskIndices.add(new Integer(i));
        }
    }
}

