/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.PTFUtils;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.TopNHash;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.OutputCollector;

public class ReduceSinkOperator
extends TerminalOperator<ReduceSinkDesc>
implements Serializable,
TopNHash.BinaryCollector {
    private static final long serialVersionUID = 1L;
    protected transient OutputCollector out;
    protected transient ExprNodeEvaluator[] keyEval;
    protected transient ExprNodeEvaluator[] valueEval;
    protected transient ExprNodeEvaluator[] partitionEval;
    protected transient ExprNodeEvaluator[] bucketEval = null;
    protected transient Serializer keySerializer;
    protected transient boolean keyIsText;
    protected transient Serializer valueSerializer;
    transient int tag;
    protected transient byte[] tagByte = new byte[1];
    protected transient int numDistributionKeys;
    protected transient int numDistinctExprs;
    transient String[] inputAliases;
    protected transient TopNHash reducerHash = new TopNHash();
    transient InspectableObject tempInspectableObject = new InspectableObject();
    protected transient HiveKey keyWritable = new HiveKey();
    protected transient ObjectInspector keyObjectInspector;
    protected transient ObjectInspector valueObjectInspector;
    transient ObjectInspector[] partitionObjectInspectors;
    transient ObjectInspector[] bucketObjectInspectors = null;
    transient int buckColIdxInKey;
    protected transient Object[] cachedValues;
    protected transient List<List<Integer>> distinctColIndices;
    protected transient Object[][] cachedKeys;
    boolean firstRow;
    protected transient Random random;

    public void setInputAliases(String[] inputAliases) {
        this.inputAliases = inputAliases;
    }

    public String[] getInputAliases() {
        return this.inputAliases;
    }

    @Override
    public void setOutputCollector(OutputCollector _out) {
        this.out = _out;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        try {
            int index;
            ArrayList<ExprNodeDesc> keys = ((ReduceSinkDesc)this.conf).getKeyCols();
            this.keyEval = new ExprNodeEvaluator[keys.size()];
            int i = 0;
            for (ExprNodeDesc e : keys) {
                this.keyEval[i++] = ExprNodeEvaluatorFactory.get(e);
            }
            this.numDistributionKeys = ((ReduceSinkDesc)this.conf).getNumDistributionKeys();
            this.distinctColIndices = ((ReduceSinkDesc)this.conf).getDistinctColumnIndices();
            this.numDistinctExprs = this.distinctColIndices.size();
            this.valueEval = new ExprNodeEvaluator[((ReduceSinkDesc)this.conf).getValueCols().size()];
            i = 0;
            for (ExprNodeDesc e : ((ReduceSinkDesc)this.conf).getValueCols()) {
                this.valueEval[i++] = ExprNodeEvaluatorFactory.get(e);
            }
            this.partitionEval = new ExprNodeEvaluator[((ReduceSinkDesc)this.conf).getPartitionCols().size()];
            i = 0;
            for (ExprNodeDesc e : ((ReduceSinkDesc)this.conf).getPartitionCols()) {
                index = ExprNodeDescUtils.indexOf(e, keys);
                this.partitionEval[i++] = index < 0 ? ExprNodeEvaluatorFactory.get(e) : this.keyEval[index];
            }
            if (((ReduceSinkDesc)this.conf).getBucketCols() != null && !((ReduceSinkDesc)this.conf).getBucketCols().isEmpty()) {
                this.bucketEval = new ExprNodeEvaluator[((ReduceSinkDesc)this.conf).getBucketCols().size()];
                i = 0;
                for (ExprNodeDesc e : ((ReduceSinkDesc)this.conf).getBucketCols()) {
                    index = ExprNodeDescUtils.indexOf(e, keys);
                    this.bucketEval[i++] = index < 0 ? ExprNodeEvaluatorFactory.get(e) : this.keyEval[index];
                }
                this.buckColIdxInKey = ((ReduceSinkDesc)this.conf).getPartitionCols().size();
            }
            this.tag = ((ReduceSinkDesc)this.conf).getTag();
            this.tagByte[0] = (byte)this.tag;
            this.LOG.info((Object)("Using tag = " + this.tag));
            TableDesc keyTableDesc = ((ReduceSinkDesc)this.conf).getKeySerializeInfo();
            this.keySerializer = (Serializer)keyTableDesc.getDeserializerClass().newInstance();
            this.keySerializer.initialize(null, keyTableDesc.getProperties());
            this.keyIsText = this.keySerializer.getSerializedClass().equals(Text.class);
            TableDesc valueTableDesc = ((ReduceSinkDesc)this.conf).getValueSerializeInfo();
            this.valueSerializer = (Serializer)valueTableDesc.getDeserializerClass().newInstance();
            this.valueSerializer.initialize(null, valueTableDesc.getProperties());
            int limit = ((ReduceSinkDesc)this.conf).getTopN();
            float memUsage = ((ReduceSinkDesc)this.conf).getTopNMemoryUsage();
            if (limit >= 0 && memUsage > 0.0f) {
                this.reducerHash.initialize(limit, memUsage, ((ReduceSinkDesc)this.conf).isMapGroupBy(), this);
            }
            this.firstRow = true;
            this.initializeChildren(hconf);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected static StructObjectInspector initEvaluatorsAndReturnStruct(ExprNodeEvaluator[] evals, List<List<Integer>> distinctColIndices, List<String> outputColNames, int length, ObjectInspector rowInspector) throws HiveException {
        int inspectorLen = evals.length > length ? length + 1 : evals.length;
        ArrayList<Object> sois = new ArrayList<Object>(inspectorLen);
        ObjectInspector[] fieldObjectInspectors = ReduceSinkOperator.initEvaluators(evals, 0, length, rowInspector);
        sois.addAll(Arrays.asList(fieldObjectInspectors));
        if (outputColNames.size() > length) {
            assert (distinctColIndices != null);
            ArrayList<StandardStructObjectInspector> uois = new ArrayList<StandardStructObjectInspector>();
            for (List<Integer> distinctCols : distinctColIndices) {
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<ObjectInspector> eois = new ArrayList<ObjectInspector>();
                int numExprs = 0;
                for (int i : distinctCols) {
                    names.add(HiveConf.getColumnInternalName((int)numExprs));
                    eois.add(evals[i].initialize(rowInspector));
                    ++numExprs;
                }
                uois.add(ObjectInspectorFactory.getStandardStructObjectInspector(names, eois));
            }
            StandardUnionObjectInspector uoi = ObjectInspectorFactory.getStandardUnionObjectInspector(uois);
            sois.add(uoi);
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(outputColNames, sois);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        try {
            int firstIndex;
            ObjectInspector rowInspector = this.inputObjInspectors[tag];
            if (this.firstRow) {
                this.firstRow = false;
                this.keyObjectInspector = ReduceSinkOperator.initEvaluatorsAndReturnStruct(this.keyEval, this.distinctColIndices, ((ReduceSinkDesc)this.conf).getOutputKeyColumnNames(), this.numDistributionKeys, rowInspector);
                this.valueObjectInspector = ReduceSinkOperator.initEvaluatorsAndReturnStruct(this.valueEval, ((ReduceSinkDesc)this.conf).getOutputValueColumnNames(), rowInspector);
                this.partitionObjectInspectors = ReduceSinkOperator.initEvaluators(this.partitionEval, rowInspector);
                if (this.bucketEval != null) {
                    this.bucketObjectInspectors = ReduceSinkOperator.initEvaluators(this.bucketEval, rowInspector);
                }
                int numKeys = this.numDistinctExprs > 0 ? this.numDistinctExprs : 1;
                int keyLen = this.numDistinctExprs > 0 ? this.numDistributionKeys + 1 : this.numDistributionKeys;
                this.cachedKeys = new Object[numKeys][keyLen];
                this.cachedValues = new Object[this.valueEval.length];
            }
            this.populateCachedDistributionKeys(row, 0);
            int buckNum = 0;
            if (this.bucketEval != null) {
                buckNum = this.computeBucketNumber(row, ((ReduceSinkDesc)this.conf).getNumBuckets());
                this.cachedKeys[0][this.buckColIdxInKey] = new IntWritable(buckNum);
            }
            HiveKey firstKey = this.toHiveKey(this.cachedKeys[0], tag, null);
            int distKeyLength = firstKey.getDistKeyLength();
            if (this.numDistinctExprs > 0) {
                this.populateCachedDistinctKeys(row, 0);
                firstKey = this.toHiveKey(this.cachedKeys[0], tag, distKeyLength);
            }
            if ((firstIndex = this.reducerHash.tryStoreKey(firstKey)) == -2) {
                return;
            }
            BytesWritable value = this.makeValueWritable(row);
            int hashCode = 0;
            hashCode = this.bucketEval == null ? this.computeHashCode(row) : this.computeHashCode(row, buckNum);
            if (firstIndex == -1) {
                firstKey.setHashCode(hashCode);
                this.collect(firstKey, (Writable)value);
            } else {
                assert (firstIndex >= 0);
                this.reducerHash.storeValue(firstIndex, value, hashCode, false);
            }
            for (int i = 1; i < this.numDistinctExprs; ++i) {
                System.arraycopy(this.cachedKeys[0], 0, this.cachedKeys[i], 0, this.numDistributionKeys);
                this.populateCachedDistinctKeys(row, i);
                HiveKey hiveKey = this.toHiveKey(this.cachedKeys[i], tag, distKeyLength);
                hiveKey.setHashCode(hashCode);
                this.collect(hiveKey, (Writable)value);
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private int computeBucketNumber(Object row, int numBuckets) throws HiveException {
        int buckNum = 0;
        for (int i = 0; i < this.bucketEval.length; ++i) {
            Object o = this.bucketEval[i].evaluate(row);
            buckNum = buckNum * 31 + ObjectInspectorUtils.hashCode((Object)o, (ObjectInspector)this.bucketObjectInspectors[i]);
        }
        if (buckNum < 0) {
            buckNum = -1 * buckNum;
        }
        return buckNum % numBuckets;
    }

    private void populateCachedDistributionKeys(Object row, int index) throws HiveException {
        for (int i = 0; i < this.numDistributionKeys; ++i) {
            this.cachedKeys[index][i] = this.keyEval[i].evaluate(row);
        }
        if (this.cachedKeys[0].length > this.numDistributionKeys) {
            this.cachedKeys[index][this.numDistributionKeys] = null;
        }
    }

    private void populateCachedDistinctKeys(Object row, int index) throws HiveException {
        StandardUnionObjectInspector.StandardUnion union = new StandardUnionObjectInspector.StandardUnion((byte)index, (Object)new Object[this.distinctColIndices.get(index).size()]);
        this.cachedKeys[index][this.numDistributionKeys] = union;
        Object[] distinctParameters = (Object[])union.getObject();
        for (int distinctParamI = 0; distinctParamI < distinctParameters.length; ++distinctParamI) {
            distinctParameters[distinctParamI] = this.keyEval[this.distinctColIndices.get(index).get(distinctParamI)].evaluate(row);
        }
        union.setTag((byte)index);
    }

    private int computeHashCode(Object row) throws HiveException {
        int keyHashCode = 0;
        if (this.partitionEval.length == 0) {
            if (this.random == null) {
                this.random = new Random(12345L);
            }
            keyHashCode = this.random.nextInt();
        } else {
            for (int i = 0; i < this.partitionEval.length; ++i) {
                Object o = this.partitionEval[i].evaluate(row);
                keyHashCode = keyHashCode * 31 + ObjectInspectorUtils.hashCode((Object)o, (ObjectInspector)this.partitionObjectInspectors[i]);
            }
        }
        return keyHashCode;
    }

    private int computeHashCode(Object row, int buckNum) throws HiveException {
        int keyHashCode = this.computeHashCode(row);
        keyHashCode = keyHashCode * 31 + buckNum;
        return keyHashCode;
    }

    protected HiveKey toHiveKey(Object obj, int tag, Integer distLength) throws SerDeException {
        BinaryComparable key = (BinaryComparable)this.keySerializer.serialize(obj, this.keyObjectInspector);
        int keyLength = key.getLength();
        if (tag == -1) {
            this.keyWritable.set(key.getBytes(), 0, keyLength);
        } else {
            this.keyWritable.setSize(keyLength + 1);
            System.arraycopy(key.getBytes(), 0, this.keyWritable.get(), 0, keyLength);
            this.keyWritable.get()[keyLength] = this.tagByte[0];
        }
        this.keyWritable.setDistKeyLength(distLength == null ? keyLength : distLength);
        return this.keyWritable;
    }

    @Override
    public void collect(byte[] key, byte[] value, int hash) throws IOException {
        HiveKey keyWritable = new HiveKey(key, hash);
        BytesWritable valueWritable = new BytesWritable(value);
        this.collect(keyWritable, (Writable)valueWritable);
    }

    protected void collect(BytesWritable keyWritable, Writable valueWritable) throws IOException {
        if (null != this.out) {
            this.out.collect((Object)keyWritable, (Object)valueWritable);
        }
    }

    private BytesWritable makeValueWritable(Object row) throws Exception {
        for (int i = 0; i < this.valueEval.length; ++i) {
            this.cachedValues[i] = this.valueEval[i].evaluate(row);
        }
        return (BytesWritable)this.valueSerializer.serialize((Object)this.cachedValues, this.valueObjectInspector);
    }

    @Override
    protected void closeOp(boolean abort) throws HiveException {
        if (!abort) {
            this.reducerHash.flush();
        }
        super.closeOp(abort);
        this.out = null;
    }

    @Override
    public String getName() {
        return ReduceSinkOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "RS";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.REDUCESINK;
    }

    @Override
    public boolean opAllowedBeforeMapJoin() {
        return false;
    }

    static {
        PTFUtils.makeTransient(ReduceSinkOperator.class, "inputAliases");
    }
}

