/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;

public class PartitionKeySampler
implements OutputCollector<HiveKey, Object> {
    public static final Comparator<byte[]> C = new Comparator<byte[]>(){

        @Override
        public final int compare(byte[] o1, byte[] o2) {
            return WritableComparator.compareBytes((byte[])o1, (int)0, (int)o1.length, (byte[])o2, (int)0, (int)o2.length);
        }
    };
    private final List<byte[]> sampled = new ArrayList<byte[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSampleFile(Path inputPath, JobConf job) throws IOException {
        FileSystem fs = inputPath.getFileSystem((Configuration)job);
        FSDataInputStream input = fs.open(inputPath);
        try {
            int count = input.readInt();
            for (int i = 0; i < count; ++i) {
                byte[] key = new byte[input.readInt()];
                input.readFully(key);
                this.sampled.add(key);
            }
        }
        finally {
            IOUtils.closeStream((Closeable)input);
        }
    }

    public void collect(HiveKey key, Object value) throws IOException {
        this.sampled.add(Arrays.copyOfRange(key.getBytes(), 0, key.getLength()));
    }

    private byte[][] getPartitionKeys(int numReduce) {
        if (this.sampled.size() < numReduce - 1) {
            throw new IllegalStateException("not enough number of sample");
        }
        byte[][] sorted = (byte[][])this.sampled.toArray((T[])new byte[this.sampled.size()][]);
        Arrays.sort(sorted, C);
        byte[][] partitionKeys = new byte[numReduce - 1][];
        float stepSize = (float)sorted.length / (float)numReduce;
        int last = -1;
        for (int i = 1; i < numReduce; ++i) {
            int k;
            for (k = Math.round(stepSize * (float)i); last >= k && C.compare(sorted[last], sorted[k]) == 0; ++k) {
            }
            if (k >= sorted.length) {
                throw new IllegalStateException("not enough number of sample");
            }
            partitionKeys[i - 1] = sorted[k];
            last = k;
        }
        return partitionKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePartitionKeys(Path path, JobConf job) throws IOException {
        byte[][] partitionKeys = this.getPartitionKeys(job.getNumReduceTasks());
        FileSystem fs = path.getFileSystem((Configuration)job);
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)job, (Path)path, BytesWritable.class, NullWritable.class);
        try {
            for (byte[] pkey : partitionKeys) {
                BytesWritable wrapper = new BytesWritable(pkey);
                writer.append((Writable)wrapper, (Writable)NullWritable.get());
            }
        }
        finally {
            IOUtils.closeStream((Closeable)writer);
        }
    }

    public static FetchSampler createSampler(FetchWork work, HiveConf conf, JobConf job, Operator<?> operator) {
        int sampleNum = conf.getIntVar(HiveConf.ConfVars.HIVESAMPLINGNUMBERFORORDERBY);
        float samplePercent = conf.getFloatVar(HiveConf.ConfVars.HIVESAMPLINGPERCENTFORORDERBY);
        if ((double)samplePercent < 0.0 || (double)samplePercent > 1.0) {
            throw new IllegalArgumentException("Percentile value must be within the range of 0 to 1.");
        }
        FetchSampler sampler = new FetchSampler(work, job, operator);
        sampler.setSampleNum(sampleNum);
        sampler.setSamplePercent(samplePercent);
        return sampler;
    }

    private static class FetchSampler
    extends FetchOperator {
        private int sampleNum = 1000;
        private float samplePercent = 0.1f;
        private final Random random = new Random();
        private int sampled;

        public FetchSampler(FetchWork work, JobConf job, Operator<?> operator) {
            super(work, job, operator, null);
        }

        public void setSampleNum(int numSample) {
            this.sampleNum = numSample;
        }

        public void setSamplePercent(float samplePercent) {
            this.samplePercent = samplePercent;
        }

        @Override
        public boolean pushRow() throws IOException, HiveException {
            if (!super.pushRow()) {
                return false;
            }
            if (this.sampled < this.sampleNum) {
                return true;
            }
            this.operator.flush();
            return false;
        }

        @Override
        protected void pushRow(InspectableObject row) throws HiveException {
            if (this.random.nextFloat() < this.samplePercent) {
                ++this.sampled;
                super.pushRow(row);
            }
        }
    }
}

