/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Closeable;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.physical.StageIDsRearranger;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ExplainTask
extends Task<ExplainWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EXPL_COLUMN_NAME = "Explain";
    private Set<Operator<?>> visitedOps = new HashSet();
    private boolean isLogical = false;

    private static JSONObject getJSONDependencies(ExplainWork work) throws Exception {
        assert (work.getDependency());
        JSONObject outJSONObject = new JSONObject();
        ArrayList inputTableInfo = new ArrayList();
        ArrayList inputPartitionInfo = new ArrayList();
        for (ReadEntity input : work.getInputs()) {
            switch (input.getType()) {
                case TABLE: {
                    Table table = input.getTable();
                    HashMap<String, String> tableInfo = new HashMap<String, String>();
                    tableInfo.put("tablename", table.getCompleteName());
                    tableInfo.put("tabletype", table.getTableType().toString());
                    if (input.getParents() != null && !input.getParents().isEmpty()) {
                        tableInfo.put("tableParents", input.getParents().toString());
                    }
                    inputTableInfo.add(tableInfo);
                    break;
                }
                case PARTITION: {
                    HashMap<String, String> partitionInfo = new HashMap<String, String>();
                    partitionInfo.put("partitionName", input.getPartition().getCompleteName());
                    if (input.getParents() != null && !input.getParents().isEmpty()) {
                        partitionInfo.put("partitionParents", input.getParents().toString());
                    }
                    inputPartitionInfo.add(partitionInfo);
                    break;
                }
            }
        }
        outJSONObject.put("input_tables", inputTableInfo);
        outJSONObject.put("input_partitions", inputPartitionInfo);
        return outJSONObject;
    }

    public JSONObject getJSONLogicalPlan(PrintStream out, ExplainWork work) throws Exception {
        this.isLogical = true;
        JSONObject outJSONObject = new JSONObject();
        boolean jsonOutput = work.isFormatted();
        if (jsonOutput) {
            out = null;
        }
        if (work.getAstStringTree() != null) {
            String jsonAST = this.outputAST(work.getAstStringTree(), out, jsonOutput, 0);
            if (out != null) {
                out.println();
            }
            if (jsonOutput) {
                outJSONObject.put("ABSTRACT SYNTAX TREE", (Object)jsonAST);
            }
        }
        if (work.getParseContext() != null) {
            out.print("LOGICAL PLAN:");
            JSONObject jsonPlan = this.outputMap(work.getParseContext().getTopOps(), true, out, jsonOutput, work.getExtended(), 0);
            if (out != null) {
                out.println();
            }
            if (jsonOutput) {
                outJSONObject.put("LOGICAL PLAN", (Object)jsonPlan);
            }
        } else {
            System.err.println("No parse context!");
        }
        return outJSONObject;
    }

    public JSONObject getJSONPlan(PrintStream out, ExplainWork work) throws Exception {
        return this.getJSONPlan(out, work.getAstStringTree(), work.getRootTasks(), work.getFetchTask(), work.isFormatted(), work.getExtended(), work.isAppendTaskType());
    }

    public JSONObject getJSONPlan(PrintStream out, String ast, List<Task<?>> tasks, Task<?> fetchTask, boolean jsonOutput, boolean isExtended, boolean appendTaskType) throws Exception {
        JSONObject outJSONObject = new JSONObject();
        if (jsonOutput) {
            out = null;
        }
        if (ast != null && isExtended) {
            String jsonAST = this.outputAST(ast, out, jsonOutput, 0);
            if (out != null) {
                out.println();
            }
            if (jsonOutput) {
                outJSONObject.put("ABSTRACT SYNTAX TREE", (Object)jsonAST);
            }
        }
        List<Task> ordered = StageIDsRearranger.getExplainOrder(this.conf, tasks);
        if (fetchTask != null) {
            fetchTask.setRootTask(true);
            ordered.add(fetchTask);
        }
        JSONObject jsonDependencies = this.outputDependencies(out, jsonOutput, appendTaskType, ordered);
        if (out != null) {
            out.println();
        }
        if (jsonOutput) {
            outJSONObject.put("STAGE DEPENDENCIES", (Object)jsonDependencies);
        }
        JSONObject jsonPlan = this.outputStagePlans(out, ordered, jsonOutput, isExtended);
        if (jsonOutput) {
            outJSONObject.put("STAGE PLANS", (Object)jsonPlan);
        }
        return jsonOutput ? outJSONObject : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(DriverContext driverContext) {
        int n;
        PrintStream out = null;
        try {
            Path resFile = ((ExplainWork)this.work).getResFile();
            FSDataOutputStream outS = resFile.getFileSystem((Configuration)this.conf).create(resFile);
            out = new PrintStream((OutputStream)outS);
            if (((ExplainWork)this.work).isLogical()) {
                JSONObject jsonLogicalPlan = this.getJSONLogicalPlan(out, (ExplainWork)this.work);
                if (((ExplainWork)this.work).isFormatted()) {
                    out.print(jsonLogicalPlan);
                }
            } else if (((ExplainWork)this.work).getDependency()) {
                JSONObject jsonDependencies = ExplainTask.getJSONDependencies((ExplainWork)this.work);
                out.print(jsonDependencies);
            } else {
                JSONObject jsonPlan = this.getJSONPlan(out, (ExplainWork)this.work);
                if (((ExplainWork)this.work).isFormatted()) {
                    out.print(jsonPlan);
                }
            }
            out.close();
            out = null;
            n = 0;
        }
        catch (Exception e) {
            int n2;
            try {
                this.console.printError("Failed with exception " + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e));
                n2 = 1;
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(out);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)out);
            return n2;
        }
        IOUtils.closeStream((Closeable)out);
        return n;
    }

    private String indentString(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private JSONObject outputMap(Map<?, ?> mp, boolean hasHeader, PrintStream out, boolean extended, boolean jsonOutput, int indent) throws Exception {
        JSONObject json;
        TreeMap tree = new TreeMap();
        tree.putAll(mp);
        JSONObject jSONObject = json = jsonOutput ? new JSONObject() : null;
        if (out != null && hasHeader && !mp.isEmpty()) {
            out.println();
        }
        for (Map.Entry ent : tree.entrySet()) {
            if (out != null) {
                out.print(this.indentString(indent));
                out.printf("%s ", ent.getKey().toString());
            }
            if (this.isPrintable(ent.getValue())) {
                if (out != null) {
                    out.print(ent.getValue());
                    out.println();
                }
                if (!jsonOutput) continue;
                json.put(ent.getKey().toString(), (Object)ent.getValue().toString());
                continue;
            }
            if (ent.getValue() instanceof List) {
                if (ent.getValue() != null && !((List)ent.getValue()).isEmpty() && ((List)ent.getValue()).get(0) != null && ((List)ent.getValue()).get(0) instanceof TezWork.Dependency) {
                    if (out != null) {
                        boolean isFirst = true;
                        for (TezWork.Dependency dep : (List)ent.getValue()) {
                            if (!isFirst) {
                                out.print(", ");
                            } else {
                                out.print("<- ");
                                isFirst = false;
                            }
                            out.print(dep.getName());
                            out.print(" (");
                            out.print(dep.getType());
                            out.print(")");
                        }
                        out.println();
                    }
                    if (!jsonOutput) continue;
                    for (TezWork.Dependency dep : (List)ent.getValue()) {
                        JSONObject jsonDep = new JSONObject();
                        jsonDep.put("parent", (Object)dep.getName());
                        jsonDep.put("type", (Object)dep.getType());
                        json.accumulate(ent.getKey().toString(), (Object)jsonDep);
                    }
                    continue;
                }
                if (out != null) {
                    out.print(ent.getValue().toString());
                    out.println();
                }
                if (!jsonOutput) continue;
                json.put(ent.getKey().toString(), (Object)ent.getValue().toString());
                continue;
            }
            if (ent.getValue() instanceof Map) {
                if (out != null) {
                    out.print(ent.getValue().toString());
                    out.println();
                }
                if (!jsonOutput) continue;
                json.put(ent.getKey().toString(), (Object)ent.getValue().toString());
                continue;
            }
            if (ent.getValue() instanceof Serializable) {
                if (out != null) {
                    out.println();
                }
                JSONObject jsonOut = this.outputPlan((Serializable)ent.getValue(), out, extended, jsonOutput, jsonOutput ? 0 : indent + 2);
                if (!jsonOutput) continue;
                json.put(ent.getKey().toString(), (Object)jsonOut);
                continue;
            }
            if (out == null) continue;
            out.println();
        }
        return jsonOutput ? json : null;
    }

    private JSONArray outputList(List<?> l, PrintStream out, boolean hasHeader, boolean extended, boolean jsonOutput, int indent) throws Exception {
        boolean first_el = true;
        boolean nl = false;
        JSONArray outputArray = new JSONArray();
        for (Object o : l) {
            if (this.isPrintable(o)) {
                String delim;
                String string = delim = first_el ? " " : ", ";
                if (out != null) {
                    out.print(delim);
                    out.print(o);
                }
                if (jsonOutput) {
                    outputArray.put(o);
                }
                nl = true;
            } else if (o instanceof Serializable) {
                if (first_el && out != null && hasHeader) {
                    out.println();
                }
                JSONObject jsonOut = this.outputPlan((Serializable)o, out, extended, jsonOutput, jsonOutput ? 0 : (hasHeader ? indent + 2 : indent));
                if (jsonOutput) {
                    outputArray.put((Object)jsonOut);
                }
            }
            first_el = false;
        }
        if (nl && out != null) {
            out.println();
        }
        return jsonOutput ? outputArray : null;
    }

    private boolean isPrintable(Object val) {
        if (val instanceof Boolean || val instanceof String || val instanceof Integer || val instanceof Long || val instanceof Byte || val instanceof Float || val instanceof Double || val instanceof Path) {
            return true;
        }
        return val != null && val.getClass().isPrimitive();
    }

    private JSONObject outputPlan(Serializable work, PrintStream out, boolean extended, boolean jsonOutput, int indent) throws Exception {
        return this.outputPlan(work, out, extended, jsonOutput, indent, "");
    }

    private JSONObject outputPlan(Serializable work, PrintStream out, boolean extended, boolean jsonOutput, int indent, String appendToHeader) throws Exception {
        JSONObject json;
        Explain note = work.getClass().getAnnotation(Explain.class);
        String keyJSONObject = null;
        if (note instanceof Explain) {
            Explain xpl_note = note;
            if (extended || xpl_note.normalExplain()) {
                keyJSONObject = xpl_note.displayName();
                if (out != null) {
                    out.print(this.indentString(indent));
                    if (appendToHeader != null && !appendToHeader.isEmpty()) {
                        out.println(xpl_note.displayName() + appendToHeader);
                    } else {
                        out.println(xpl_note.displayName());
                    }
                }
            }
        }
        JSONObject jSONObject = json = jsonOutput ? new JSONObject() : null;
        if (work instanceof Operator) {
            Operator operator = (Operator)work;
            if (operator.getConf() != null) {
                String appender = this.isLogical ? " (" + operator.getOperatorId() + ")" : "";
                JSONObject jsonOut = this.outputPlan((Serializable)operator.getConf(), out, extended, jsonOutput, jsonOutput ? 0 : indent, appender);
                if (jsonOutput) {
                    json = jsonOut;
                }
            }
            if (!this.visitedOps.contains(operator) || !this.isLogical) {
                this.visitedOps.add(operator);
                if (operator.getChildOperators() != null) {
                    int cindent = jsonOutput ? 0 : indent + 2;
                    for (Operator<OperatorDesc> op : operator.getChildOperators()) {
                        JSONObject jsonOut = this.outputPlan(op, out, extended, jsonOutput, cindent);
                        if (!jsonOutput) continue;
                        ((JSONObject)json.get(JSONObject.getNames((JSONObject)json)[0])).accumulate("children", (Object)jsonOut);
                    }
                }
            }
            if (jsonOutput) {
                return json;
            }
            return null;
        }
        Method[] methods = work.getClass().getMethods();
        Arrays.sort(methods, new MethodComparator());
        for (Method m : methods) {
            JSONObject jsonOut;
            int prop_indents = jsonOutput ? 0 : indent + 2;
            note = m.getAnnotation(Explain.class);
            if (!(note instanceof Explain)) continue;
            Explain xpl_note = note;
            if (!extended && !xpl_note.normalExplain()) continue;
            Object val = null;
            try {
                val = m.invoke((Object)work, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                val = null;
            }
            if (val == null) continue;
            String header = null;
            boolean skipHeader = xpl_note.skipHeader();
            boolean emptyHeader = false;
            if (!xpl_note.displayName().equals("")) {
                header = this.indentString(prop_indents) + xpl_note.displayName() + ":";
            } else {
                emptyHeader = true;
                prop_indents = indent;
                header = this.indentString(prop_indents);
            }
            if (this.isPrintable(val)) {
                if (out != null && this.shouldPrint(xpl_note, val)) {
                    if (!skipHeader) {
                        out.printf("%s ", header);
                    }
                    out.println(val);
                }
                if (!jsonOutput || !this.shouldPrint(xpl_note, val)) continue;
                json.put(header, (Object)val.toString());
                continue;
            }
            int ind = 0;
            if (!jsonOutput) {
                ind = !skipHeader ? prop_indents + 2 : indent;
            }
            try {
                Map mp = (Map)val;
                if (out != null && !skipHeader && mp != null && !mp.isEmpty()) {
                    out.print(header);
                }
                jsonOut = this.outputMap(mp, !skipHeader && !emptyHeader, out, extended, jsonOutput, ind);
                if (!jsonOutput || mp.isEmpty()) continue;
                json.put(header, (Object)jsonOut);
            }
            catch (ClassCastException ce) {
                try {
                    LinkedList l;
                    try {
                        l = (LinkedList)val;
                    }
                    catch (ClassCastException e) {
                        Set s = (Set)val;
                        l = new LinkedList();
                        l.addAll(s);
                    }
                    if (out != null && !skipHeader && l != null && !l.isEmpty()) {
                        out.print(header);
                    }
                    jsonOut = this.outputList(l, out, !skipHeader && !emptyHeader, extended, jsonOutput, ind);
                    if (!jsonOutput || l.isEmpty()) continue;
                    json.put(header, (Object)jsonOut);
                }
                catch (ClassCastException ce2) {
                    try {
                        Serializable s = (Serializable)val;
                        if (!skipHeader && out != null) {
                            out.println(header);
                        }
                        jsonOut = this.outputPlan(s, out, extended, jsonOutput, ind);
                        if (!jsonOutput) continue;
                        if (!skipHeader) {
                            json.put(header, (Object)jsonOut);
                            continue;
                        }
                        for (String k : JSONObject.getNames((JSONObject)jsonOut)) {
                            json.put(k, jsonOut.get(k));
                        }
                    }
                    catch (ClassCastException ce3) {
                        // empty catch block
                    }
                }
            }
        }
        if (jsonOutput) {
            if (keyJSONObject != null) {
                JSONObject ret = new JSONObject();
                ret.put(keyJSONObject, (Object)json);
                return ret;
            }
            return json;
        }
        return null;
    }

    private boolean shouldPrint(Explain exp, Object val) {
        return !exp.displayOnlyOnTrue() || !(val instanceof Boolean & (Boolean)val == false);
    }

    private JSONObject outputPlan(Task<? extends Serializable> task, PrintStream out, JSONObject parentJSON, boolean extended, boolean jsonOutput, int indent) throws Exception {
        if (out != null) {
            out.print(this.indentString(indent));
            out.printf("Stage: %s\n", task.getId());
        }
        JSONObject jsonOutputPlan = this.outputPlan(task.getWork(), out, extended, jsonOutput, jsonOutput ? 0 : indent + 2);
        if (out != null) {
            out.println();
        }
        if (jsonOutput) {
            parentJSON.put(task.getId(), (Object)jsonOutputPlan);
        }
        return null;
    }

    private JSONObject outputDependencies(Task<? extends Serializable> task, PrintStream out, JSONObject parentJson, boolean jsonOutput, boolean taskType, int indent) throws Exception {
        Task<Serializable> currBackupTask;
        JSONObject json;
        boolean first = true;
        JSONObject jSONObject = json = jsonOutput ? new JSONObject() : null;
        if (out != null) {
            out.print(this.indentString(indent));
            out.printf("%s", task.getId());
        }
        if (task.getParentTasks() == null || task.getParentTasks().isEmpty()) {
            if (task.isRootTask()) {
                if (out != null) {
                    out.print(" is a root stage");
                }
                if (jsonOutput) {
                    json.put("ROOT STAGE", (Object)"TRUE");
                }
            }
        } else {
            StringBuffer s = new StringBuffer();
            first = true;
            for (Task<Serializable> parent : task.getParentTasks()) {
                if (!first) {
                    s.append(", ");
                }
                first = false;
                s.append(parent.getId());
            }
            if (out != null) {
                out.print(" depends on stages: ");
                out.print(s.toString());
            }
            if (jsonOutput) {
                json.put("DEPENDENT STAGES", (Object)s.toString());
            }
        }
        if ((currBackupTask = task.getBackupTask()) != null) {
            if (out != null) {
                out.print(" has a backup stage: ");
                out.print(currBackupTask.getId());
            }
            if (jsonOutput) {
                json.put("BACKUP STAGE", (Object)currBackupTask.getId());
            }
        }
        if (task instanceof ConditionalTask && ((ConditionalTask)task).getListTasks() != null) {
            StringBuffer s = new StringBuffer();
            first = true;
            for (Task<? extends Serializable> con : ((ConditionalTask)task).getListTasks()) {
                if (!first) {
                    s.append(", ");
                }
                first = false;
                s.append(con.getId());
            }
            if (out != null) {
                out.print(" , consists of ");
                out.print(s.toString());
            }
            if (jsonOutput) {
                json.put("CONDITIONAL CHILD TASKS", (Object)s.toString());
            }
        }
        if (taskType) {
            if (out != null) {
                out.printf(" [%s]", new Object[]{task.getType()});
            }
            if (jsonOutput) {
                json.put("TASK TYPE", (Object)task.getType().name());
            }
        }
        if (out != null) {
            out.println();
        }
        return jsonOutput ? json : null;
    }

    public String outputAST(String treeString, PrintStream out, boolean jsonOutput, int indent) throws JSONException {
        if (out != null) {
            out.print(this.indentString(indent));
            out.println("ABSTRACT SYNTAX TREE:");
            out.print(this.indentString(indent + 2));
            out.println(treeString);
        }
        return jsonOutput ? treeString : null;
    }

    public JSONObject outputDependencies(PrintStream out, boolean jsonOutput, boolean appendTaskType, List<Task> tasks) throws Exception {
        if (out != null) {
            out.println("STAGE DEPENDENCIES:");
        }
        JSONObject json = jsonOutput ? new JSONObject() : null;
        for (Task task : tasks) {
            JSONObject jsonOut = this.outputDependencies(task, out, json, jsonOutput, appendTaskType, 2);
            if (!jsonOutput || jsonOut == null) continue;
            json.put(task.getId(), (Object)jsonOut);
        }
        return jsonOutput ? json : null;
    }

    public JSONObject outputStagePlans(PrintStream out, List<Task> tasks, boolean jsonOutput, boolean isExtended) throws Exception {
        if (out != null) {
            out.println("STAGE PLANS:");
        }
        JSONObject json = jsonOutput ? new JSONObject() : null;
        for (Task task : tasks) {
            this.outputPlan(task, out, json, isExtended, jsonOutput, 2);
        }
        return jsonOutput ? json : null;
    }

    @Override
    public StageType getType() {
        return StageType.EXPLAIN;
    }

    @Override
    public String getName() {
        return "EXPLAIN";
    }

    @Override
    public List<FieldSchema> getResultSchema() {
        FieldSchema tmpFieldSchema = new FieldSchema();
        ArrayList<FieldSchema> colList = new ArrayList<FieldSchema>();
        tmpFieldSchema.setName(EXPL_COLUMN_NAME);
        tmpFieldSchema.setType("string");
        colList.add(tmpFieldSchema);
        return colList;
    }

    public class MethodComparator
    implements Comparator<Method> {
        @Override
        public int compare(Method m1, Method m2) {
            return m1.getName().compareTo(m2.getName());
        }
    }
}

