/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public abstract class AbstractMapJoinOperator<T extends MapJoinDesc>
extends CommonJoinOperator<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient List<ExprNodeEvaluator>[] joinKeys;
    protected transient List<ObjectInspector>[] joinKeysObjectInspectors;
    protected transient List<ObjectInspector>[] joinKeysStandardObjectInspectors;
    protected transient byte posBigTable = (byte)-1;
    protected transient RowContainer<List<Object>> emptyList = null;
    transient int numMapRowsRead;
    transient boolean firstRow;

    public AbstractMapJoinOperator() {
    }

    public AbstractMapJoinOperator(AbstractMapJoinOperator<? extends MapJoinDesc> mjop) {
        super(mjop);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        RowContainer<List<Object>> bigPosRC;
        super.initializeOp(hconf);
        this.numMapRowsRead = 0;
        this.firstRow = true;
        int tagLen = ((MapJoinDesc)this.conf).getTagLength();
        this.joinKeys = new List[tagLen];
        JoinUtil.populateJoinKeyValue(this.joinKeys, ((MapJoinDesc)this.conf).getKeys(), -1);
        this.joinKeysObjectInspectors = JoinUtil.getObjectInspectorsFromEvaluators(this.joinKeys, this.inputObjInspectors, -1, tagLen);
        this.joinKeysStandardObjectInspectors = JoinUtil.getStandardObjectInspectors(this.joinKeysObjectInspectors, -1, tagLen);
        this.posBigTable = (byte)((MapJoinDesc)this.conf).getPosBigTable();
        this.emptyList = new RowContainer(1, hconf, this.reporter);
        this.storage[this.posBigTable] = bigPosRC = JoinUtil.getRowContainer(hconf, this.rowContainerStandardObjectInspectors[this.posBigTable], this.posBigTable, this.joinCacheSize, this.spillTableDesc, (JoinDesc)this.conf, !this.hasFilter(this.posBigTable), this.reporter);
        List structFields = ((StructObjectInspector)this.outputObjInspector).getAllStructFieldRefs();
        if (((MapJoinDesc)this.conf).getOutputColumnNames().size() < structFields.size()) {
            ArrayList<ObjectInspector> structFieldObjectInspectors = new ArrayList<ObjectInspector>();
            for (Byte alias : this.order) {
                int sz = ((MapJoinDesc)this.conf).getExprs().get(alias).size();
                List<Integer> retained = ((MapJoinDesc)this.conf).getRetainList().get(alias);
                for (int i = 0; i < sz; ++i) {
                    int pos = retained.get(i);
                    structFieldObjectInspectors.add(((StructField)structFields.get(pos)).getFieldObjectInspector());
                }
            }
            this.outputObjInspector = ObjectInspectorFactory.getStandardStructObjectInspector(((MapJoinDesc)this.conf).getOutputColumnNames(), structFieldObjectInspectors);
        }
        this.initializeChildren(hconf);
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MAPJOIN;
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        super.closeOp(abort);
        this.emptyList = null;
        this.joinKeys = null;
    }
}

