/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.util.DosToUnix;

public class TestDosToUnix
extends TestCase {
    private static final String dataFile = System.getProperty("test.tmp.dir", ".") + "data_TestDosToUnix";

    protected void setUp() throws Exception {
        super.setUp();
        BufferedWriter output = null;
        String text = "#!/usr/bin/env ruby \r\n Test date \r\n More test data.\r\n";
        File file = new File(dataFile);
        output = new BufferedWriter(new FileWriter(file));
        output.write(text);
        ((Writer)output).close();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        File f = new File(dataFile);
        if (!f.delete()) {
            throw new RuntimeException("Could not delete the data file");
        }
    }

    public void testIsWindowsScript() {
        File file = new File(dataFile);
        TestDosToUnix.assertEquals((boolean)true, (boolean)DosToUnix.isWindowsScript((File)file));
    }

    public void testGetUnixScriptNameFor() {
        TestDosToUnix.assertEquals((String)"test_unix", (String)DosToUnix.getUnixScriptNameFor((String)"test"));
        TestDosToUnix.assertEquals((String)"test_unix.rb", (String)DosToUnix.getUnixScriptNameFor((String)"test.rb"));
    }

    public void testConvertWindowsScriptToUnix() {
        File file = new File(dataFile);
        try {
            TestDosToUnix.assertEquals((boolean)true, (boolean)DosToUnix.isWindowsScript((File)file));
            String convertedFile = DosToUnix.convertWindowsScriptToUnix((File)file);
            File cFile = new File(convertedFile);
            TestDosToUnix.assertEquals((boolean)false, (boolean)DosToUnix.isWindowsScript((File)cFile));
            if (!cFile.delete()) {
                throw new RuntimeException("Could not delete the converted data file");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TestDosToUnix.fail();
        }
    }
}

