/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLTrim;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;

public class TestGenericUDFLTrim
extends TestCase {
    public void testTrim() throws HiveException {
        GenericUDFLTrim udf = new GenericUDFLTrim();
        WritableStringObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        this.runAndVerify(" Hello World! ", "Hello World! ", (GenericUDF)udf);
        this.runAndVerify("Hello World! ", "Hello World! ", (GenericUDF)udf);
        this.runAndVerify(" Hello World!", "Hello World!", (GenericUDF)udf);
        this.runAndVerify("Hello World!", "Hello World!", (GenericUDF)udf);
        this.runAndVerify("   ", "", (GenericUDF)udf);
    }

    private void runAndVerify(String str, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)new Text(str));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj};
        Text output = (Text)udf.evaluate(args);
        TestGenericUDFLTrim.assertEquals((String)"ltrim() test ", (String)expResult, (String)output.toString());
    }
}

