/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSessionState {
    private final boolean prewarm;

    public TestSessionState(Boolean mode) {
        this.prewarm = mode;
    }

    @Parameterized.Parameters
    public static Collection<Boolean[]> data() {
        return Arrays.asList({false}, {true});
    }

    @Before
    public void setup() {
        HiveConf conf = new HiveConf();
        if (this.prewarm) {
            HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PREWARM_ENABLED, (boolean)true);
            HiveConf.setIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PREWARM_NUM_CONTAINERS, (int)1);
        }
        SessionState.start((HiveConf)conf);
    }

    @Test
    public void testgetDbName() throws Exception {
        Assert.assertEquals((Object)"default", (Object)SessionState.get().getCurrentDatabase());
        String newdb = "DB_2";
        SessionState.get().setCurrentDatabase("DB_2");
        Assert.assertEquals((Object)"DB_2", (Object)SessionState.get().getCurrentDatabase());
        SessionState.start((HiveConf)new HiveConf());
        Assert.assertEquals((Object)"default", (Object)SessionState.get().getCurrentDatabase());
    }

    @Test
    public void testClose() throws Exception {
        SessionState ss = SessionState.get();
        Assert.assertNull((Object)ss.getTezSession());
        ss.close();
        Assert.assertNull((Object)ss.getTezSession());
    }

    @Test
    public void testClassLoaderEquality() throws Exception {
        HiveConf conf = new HiveConf();
        SessionState ss1 = new SessionState(conf);
        RegisterJarRunnable otherThread = new RegisterJarRunnable("./build/contrib/test/test-udfs.jar", ss1);
        Thread th1 = new Thread(otherThread);
        th1.start();
        th1.join();
        SessionState.start((SessionState)ss1);
        SessionState ss2 = SessionState.get();
        ClassLoader loader2 = ss2.conf.getClassLoader();
        System.out.println("Loader1:(Set in other thread) " + otherThread.loader);
        System.out.println("Loader2:(Set in SessionState.conf) " + loader2);
        System.out.println("Loader3:(CurrentThread.getContextClassLoader()) " + Thread.currentThread().getContextClassLoader());
        Assert.assertEquals((String)"Other thread loader and session state loader", (Object)otherThread.loader, (Object)loader2);
        Assert.assertEquals((String)"Other thread loader and current thread loader", (Object)otherThread.loader, (Object)Thread.currentThread().getContextClassLoader());
    }

    class RegisterJarRunnable
    implements Runnable {
        String jar;
        ClassLoader loader;
        SessionState ss;

        public RegisterJarRunnable(String jar, SessionState ss) {
            this.jar = jar;
            this.ss = ss;
        }

        @Override
        public void run() {
            SessionState.start((SessionState)this.ss);
            SessionState.registerJar((String)this.jar);
            this.loader = Thread.currentThread().getContextClassLoader();
        }
    }
}

