/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.parse.AbstractSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestReadEntityDirect {
    @BeforeClass
    public static void onetimeSetup() throws CommandNeedRetryException {
        Driver driver = TestReadEntityDirect.createDriver();
        int ret = driver.run("create table t1(i int)").getResponseCode();
        Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
        ret = driver.run("create view v1 as select * from t1").getResponseCode();
        Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
    }

    @Before
    public void setup() {
        CheckInputReadEntityDirect.readEntities = null;
    }

    @Test
    public void testSelectEntityDirect() throws ParseException {
        Driver driver = TestReadEntityDirect.createDriver();
        int ret = driver.compile("select * from t1");
        Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
        Assert.assertEquals((long)1L, (long)CheckInputReadEntityDirect.readEntities.size());
        Assert.assertTrue((String)"isDirect", (boolean)CheckInputReadEntityDirect.readEntities.iterator().next().isDirect());
    }

    @Test
    public void testSelectEntityInDirect() throws ParseException {
        Driver driver = TestReadEntityDirect.createDriver();
        int ret = driver.compile("select * from v1");
        Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
        Assert.assertEquals((long)2L, (long)CheckInputReadEntityDirect.readEntities.size());
        for (ReadEntity readEntity : CheckInputReadEntityDirect.readEntities) {
            if (readEntity.getName().equals("default@t1")) {
                Assert.assertFalse((String)"not direct", (boolean)readEntity.isDirect());
                continue;
            }
            if (readEntity.getName().equals("default@v1")) {
                Assert.assertTrue((String)"direct", (boolean)readEntity.isDirect());
                continue;
            }
            Assert.fail((String)("unexpected entity name " + readEntity.getName()));
        }
    }

    @Test
    public void testSelectEntityViewDirectJoin() throws ParseException {
        Driver driver = TestReadEntityDirect.createDriver();
        int ret = driver.compile("select * from v1 join t1 on (v1.i = t1.i)");
        Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
        Assert.assertEquals((long)2L, (long)CheckInputReadEntityDirect.readEntities.size());
        for (ReadEntity readEntity : CheckInputReadEntityDirect.readEntities) {
            if (readEntity.getName().equals("default@t1")) {
                Assert.assertTrue((String)"direct", (boolean)readEntity.isDirect());
                continue;
            }
            if (readEntity.getName().equals("default@v1")) {
                Assert.assertTrue((String)"direct", (boolean)readEntity.isDirect());
                continue;
            }
            Assert.fail((String)("unexpected entity name " + readEntity.getName()));
        }
    }

    @Test
    public void testSelectEntityViewDirectUnion() throws ParseException {
        Driver driver = TestReadEntityDirect.createDriver();
        int ret = driver.compile("select * from ( select * from v1 union all select * from t1) uv1t1");
        Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
        Assert.assertEquals((long)2L, (long)CheckInputReadEntityDirect.readEntities.size());
        for (ReadEntity readEntity : CheckInputReadEntityDirect.readEntities) {
            if (readEntity.getName().equals("default@t1")) {
                Assert.assertTrue((String)"direct", (boolean)readEntity.isDirect());
                continue;
            }
            if (readEntity.getName().equals("default@v1")) {
                Assert.assertTrue((String)"direct", (boolean)readEntity.isDirect());
                continue;
            }
            Assert.fail((String)("unexpected entity name " + readEntity.getName()));
        }
    }

    @Test
    public void testSelectEntityInDirectJoinAlias() throws ParseException {
        Driver driver = TestReadEntityDirect.createDriver();
        int ret = driver.compile("select * from v1 as a join v1 as b on (a.i = b.i)");
        Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
        Assert.assertEquals((long)2L, (long)CheckInputReadEntityDirect.readEntities.size());
        for (ReadEntity readEntity : CheckInputReadEntityDirect.readEntities) {
            if (readEntity.getName().equals("default@t1")) {
                Assert.assertFalse((String)"not direct", (boolean)readEntity.isDirect());
                continue;
            }
            if (readEntity.getName().equals("default@v1")) {
                Assert.assertTrue((String)"direct", (boolean)readEntity.isDirect());
                continue;
            }
            Assert.fail((String)("unexpected entity name " + readEntity.getName()));
        }
    }

    private static Driver createDriver() {
        HiveConf conf = new HiveConf(Driver.class);
        conf.setVar(HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK, CheckInputReadEntityDirect.class.getName());
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        SessionState.start((HiveConf)conf);
        Driver driver = new Driver(conf);
        driver.init();
        return driver;
    }

    public static class CheckInputReadEntityDirect
    extends AbstractSemanticAnalyzerHook {
        public static Set<ReadEntity> readEntities;

        public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<? extends Serializable>> rootTasks) throws SemanticException {
            readEntities = context.getInputs();
        }
    }
}

