/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import junit.framework.Assert;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.DDLTask;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Test;

public class TestHiveDecimalParse {
    @Test
    public void testDecimalType() throws ParseException {
        String query = "create table dec (d decimal)";
        String type = this.getColumnType(query);
        Assert.assertEquals((String)"decimal(10,0)", (String)type);
    }

    @Test
    public void testDecimalType1() throws ParseException {
        String query = "create table dec (d decimal(5))";
        String type = this.getColumnType(query);
        Assert.assertEquals((String)"decimal(5,0)", (String)type);
    }

    @Test
    public void testDecimalType2() throws ParseException {
        String query = "create table dec (d decimal(9,7))";
        String type = this.getColumnType(query);
        Assert.assertEquals((String)"decimal(9,7)", (String)type);
    }

    @Test
    public void testDecimalType3() throws ParseException {
        String query = "create table dec (d decimal(66,7))";
        Driver driver = this.createDriver();
        int rc = driver.compile(query);
        Assert.assertTrue((String)("Got " + rc + ", expected not zero"), (rc != 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)driver.getErrorMsg(), (boolean)driver.getErrorMsg().contains("Decimal precision out of allowed range [1,38]"));
    }

    @Test
    public void testDecimalType4() throws ParseException {
        String query = "create table dec (d decimal(0,7))";
        Driver driver = this.createDriver();
        int rc = driver.compile(query);
        Assert.assertTrue((String)("Got " + rc + ", expected not zero"), (rc != 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)driver.getErrorMsg(), (boolean)driver.getErrorMsg().contains("Decimal precision out of allowed range [1,38]"));
    }

    @Test
    public void testDecimalType5() throws ParseException {
        String query = "create table dec (d decimal(7,33))";
        Driver driver = this.createDriver();
        int rc = driver.compile(query);
        Assert.assertTrue((String)("Got " + rc + ", expected not zero"), (rc != 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)driver.getErrorMsg(), (boolean)driver.getErrorMsg().contains("Decimal scale must be less than or equal to precision"));
    }

    @Test
    public void testDecimalType6() throws ParseException {
        String query = "create table dec (d decimal(7,-1))";
        Driver driver = this.createDriver();
        int rc = driver.compile(query);
        Assert.assertTrue((String)("Got " + rc + ", expected not zero"), (rc != 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)driver.getErrorMsg(), (boolean)driver.getErrorMsg().contains("extraneous input '-' expecting Number"));
    }

    @Test
    public void testDecimalType7() throws ParseException {
        String query = "create table dec (d decimal(7,33,4))";
        Driver driver = this.createDriver();
        int rc = driver.compile(query);
        Assert.assertTrue((String)("Got " + rc + ", expected not zero"), (rc != 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)driver.getErrorMsg(), (boolean)driver.getErrorMsg().contains("missing ) at ',' near ',' in column specification"));
    }

    @Test
    public void testDecimalType8() throws ParseException {
        String query = "create table dec (d decimal(7a))";
        Driver driver = this.createDriver();
        int rc = driver.compile(query);
        Assert.assertTrue((String)("Got " + rc + ", expected not zero"), (rc != 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)driver.getErrorMsg(), (boolean)driver.getErrorMsg().contains("mismatched input '7a' expecting Number near '('"));
    }

    @Test
    public void testDecimalType9() throws ParseException {
        String query = "create table dec (d decimal(20,23))";
        Driver driver = this.createDriver();
        int rc = driver.compile(query);
        Assert.assertTrue((String)("Got " + rc + ", expected not zero"), (rc != 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)driver.getErrorMsg(), (boolean)driver.getErrorMsg().contains("Decimal scale must be less than or equal to precision"));
    }

    private Driver createDriver() {
        HiveConf conf = new HiveConf(Driver.class);
        SessionState.start((HiveConf)conf);
        Driver driver = new Driver(conf);
        driver.init();
        return driver;
    }

    private String getColumnType(String query) {
        Driver driver = this.createDriver();
        int rc = driver.compile(query);
        if (rc != 0) {
            return null;
        }
        QueryPlan plan = driver.getPlan();
        DDLTask task = (DDLTask)plan.getRootTasks().get(0);
        DDLWork work = (DDLWork)task.getWork();
        CreateTableDesc spec = work.getCreateTblDesc();
        FieldSchema fs = (FieldSchema)spec.getCols().get(0);
        return fs.getType();
    }
}

