/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.index.HiveIndex;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.thrift.ThriftDeserializer;
import org.apache.hadoop.hive.serde2.thrift.test.Complex;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.thrift.protocol.TBinaryProtocol;

public class TestHive
extends TestCase {
    protected Hive hm;
    protected HiveConf hiveConf;

    protected void setUp() throws Exception {
        super.setUp();
        this.hiveConf = new HiveConf(((Object)((Object)this)).getClass());
        SessionState.start((HiveConf)this.hiveConf);
        try {
            this.hm = Hive.get((HiveConf)this.hiveConf);
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("Unable to initialize Hive Metastore using configuration: \n " + this.hiveConf);
            throw e;
        }
    }

    protected void tearDown() throws Exception {
        try {
            super.tearDown();
            Hive.closeCurrent();
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("Unable to close Hive Metastore using configruation: \n " + this.hiveConf);
            throw e;
        }
    }

    public void testTable() throws Throwable {
        try {
            String tableName = "table_for_testtable";
            try {
                this.hm.dropTable("default", tableName);
            }
            catch (HiveException e1) {
                e1.printStackTrace();
                TestHive.assertTrue((String)"Unable to drop table", (boolean)false);
            }
            Table tbl = new Table("default", tableName);
            List fields = tbl.getCols();
            fields.add(new FieldSchema("col1", "int", "int -- first column"));
            fields.add(new FieldSchema("col2", "string", "string -- second column"));
            fields.add(new FieldSchema("col3", "double", "double -- thrift column"));
            tbl.setFields(fields);
            tbl.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
            tbl.setInputFormatClass(SequenceFileInputFormat.class);
            tbl.setProperty("comment", "this is a test table created as part junit tests");
            List bucketCols = tbl.getBucketCols();
            bucketCols.add("col1");
            try {
                tbl.setBucketCols(bucketCols);
            }
            catch (HiveException e) {
                e.printStackTrace();
                TestHive.assertTrue((String)("Unable to set bucket column for table: " + tableName), (boolean)false);
            }
            ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
            partCols.add(new FieldSchema("ds", "string", "partition column, date but in string format as date type is not yet supported in QL"));
            tbl.setPartCols(partCols);
            tbl.setNumBuckets(512);
            tbl.setOwner("pchakka");
            tbl.setRetention(10);
            tbl.setSerdeParam("field.delim", "1");
            tbl.setSerdeParam("line.delim", "\n");
            tbl.setSerdeParam("mapkey.delim", "3");
            tbl.setSerdeParam("colelction.delim", "2");
            tbl.setSerdeParam("field.delim", "1");
            tbl.setSerializationLib(LazySimpleSerDe.class.getName());
            tbl.setStoredAsSubDirectories(false);
            this.setNullCreateTableGrants();
            try {
                this.hm.createTable(tbl);
            }
            catch (HiveException e) {
                e.printStackTrace();
                TestHive.assertTrue((String)("Unable to create table: " + tableName), (boolean)false);
            }
            this.validateTable(tbl, tableName);
            try {
                this.hm.dropTable("default", tableName, true, false);
                Table ft2 = this.hm.getTable("default", tableName, false);
                TestHive.assertNull((String)"Unable to drop table ", (Object)ft2);
            }
            catch (HiveException e) {
                TestHive.assertTrue((String)("Unable to drop table: " + tableName), (boolean)false);
            }
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testTable failed");
            throw e;
        }
    }

    private void setNullCreateTableGrants() {
        SessionState.get().setCreateTableGrants(null);
    }

    public void testThriftTable() throws Throwable {
        String tableName = "table_for_test_thrifttable";
        try {
            try {
                this.hm.dropTable("default", tableName);
            }
            catch (HiveException e1) {
                System.err.println(StringUtils.stringifyException((Throwable)e1));
                TestHive.assertTrue((String)"Unable to drop table", (boolean)false);
            }
            Table tbl = new Table("default", tableName);
            tbl.setInputFormatClass(SequenceFileInputFormat.class.getName());
            tbl.setOutputFormatClass(SequenceFileOutputFormat.class.getName());
            tbl.setSerializationLib(ThriftDeserializer.class.getName());
            tbl.setSerdeParam("serialization.class", Complex.class.getName());
            tbl.setSerdeParam("serialization.format", TBinaryProtocol.class.getName());
            tbl.setStoredAsSubDirectories(false);
            this.setNullCreateTableGrants();
            try {
                this.hm.createTable(tbl);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                TestHive.assertTrue((String)("Unable to create table: " + tableName), (boolean)false);
            }
            this.validateTable(tbl, tableName);
            this.hm.dropTable("default", tableName);
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testThriftTable() failed");
            throw e;
        }
    }

    private void validateTable(Table tbl, String tableName) throws MetaException {
        Warehouse wh = new Warehouse((Configuration)this.hiveConf);
        Table ft = null;
        try {
            tbl.getTTable().setPrivilegesIsSet(false);
            ft = this.hm.getTable("default", tableName);
            TestHive.assertNotNull((String)"Unable to fetch table", (Object)ft);
            ft.checkValidity();
            TestHive.assertEquals((String)("Table names didn't match for table: " + tableName), (String)tbl.getTableName(), (String)ft.getTableName());
            TestHive.assertEquals((String)("Table owners didn't match for table: " + tableName), (String)tbl.getOwner(), (String)ft.getOwner());
            TestHive.assertEquals((String)("Table retention didn't match for table: " + tableName), (int)tbl.getRetention(), (int)ft.getRetention());
            TestHive.assertEquals((String)"Data location is not set correctly", (String)wh.getTablePath(this.hm.getDatabase("default"), tableName).toString(), (String)ft.getDataLocation().toString());
            tbl.setDataLocation(ft.getDataLocation());
            tbl.setCreateTime(ft.getTTable().getCreateTime());
            tbl.getParameters().put("transient_lastDdlTime", ft.getParameters().get("transient_lastDdlTime"));
            TestHive.assertTrue((String)("Tables  doesn't match: " + tableName), (boolean)ft.getTTable().equals(tbl.getTTable()));
            TestHive.assertEquals((String)"SerializationLib is not set correctly", (String)tbl.getSerializationLib(), (String)ft.getSerializationLib());
            TestHive.assertEquals((String)"Serde is not set correctly", (String)tbl.getDeserializer().getClass().getName(), (String)ft.getDeserializer().getClass().getName());
        }
        catch (HiveException e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            TestHive.assertTrue((String)("Unable to fetch table correctly: " + tableName), (boolean)false);
        }
    }

    private static Table createTestTable(String dbName, String tableName) throws HiveException {
        Table tbl = new Table(dbName, tableName);
        tbl.setInputFormatClass(SequenceFileInputFormat.class.getName());
        tbl.setOutputFormatClass(SequenceFileOutputFormat.class.getName());
        tbl.setSerializationLib(ThriftDeserializer.class.getName());
        tbl.setSerdeParam("serialization.class", Complex.class.getName());
        tbl.setSerdeParam("serialization.format", TBinaryProtocol.class.getName());
        return tbl;
    }

    public void testHiveCloseCurrent() throws Throwable {
        Hive hive1 = Hive.get();
        Hive.closeCurrent();
        Hive hive2 = Hive.get();
        Hive.closeCurrent();
        TestHive.assertTrue((hive1 != hive2 ? 1 : 0) != 0);
    }

    public void testGetAndDropTables() throws Throwable {
        try {
            String dbName = "db_for_testgettables";
            String table1Name = "table1";
            this.hm.dropDatabase(dbName, true, true);
            Database db = new Database();
            db.setName(dbName);
            this.hm.createDatabase(db);
            ArrayList<String> ts = new ArrayList<String>(2);
            ts.add(table1Name);
            ts.add("table2");
            Table tbl1 = TestHive.createTestTable(dbName, (String)ts.get(0));
            this.hm.createTable(tbl1);
            Table tbl2 = TestHive.createTestTable(dbName, (String)ts.get(1));
            this.hm.createTable(tbl2);
            List fts = this.hm.getTablesForDb(dbName, ".*");
            TestHive.assertEquals(ts, (Object)fts);
            TestHive.assertEquals((int)2, (int)fts.size());
            fts = this.hm.getTablesForDb(dbName, ".*1");
            TestHive.assertEquals((int)1, (int)fts.size());
            TestHive.assertEquals((String)((String)ts.get(0)), (String)((String)fts.get(0)));
            Table table1 = this.hm.getTable(dbName, table1Name);
            TestHive.assertNotNull((Object)table1);
            TestHive.assertEquals((String)table1Name, (String)table1.getTableName());
            FileSystem fs = table1.getPath().getFileSystem((Configuration)this.hiveConf);
            TestHive.assertTrue((boolean)fs.exists(table1.getPath()));
            this.hm.dropTable(dbName, table1Name);
            TestHive.assertFalse((boolean)fs.exists(table1.getPath()));
            for (String tableName : this.hm.getAllTables(dbName)) {
                this.hm.dropTable(dbName, tableName);
            }
            this.hm.dropDatabase(dbName);
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testGetTables() failed");
            throw e;
        }
    }

    public void testPartition() throws Throwable {
        try {
            String tableName = "table_for_testpartition";
            try {
                this.hm.dropTable("default", tableName);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                TestHive.assertTrue((String)("Unable to drop table: " + tableName), (boolean)false);
            }
            LinkedList<String> cols = new LinkedList<String>();
            cols.add("key");
            cols.add("value");
            LinkedList<String> part_cols = new LinkedList<String>();
            part_cols.add("ds");
            part_cols.add("hr");
            try {
                this.hm.createTable(tableName, cols, part_cols, TextInputFormat.class, HiveIgnoreKeyTextOutputFormat.class);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                TestHive.assertTrue((String)("Unable to create table: " + tableName), (boolean)false);
            }
            Table tbl = null;
            try {
                tbl = this.hm.getTable("default", tableName);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                TestHive.assertTrue((String)("Unable to fetch table: " + tableName), (boolean)false);
            }
            HashMap<String, String> part_spec = new HashMap<String, String>();
            part_spec.clear();
            part_spec.put("ds", "2008-04-08");
            part_spec.put("hr", "12");
            try {
                this.hm.createPartition(tbl, part_spec);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                TestHive.assertTrue((String)("Unable to create parition for table: " + tableName), (boolean)false);
            }
            this.hm.dropTable("default", tableName);
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testPartition() failed");
            throw e;
        }
    }

    public void testIndex() throws Throwable {
        try {
            String tableName = "table_for_testindex";
            try {
                this.hm.dropTable("default", tableName);
            }
            catch (HiveException e) {
                e.printStackTrace();
                TestHive.assertTrue((String)"Unable to drop table", (boolean)false);
            }
            Table tbl = new Table("default", tableName);
            List fields = tbl.getCols();
            fields.add(new FieldSchema("col1", "int", "int -- first column"));
            fields.add(new FieldSchema("col2", "string", "string -- second column"));
            fields.add(new FieldSchema("col3", "double", "double -- thrift column"));
            tbl.setFields(fields);
            tbl.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
            tbl.setInputFormatClass(SequenceFileInputFormat.class);
            try {
                this.hm.createTable(tbl);
            }
            catch (HiveException e) {
                e.printStackTrace();
                TestHive.assertTrue((String)("Unable to create table: " + tableName), (boolean)false);
            }
            String indexName = "index_on_table_for_testindex";
            String indexHandlerClass = HiveIndex.IndexType.COMPACT_SUMMARY_TABLE.getHandlerClsName();
            ArrayList<String> indexedCols = new ArrayList<String>();
            indexedCols.add("col1");
            String indexTableName = "index_on_table_for_testindex_table";
            boolean deferredRebuild = true;
            String inputFormat = SequenceFileInputFormat.class.getName();
            String outputFormat = SequenceFileOutputFormat.class.getName();
            String serde = null;
            String storageHandler = null;
            String location = null;
            String collItemDelim = null;
            String fieldDelim = null;
            String fieldEscape = null;
            String lineDelim = null;
            String mapKeyDelim = null;
            String indexComment = null;
            Map indexProps = null;
            Map tableProps = null;
            HashMap serdeProps = new HashMap();
            this.hm.createIndex(tableName, indexName, indexHandlerClass, indexedCols, indexTableName, deferredRebuild, inputFormat, outputFormat, serde, storageHandler, location, indexProps, tableProps, serdeProps, collItemDelim, fieldDelim, fieldEscape, lineDelim, mapKeyDelim, indexComment);
            Index index = null;
            try {
                index = this.hm.getIndex(tableName, indexName);
                TestHive.assertNotNull((String)"Unable to fetch index", (Object)index);
                index.validate();
                TestHive.assertEquals((String)("Index names don't match for index: " + indexName), (String)indexName, (String)index.getIndexName());
                TestHive.assertEquals((String)("Table names don't match for index: " + indexName), (String)tableName, (String)index.getOrigTableName());
                TestHive.assertEquals((String)("Index table names didn't match for index: " + indexName), (String)indexTableName, (String)index.getIndexTableName());
                TestHive.assertEquals((String)("Index handler classes didn't match for index: " + indexName), (String)indexHandlerClass, (String)index.getIndexHandlerClass());
                TestHive.assertEquals((String)("Deferred rebuild didn't match for index: " + indexName), (boolean)deferredRebuild, (boolean)index.isDeferredRebuild());
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                TestHive.assertTrue((String)("Unable to fetch index correctly: " + indexName), (boolean)false);
            }
            try {
                this.hm.dropIndex("default", tableName, indexName, true);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                TestHive.assertTrue((String)("Unable to drop index: " + indexName), (boolean)false);
            }
            boolean dropIndexException = false;
            try {
                this.hm.getIndex(tableName, indexName);
            }
            catch (HiveException e) {
                dropIndexException = true;
            }
            TestHive.assertTrue((String)("Unable to drop index: " + indexName), (boolean)dropIndexException);
            try {
                this.hm.dropTable(tableName);
                Table droppedTable = this.hm.getTable(tableName, false);
                TestHive.assertNull((String)("Unable to drop table " + tableName), (Object)droppedTable);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                TestHive.assertTrue((String)("Unable to drop table: " + tableName), (boolean)false);
            }
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testIndex failed");
            throw e;
        }
    }

    public void testHiveRefreshOnConfChange() throws Throwable {
        HiveConf newHconf;
        Hive newHiveObj;
        Hive prevHiveObj = Hive.get();
        TestHive.assertTrue((prevHiveObj == (newHiveObj = Hive.get((HiveConf)(newHconf = new HiveConf(this.hiveConf)))) ? 1 : 0) != 0);
        newHiveObj = Hive.get((HiveConf)newHconf, (boolean)true);
        TestHive.assertTrue((prevHiveObj != newHiveObj ? 1 : 0) != 0);
        prevHiveObj = Hive.get();
        newHconf = new HiveConf(this.hiveConf);
        newHconf.setIntVar(HiveConf.ConfVars.METASTORETHRIFTCONNECTIONRETRIES, newHconf.getIntVar(HiveConf.ConfVars.METASTORETHRIFTCONNECTIONRETRIES) + 1);
        newHiveObj = Hive.get((HiveConf)newHconf);
        TestHive.assertTrue((prevHiveObj != newHiveObj ? 1 : 0) != 0);
    }
}

