/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lockmgr.DbLockManager;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.TxnManagerFactory;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestDbTxnManager {
    private HiveConf conf = new HiveConf();
    private HiveTxnManager txnMgr;
    private Context ctx;
    private int nextInput;
    private int nextOutput;
    HashSet<ReadEntity> readEntities;
    HashSet<WriteEntity> writeEntities;

    public TestDbTxnManager() throws Exception {
        TxnDbUtil.setConfValues((HiveConf)this.conf);
        this.ctx = new Context((Configuration)this.conf);
        LogManager.getRootLogger().setLevel(Level.DEBUG);
        this.tearDown();
    }

    @Test
    public void testSingleReadTable() throws Exception {
        this.addTableInput();
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((int)1, (int)locks.size());
        Assert.assertEquals((int)1, (int)TxnDbUtil.countLockComponents((long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.getLockManager().unlock((HiveLock)locks.get(0));
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((int)0, (int)locks.size());
    }

    @Test
    public void testSingleReadPartition() throws Exception {
        this.addPartitionInput(this.newTable(true));
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, null);
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((int)1, (int)locks.size());
        Assert.assertEquals((int)1, (int)TxnDbUtil.countLockComponents((long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.getLockManager().unlock((HiveLock)locks.get(0));
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((int)0, (int)locks.size());
    }

    @Test
    public void testSingleReadMultiPartition() throws Exception {
        Table t = this.newTable(true);
        this.addPartitionInput(t);
        this.addPartitionInput(t);
        this.addPartitionInput(t);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((int)1, (int)locks.size());
        Assert.assertEquals((int)3, (int)TxnDbUtil.countLockComponents((long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.getLockManager().unlock((HiveLock)locks.get(0));
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((int)0, (int)locks.size());
    }

    @Test
    public void testJoin() throws Exception {
        Table t = this.newTable(true);
        this.addPartitionInput(t);
        this.addPartitionInput(t);
        this.addPartitionInput(t);
        this.addTableInput();
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((int)1, (int)locks.size());
        Assert.assertEquals((int)4, (int)TxnDbUtil.countLockComponents((long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.getLockManager().unlock((HiveLock)locks.get(0));
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((int)0, (int)locks.size());
    }

    @Test
    public void testSingleWriteTable() throws Exception {
        WriteEntity we = this.addTableOutput(WriteEntity.WriteType.INSERT);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((int)1, (int)locks.size());
        Assert.assertEquals((int)1, (int)TxnDbUtil.countLockComponents((long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.getLockManager().unlock((HiveLock)locks.get(0));
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((int)0, (int)locks.size());
    }

    @Test
    public void testReadWrite() throws Exception {
        Table t = this.newTable(true);
        this.addPartitionInput(t);
        this.addPartitionInput(t);
        this.addPartitionInput(t);
        WriteEntity we = this.addTableOutput(WriteEntity.WriteType.INSERT);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((int)1, (int)locks.size());
        Assert.assertEquals((int)4, (int)TxnDbUtil.countLockComponents((long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.getLockManager().unlock((HiveLock)locks.get(0));
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((int)0, (int)locks.size());
    }

    @Test
    public void testUpdate() throws Exception {
        WriteEntity we = this.addTableOutput(WriteEntity.WriteType.UPDATE);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((int)1, (int)locks.size());
        Assert.assertEquals((int)1, (int)TxnDbUtil.countLockComponents((long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.getLockManager().unlock((HiveLock)locks.get(0));
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((int)0, (int)locks.size());
    }

    @Test
    public void testDelete() throws Exception {
        WriteEntity we = this.addTableOutput(WriteEntity.WriteType.DELETE);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((int)1, (int)locks.size());
        Assert.assertEquals((int)1, (int)TxnDbUtil.countLockComponents((long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.getLockManager().unlock((HiveLock)locks.get(0));
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((int)0, (int)locks.size());
    }

    @Test
    public void testDDLExclusive() throws Exception {
        WriteEntity we = this.addTableOutput(WriteEntity.WriteType.DDL_EXCLUSIVE);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((int)1, (int)locks.size());
        Assert.assertEquals((int)1, (int)TxnDbUtil.countLockComponents((long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.getLockManager().unlock((HiveLock)locks.get(0));
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((int)0, (int)locks.size());
    }

    @Test
    public void testDDLShared() throws Exception {
        WriteEntity we = this.addTableOutput(WriteEntity.WriteType.DDL_SHARED);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((int)1, (int)locks.size());
        Assert.assertEquals((int)1, (int)TxnDbUtil.countLockComponents((long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.getLockManager().unlock((HiveLock)locks.get(0));
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((int)0, (int)locks.size());
    }

    @Test
    public void testDDLNoLock() throws Exception {
        WriteEntity we = this.addTableOutput(WriteEntity.WriteType.DDL_NO_LOCK);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertNull((Object)locks);
    }

    @Before
    public void setUp() throws Exception {
        TxnDbUtil.prepDb();
        this.txnMgr = TxnManagerFactory.getTxnManagerFactory().getTxnManager(this.conf);
        Assert.assertTrue((boolean)(this.txnMgr instanceof DbTxnManager));
        this.nextInput = 1;
        this.nextOutput = 1;
        this.readEntities = new HashSet();
        this.writeEntities = new HashSet();
    }

    @After
    public void tearDown() throws Exception {
        TxnDbUtil.cleanDb();
    }

    private Table newTable(boolean isPartitioned) {
        Table t = new Table("default", "table" + Integer.toString(this.nextInput++));
        if (isPartitioned) {
            FieldSchema fs = new FieldSchema();
            fs.setName("version");
            fs.setType("String");
            ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>(1);
            partCols.add(fs);
            t.setPartCols(partCols);
        }
        return t;
    }

    private void addTableInput() {
        ReadEntity re = new ReadEntity(this.newTable(false));
        this.readEntities.add(re);
    }

    private void addPartitionInput(Table t) throws Exception {
        HashMap<String, String> partSpec = new HashMap<String, String>();
        partSpec.put("version", Integer.toString(this.nextInput++));
        Partition p = new Partition(t, partSpec, new Path("/dev/null"));
        ReadEntity re = new ReadEntity(p);
        this.readEntities.add(re);
    }

    private WriteEntity addTableOutput(WriteEntity.WriteType writeType) {
        WriteEntity we = new WriteEntity(this.newTable(false), writeType);
        this.writeEntities.add(we);
        return we;
    }

    private WriteEntity addPartitionOutput(Table t, WriteEntity.WriteType writeType) throws Exception {
        HashMap<String, String> partSpec = new HashMap<String, String>();
        partSpec.put("version", Integer.toString(this.nextInput++));
        Partition p = new Partition(t, partSpec, new Path("/dev/null"));
        WriteEntity we = new WriteEntity(p, writeType);
        this.writeEntities.add(we);
        return we;
    }

    private static class MockQueryPlan
    extends QueryPlan {
        private HashSet<ReadEntity> inputs;
        private HashSet<WriteEntity> outputs;

        MockQueryPlan(TestDbTxnManager test) {
            HashSet r = test.readEntities;
            HashSet w = test.writeEntities;
            this.inputs = r == null ? new HashSet() : r;
            this.outputs = w == null ? new HashSet() : w;
        }

        public HashSet<ReadEntity> getInputs() {
            return this.inputs;
        }

        public HashSet<WriteEntity> getOutputs() {
            return this.outputs;
        }
    }
}

