/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.sarg;

import com.google.common.collect.Sets;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentImpl;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.junit.Test;

public class TestSearchArgumentImpl {
    private SearchArgumentImpl.ExpressionTree not(SearchArgumentImpl.ExpressionTree arg) {
        return new SearchArgumentImpl.ExpressionTree(SearchArgumentImpl.ExpressionTree.Operator.NOT, new SearchArgumentImpl.ExpressionTree[]{arg});
    }

    private SearchArgumentImpl.ExpressionTree and(SearchArgumentImpl.ExpressionTree ... arg) {
        return new SearchArgumentImpl.ExpressionTree(SearchArgumentImpl.ExpressionTree.Operator.AND, arg);
    }

    private SearchArgumentImpl.ExpressionTree or(SearchArgumentImpl.ExpressionTree ... arg) {
        return new SearchArgumentImpl.ExpressionTree(SearchArgumentImpl.ExpressionTree.Operator.OR, arg);
    }

    private SearchArgumentImpl.ExpressionTree leaf(int leaf) {
        return new SearchArgumentImpl.ExpressionTree(leaf);
    }

    private SearchArgumentImpl.ExpressionTree constant(SearchArgument.TruthValue val) {
        return new SearchArgumentImpl.ExpressionTree(val);
    }

    public static PredicateLeaf createPredicateLeaf(PredicateLeaf.Operator operator, PredicateLeaf.Type type, String columnName, Object literal, List<Object> literalList) {
        return new SearchArgumentImpl.PredicateLeafImpl(operator, type, columnName, literal, literalList);
    }

    @Test
    public void testNotPushdown() throws Exception {
        Assert.assertEquals((String)"leaf-1", (String)SearchArgumentImpl.ExpressionBuilder.pushDownNot((SearchArgumentImpl.ExpressionTree)this.leaf(1)).toString());
        Assert.assertEquals((String)"(not leaf-1)", (String)SearchArgumentImpl.ExpressionBuilder.pushDownNot((SearchArgumentImpl.ExpressionTree)this.not(this.leaf(1))).toString());
        Assert.assertEquals((String)"leaf-1", (String)SearchArgumentImpl.ExpressionBuilder.pushDownNot((SearchArgumentImpl.ExpressionTree)this.not(this.not(this.leaf(1)))).toString());
        Assert.assertEquals((String)"(not leaf-1)", (String)SearchArgumentImpl.ExpressionBuilder.pushDownNot((SearchArgumentImpl.ExpressionTree)this.not(this.not(this.not(this.leaf(1))))).toString());
        Assert.assertEquals((String)"(or leaf-1 (not leaf-2))", (String)SearchArgumentImpl.ExpressionBuilder.pushDownNot((SearchArgumentImpl.ExpressionTree)this.not(this.and(this.not(this.leaf(1)), this.leaf(2)))).toString());
        Assert.assertEquals((String)"(and (not leaf-1) leaf-2)", (String)SearchArgumentImpl.ExpressionBuilder.pushDownNot((SearchArgumentImpl.ExpressionTree)this.not(this.or(this.leaf(1), this.not(this.leaf(2))))).toString());
        Assert.assertEquals((String)"(or (or (not leaf-1) leaf-2) leaf-3)", (String)SearchArgumentImpl.ExpressionBuilder.pushDownNot((SearchArgumentImpl.ExpressionTree)this.or(this.not(this.and(this.leaf(1), this.not(this.leaf(2)))), this.not(this.not(this.leaf(3))))).toString());
        Assert.assertEquals((String)"NO", (String)SearchArgumentImpl.ExpressionBuilder.pushDownNot((SearchArgumentImpl.ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.YES))).toString());
        Assert.assertEquals((String)"YES", (String)SearchArgumentImpl.ExpressionBuilder.pushDownNot((SearchArgumentImpl.ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.NO))).toString());
        Assert.assertEquals((String)"NULL", (String)SearchArgumentImpl.ExpressionBuilder.pushDownNot((SearchArgumentImpl.ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.NULL))).toString());
        Assert.assertEquals((String)"YES_NO", (String)SearchArgumentImpl.ExpressionBuilder.pushDownNot((SearchArgumentImpl.ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.YES_NO))).toString());
        Assert.assertEquals((String)"YES_NULL", (String)SearchArgumentImpl.ExpressionBuilder.pushDownNot((SearchArgumentImpl.ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.NO_NULL))).toString());
        Assert.assertEquals((String)"NO_NULL", (String)SearchArgumentImpl.ExpressionBuilder.pushDownNot((SearchArgumentImpl.ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.YES_NULL))).toString());
        Assert.assertEquals((String)"YES_NO_NULL", (String)SearchArgumentImpl.ExpressionBuilder.pushDownNot((SearchArgumentImpl.ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.YES_NO_NULL))).toString());
    }

    @Test
    public void testFlatten() throws Exception {
        Assert.assertEquals((String)"leaf-1", (String)SearchArgumentImpl.ExpressionBuilder.flatten((SearchArgumentImpl.ExpressionTree)this.leaf(1)).toString());
        Assert.assertEquals((String)"NO", (String)SearchArgumentImpl.ExpressionBuilder.flatten((SearchArgumentImpl.ExpressionTree)this.constant(SearchArgument.TruthValue.NO)).toString());
        Assert.assertEquals((String)"(not (not leaf-1))", (String)SearchArgumentImpl.ExpressionBuilder.flatten((SearchArgumentImpl.ExpressionTree)this.not(this.not(this.leaf(1)))).toString());
        Assert.assertEquals((String)"(and leaf-1 leaf-2)", (String)SearchArgumentImpl.ExpressionBuilder.flatten((SearchArgumentImpl.ExpressionTree)this.and(this.leaf(1), this.leaf(2))).toString());
        Assert.assertEquals((String)"(and (or leaf-1 leaf-2) leaf-3)", (String)SearchArgumentImpl.ExpressionBuilder.flatten((SearchArgumentImpl.ExpressionTree)this.and(this.or(this.leaf(1), this.leaf(2)), this.leaf(3))).toString());
        Assert.assertEquals((String)"(and leaf-1 leaf-2 leaf-3 leaf-4)", (String)SearchArgumentImpl.ExpressionBuilder.flatten((SearchArgumentImpl.ExpressionTree)this.and(this.and(this.leaf(1), this.leaf(2)), this.and(this.leaf(3), this.leaf(4)))).toString());
        Assert.assertEquals((String)"(or leaf-1 leaf-2 leaf-3 leaf-4)", (String)SearchArgumentImpl.ExpressionBuilder.flatten((SearchArgumentImpl.ExpressionTree)this.or(this.leaf(1), this.or(this.leaf(2), this.or(this.leaf(3), this.leaf(4))))).toString());
        Assert.assertEquals((String)"(or leaf-1 leaf-2 leaf-3 leaf-4)", (String)SearchArgumentImpl.ExpressionBuilder.flatten((SearchArgumentImpl.ExpressionTree)this.or(this.or(this.or(this.leaf(1), this.leaf(2)), this.leaf(3)), this.leaf(4))).toString());
        Assert.assertEquals((String)"(or leaf-1 leaf-2 leaf-3 leaf-4 leaf-5 leaf-6)", (String)SearchArgumentImpl.ExpressionBuilder.flatten((SearchArgumentImpl.ExpressionTree)this.or(this.or(this.leaf(1), this.or(this.leaf(2), this.leaf(3))), this.or(this.or(this.leaf(4), this.leaf(5)), this.leaf(6)))).toString());
        Assert.assertEquals((String)"(and (not leaf-1) leaf-2 (not leaf-3) leaf-4 (not leaf-5) leaf-6)", (String)SearchArgumentImpl.ExpressionBuilder.flatten((SearchArgumentImpl.ExpressionTree)this.and(this.and(this.not(this.leaf(1)), this.and(this.leaf(2), this.not(this.leaf(3)))), this.and(this.and(this.leaf(4), this.not(this.leaf(5))), this.leaf(6)))).toString());
        Assert.assertEquals((String)"(not (and leaf-1 leaf-2 leaf-3))", (String)SearchArgumentImpl.ExpressionBuilder.flatten((SearchArgumentImpl.ExpressionTree)this.not(this.and(this.leaf(1), this.and(this.leaf(2), this.leaf(3))))).toString());
    }

    @Test
    public void testFoldMaybe() throws Exception {
        Assert.assertEquals((String)"(and leaf-1)", (String)SearchArgumentImpl.ExpressionBuilder.foldMaybe((SearchArgumentImpl.ExpressionTree)this.and(this.leaf(1), this.constant(SearchArgument.TruthValue.YES_NO_NULL))).toString());
        Assert.assertEquals((String)"(and leaf-1 leaf-2)", (String)SearchArgumentImpl.ExpressionBuilder.foldMaybe((SearchArgumentImpl.ExpressionTree)this.and(this.leaf(1), this.constant(SearchArgument.TruthValue.YES_NO_NULL), this.leaf(2))).toString());
        Assert.assertEquals((String)"(and leaf-1 leaf-2)", (String)SearchArgumentImpl.ExpressionBuilder.foldMaybe((SearchArgumentImpl.ExpressionTree)this.and(this.constant(SearchArgument.TruthValue.YES_NO_NULL), this.leaf(1), this.leaf(2), this.constant(SearchArgument.TruthValue.YES_NO_NULL))).toString());
        Assert.assertEquals((String)"YES_NO_NULL", (String)SearchArgumentImpl.ExpressionBuilder.foldMaybe((SearchArgumentImpl.ExpressionTree)this.and(this.constant(SearchArgument.TruthValue.YES_NO_NULL), this.constant(SearchArgument.TruthValue.YES_NO_NULL))).toString());
        Assert.assertEquals((String)"YES_NO_NULL", (String)SearchArgumentImpl.ExpressionBuilder.foldMaybe((SearchArgumentImpl.ExpressionTree)this.or(this.leaf(1), this.constant(SearchArgument.TruthValue.YES_NO_NULL))).toString());
        Assert.assertEquals((String)"(or leaf-1 (and leaf-2))", (String)SearchArgumentImpl.ExpressionBuilder.foldMaybe((SearchArgumentImpl.ExpressionTree)this.or(this.leaf(1), this.and(this.leaf(2), this.constant(SearchArgument.TruthValue.YES_NO_NULL)))).toString());
        Assert.assertEquals((String)"(and leaf-1)", (String)SearchArgumentImpl.ExpressionBuilder.foldMaybe((SearchArgumentImpl.ExpressionTree)this.and(this.or(this.leaf(2), this.constant(SearchArgument.TruthValue.YES_NO_NULL)), this.leaf(1))).toString());
    }

    @Test
    public void testCNF() throws Exception {
        Assert.assertEquals((String)"leaf-1", (String)SearchArgumentImpl.ExpressionBuilder.convertToCNF((SearchArgumentImpl.ExpressionTree)this.leaf(1)).toString());
        Assert.assertEquals((String)"NO", (String)SearchArgumentImpl.ExpressionBuilder.convertToCNF((SearchArgumentImpl.ExpressionTree)this.constant(SearchArgument.TruthValue.NO)).toString());
        Assert.assertEquals((String)"(not leaf-1)", (String)SearchArgumentImpl.ExpressionBuilder.convertToCNF((SearchArgumentImpl.ExpressionTree)this.not(this.leaf(1))).toString());
        Assert.assertEquals((String)"(and leaf-1 leaf-2)", (String)SearchArgumentImpl.ExpressionBuilder.convertToCNF((SearchArgumentImpl.ExpressionTree)this.and(this.leaf(1), this.leaf(2))).toString());
        Assert.assertEquals((String)"(or (not leaf-1) leaf-2)", (String)SearchArgumentImpl.ExpressionBuilder.convertToCNF((SearchArgumentImpl.ExpressionTree)this.or(this.not(this.leaf(1)), this.leaf(2))).toString());
        Assert.assertEquals((String)"(and (or leaf-1 leaf-2) (not leaf-3))", (String)SearchArgumentImpl.ExpressionBuilder.convertToCNF((SearchArgumentImpl.ExpressionTree)this.and(this.or(this.leaf(1), this.leaf(2)), this.not(this.leaf(3)))).toString());
        Assert.assertEquals((String)"(and (or leaf-1 leaf-3) (or leaf-2 leaf-3) (or leaf-1 leaf-4) (or leaf-2 leaf-4))", (String)SearchArgumentImpl.ExpressionBuilder.convertToCNF((SearchArgumentImpl.ExpressionTree)this.or(this.and(this.leaf(1), this.leaf(2)), this.and(this.leaf(3), this.leaf(4)))).toString());
        Assert.assertEquals((String)"(and (or leaf-1 leaf-5) (or leaf-2 leaf-5) (or leaf-3 leaf-5) (or leaf-4 leaf-5) (or leaf-1 leaf-6) (or leaf-2 leaf-6) (or leaf-3 leaf-6) (or leaf-4 leaf-6))", (String)SearchArgumentImpl.ExpressionBuilder.convertToCNF((SearchArgumentImpl.ExpressionTree)this.or(this.and(this.leaf(1), this.leaf(2), this.leaf(3), this.leaf(4)), this.and(this.leaf(5), this.leaf(6)))).toString());
        Assert.assertEquals((String)"(and (or leaf-5 leaf-6 (not leaf-7) leaf-1 leaf-3) (or leaf-5 leaf-6 (not leaf-7) leaf-2 leaf-3) (or leaf-5 leaf-6 (not leaf-7) leaf-1 leaf-4) (or leaf-5 leaf-6 (not leaf-7) leaf-2 leaf-4))", (String)SearchArgumentImpl.ExpressionBuilder.convertToCNF((SearchArgumentImpl.ExpressionTree)this.or(this.and(this.leaf(1), this.leaf(2)), this.and(this.leaf(3), this.leaf(4)), this.or(this.leaf(5), this.leaf(6)), this.not(this.leaf(7)))).toString());
        Assert.assertEquals((String)"(and (or leaf-8 leaf-0 leaf-3 leaf-6) (or leaf-8 leaf-1 leaf-3 leaf-6) (or leaf-8 leaf-2 leaf-3 leaf-6) (or leaf-8 leaf-0 leaf-4 leaf-6) (or leaf-8 leaf-1 leaf-4 leaf-6) (or leaf-8 leaf-2 leaf-4 leaf-6) (or leaf-8 leaf-0 leaf-5 leaf-6) (or leaf-8 leaf-1 leaf-5 leaf-6) (or leaf-8 leaf-2 leaf-5 leaf-6) (or leaf-8 leaf-0 leaf-3 leaf-7) (or leaf-8 leaf-1 leaf-3 leaf-7) (or leaf-8 leaf-2 leaf-3 leaf-7) (or leaf-8 leaf-0 leaf-4 leaf-7) (or leaf-8 leaf-1 leaf-4 leaf-7) (or leaf-8 leaf-2 leaf-4 leaf-7) (or leaf-8 leaf-0 leaf-5 leaf-7) (or leaf-8 leaf-1 leaf-5 leaf-7) (or leaf-8 leaf-2 leaf-5 leaf-7))", (String)SearchArgumentImpl.ExpressionBuilder.convertToCNF((SearchArgumentImpl.ExpressionTree)this.or(this.and(this.leaf(0), this.leaf(1), this.leaf(2)), this.and(this.leaf(3), this.leaf(4), this.leaf(5)), this.and(this.leaf(6), this.leaf(7)), this.leaf(8))).toString());
        TestSearchArgumentImpl.assertNoSharedNodes(SearchArgumentImpl.ExpressionBuilder.convertToCNF((SearchArgumentImpl.ExpressionTree)this.or(this.and(this.leaf(0), this.leaf(1), this.leaf(2)), this.and(this.leaf(3), this.leaf(4), this.leaf(5)), this.and(this.leaf(6), this.leaf(7)), this.leaf(8))), Sets.newIdentityHashSet());
    }

    private static void assertNoSharedNodes(SearchArgumentImpl.ExpressionTree tree, Set<SearchArgumentImpl.ExpressionTree> seen) throws Exception {
        if (seen.contains(tree) && tree.getOperator() != SearchArgumentImpl.ExpressionTree.Operator.LEAF) {
            Assert.assertTrue((String)("repeated node in expression " + tree), (boolean)false);
        }
        seen.add(tree);
        if (tree.getChildren() != null) {
            for (SearchArgumentImpl.ExpressionTree child : tree.getChildren()) {
                TestSearchArgumentImpl.assertNoSharedNodes(child, seen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExprNodeGenericFuncDesc getFuncDesc(String xmlSerialized) {
        byte[] bytes;
        try {
            bytes = xmlSerialized.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 support required", ex);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        XMLDecoder decoder = new XMLDecoder(bais, null, null);
        try {
            ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = (ExprNodeGenericFuncDesc)decoder.readObject();
            return exprNodeGenericFuncDesc;
        }
        finally {
            decoder.close();
        }
    }

    @Test
    public void testExpression1() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                      <void property=\"children\"> \n                       <object class=\"java.util.ArrayList\"> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                          <void property=\"children\"> \n                           <object class=\"java.util.ArrayList\"> \n                            <void method=\"add\"> \n                             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                              <void property=\"children\"> \n                               <object class=\"java.util.ArrayList\"> \n                                <void method=\"add\"> \n                                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                                  <void property=\"column\"> \n                                   <string>first_name</string> \n                                  </void> \n                                  <void property=\"tabAlias\"> \n                                   <string>orc_people</string> \n                                  </void> \n                                  <void property=\"typeInfo\"> \n                                   <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                                    <void property=\"typeName\"> \n                                     <string>string</string> \n                                    </void> \n                                   </object> \n                                  </void> \n                                 </object> \n                                </void> \n                                <void method=\"add\"> \n                                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                                  <void property=\"typeInfo\"> \n                                   <object idref=\"PrimitiveTypeInfo0\"/> \n                                  </void> \n                                  <void property=\"value\"> \n                                   <string>john</string> \n                                  </void> \n                                 </object> \n                                </void> \n                               </object> \n                              </void> \n                              <void property=\"genericUDF\"> \n                               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n                              </void> \n                              <void property=\"typeInfo\"> \n                               <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                                <void property=\"typeName\"> \n                                 <string>boolean</string> \n                                </void> \n                               </object> \n                              </void> \n                             </object> \n                            </void> \n                            <void method=\"add\"> \n                             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                              <void property=\"children\"> \n                               <object class=\"java.util.ArrayList\"> \n                                <void method=\"add\"> \n                                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                                  <void property=\"typeInfo\"> \n                                   <object idref=\"PrimitiveTypeInfo0\"/> \n                                  </void> \n                                  <void property=\"value\"> \n                                   <string>greg</string> \n                                  </void> \n                                 </object> \n                                </void> \n                                <void method=\"add\"> \n                                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                                  <void property=\"column\"> \n                                   <string>first_name</string> \n                                  </void> \n                                  <void property=\"tabAlias\"> \n                                   <string>orc_people</string> \n                                  </void> \n                                  <void property=\"typeInfo\"> \n                                   <object idref=\"PrimitiveTypeInfo0\"/> \n                                  </void> \n                                 </object> \n                                </void> \n                               </object> \n                              </void> \n                              <void property=\"genericUDF\"> \n                               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                              </void> \n                              <void property=\"typeInfo\"> \n                               <object idref=\"PrimitiveTypeInfo1\"/> \n                              </void> \n                             </object> \n                            </void> \n                           </object> \n                          </void> \n                          <void property=\"genericUDF\"> \n                           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo1\"/> \n                          </void> \n                         </object> \n                        </void> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                          <void property=\"children\"> \n                           <object class=\"java.util.ArrayList\"> \n                            <void method=\"add\"> \n                             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                              <void property=\"typeInfo\"> \n                               <object idref=\"PrimitiveTypeInfo0\"/> \n                              </void> \n                              <void property=\"value\"> \n                               <string>alan</string> \n                              </void> \n                             </object> \n                            </void> \n                            <void method=\"add\"> \n                             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                              <void property=\"column\"> \n                               <string>first_name</string> \n                              </void> \n                              <void property=\"tabAlias\"> \n                               <string>orc_people</string> \n                              </void> \n                              <void property=\"typeInfo\"> \n                               <object idref=\"PrimitiveTypeInfo0\"/> \n                              </void> \n                             </object> \n                            </void> \n                           </object> \n                          </void> \n                          <void property=\"genericUDF\"> \n                           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan\"/> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo1\"/> \n                          </void> \n                         </object> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"genericUDF\"> \n                       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                      <void property=\"children\"> \n                       <object class=\"java.util.ArrayList\"> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                          <void property=\"column\"> \n                           <string>id</string> \n                          </void> \n                          <void property=\"tabAlias\"> \n                           <string>orc_people</string> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object id=\"PrimitiveTypeInfo2\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                            <void property=\"typeName\"> \n                             <string>int</string> \n                            </void> \n                           </object> \n                          </void> \n                         </object> \n                        </void> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo2\"/> \n                          </void> \n                          <void property=\"value\"> \n                           <int>12</int> \n                          </void> \n                         </object> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"genericUDF\"> \n                       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan\"/> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo1\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo2\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <int>13</int> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                      <void property=\"column\"> \n                       <string>id</string> \n                      </void> \n                      <void property=\"tabAlias\"> \n                       <string>orc_people</string> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo2\"/> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo1\"/> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>id</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo2\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo2\"/> \n                  </void> \n                  <void property=\"value\"> \n                   <int>15</int> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n              <void property=\"value\"> \n               <int>16</int> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>id</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>id</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n              <void property=\"value\"> \n               <int>30</int> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>first_name</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <string>owen</string> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo1\"/> \n  </void> \n </object> \n</java> \n";
        SearchArgumentImpl sarg = (SearchArgumentImpl)SearchArgument.FACTORY.create(this.getFuncDesc(exprStr));
        List leaves = sarg.getLeaves();
        Assert.assertEquals((int)9, (int)leaves.size());
        PredicateLeaf leaf = (PredicateLeaf)leaves.get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"first_name", (String)leaf.getColumnName());
        Assert.assertEquals((Object)"john", (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(1);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN_EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"first_name", (String)leaf.getColumnName());
        Assert.assertEquals((Object)"greg", (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(2);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"first_name", (String)leaf.getColumnName());
        Assert.assertEquals((Object)"alan", (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(3);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN_EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)12L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(4);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN_EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)13L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(5);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)15L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(6);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)16L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(7);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.NULL_SAFE_EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)30L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(8);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.NULL_SAFE_EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"first_name", (String)leaf.getColumnName());
        Assert.assertEquals((Object)"owen", (Object)leaf.getLiteral());
        Assert.assertEquals((String)"(and (or leaf-0 (not leaf-1) leaf-2 (not leaf-3) (not leaf-4) leaf-5 leaf-6 leaf-7) (or leaf-0 (not leaf-1) leaf-2 (not leaf-3) (not leaf-4) leaf-5 leaf-6 leaf-8))", (String)sarg.getExpression().toString());
        TestSearchArgumentImpl.assertNoSharedNodes(sarg.getExpression(), Sets.newIdentityHashSet());
    }

    @Test
    public void testExpression2() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>first_name</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                    <void property=\"typeName\"> \n                     <string>string</string> \n                    </void> \n                   </object> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                <void property=\"typeName\"> \n                 <string>boolean</string> \n                </void> \n               </object> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>first_name</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                  <void property=\"value\"> \n                   <string>sue</string> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>id</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object id=\"PrimitiveTypeInfo2\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                <void property=\"typeName\"> \n                 <string>int</string> \n                </void> \n               </object> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n              <void property=\"value\"> \n               <int>12</int> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n          <void property=\"column\"> \n           <string>id</string> \n          </void> \n          <void property=\"tabAlias\"> \n           <string>orc_people</string> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo2\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo2\"/> \n          </void> \n          <void property=\"value\"> \n           <int>4</int> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo1\"/> \n  </void> \n </object> \n</java> \n";
        SearchArgumentImpl sarg = (SearchArgumentImpl)SearchArgument.FACTORY.create(this.getFuncDesc(exprStr));
        List leaves = sarg.getLeaves();
        Assert.assertEquals((int)4, (int)leaves.size());
        PredicateLeaf leaf = (PredicateLeaf)leaves.get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.IS_NULL, (Object)leaf.getOperator());
        Assert.assertEquals((String)"first_name", (String)leaf.getColumnName());
        Assert.assertEquals(null, (Object)leaf.getLiteral());
        Assert.assertEquals(null, (Object)leaf.getLiteralList());
        leaf = (PredicateLeaf)leaves.get(1);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"first_name", (String)leaf.getColumnName());
        Assert.assertEquals((Object)"sue", (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(2);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)12L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(3);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN_EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)4L, (Object)leaf.getLiteral());
        Assert.assertEquals((String)"(or leaf-0 (not leaf-1) (not leaf-2) leaf-3)", (String)sarg.getExpression().toString());
        TestSearchArgumentImpl.assertNoSharedNodes(sarg.getExpression(), Sets.newIdentityHashSet());
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NULL, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.NULL, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NULL, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES_NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES_NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES_NULL, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO_NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.YES_NULL, SearchArgument.TruthValue.YES_NO_NULL, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NO_NULL, SearchArgument.TruthValue.YES_NO_NULL, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
    }

    @Test
    public void testExpression3() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                        <void property=\"typeName\"> \n                         <string>boolean</string> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"value\"> \n                       <boolean>false</boolean> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                      <void property=\"column\"> \n                       <string>id</string> \n                      </void> \n                      <void property=\"tabAlias\"> \n                       <string>orc_people</string> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                        <void property=\"typeName\"> \n                         <string>int</string> \n                        </void> \n                       </object> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <int>23</int> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <int>45</int> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                      <void property=\"column\"> \n                       <string>first_name</string> \n                      </void> \n                      <void property=\"tabAlias\"> \n                       <string>orc_people</string> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object id=\"PrimitiveTypeInfo2\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                        <void property=\"typeName\"> \n                         <string>string</string> \n                        </void> \n                       </object> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo2\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <string>alan</string> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo2\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <string>xxxxx</string> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <int>3</int> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge\"> \n                    <void property=\"udfClassName\"> \n                     <string>org.apache.hadoop.hive.ql.udf.UDFSubstr</string> \n                    </void> \n                    <void property=\"udfName\"> \n                     <string>substr</string> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo2\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>first_name</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo2\"/> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n              <void property=\"value\"> \n               <string>smith</string> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>last_name</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo0\"/> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>first_name</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n              <void property=\"value\"> \n               <int>3</int> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge\"> \n            <void property=\"udfClassName\"> \n             <string>org.apache.hadoop.hive.ql.udf.UDFSubstr</string> \n            </void> \n            <void property=\"udfName\"> \n             <string>substr</string> \n            </void> \n           </object> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo2\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo2\"/> \n          </void> \n          <void property=\"value\"> \n           <string>yyy</string> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo0\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo0\"/> \n  </void> \n </object> \n</java> \n";
        SearchArgumentImpl sarg = (SearchArgumentImpl)SearchArgument.FACTORY.create(this.getFuncDesc(exprStr));
        List leaves = sarg.getLeaves();
        Assert.assertEquals((int)3, (int)leaves.size());
        PredicateLeaf leaf = (PredicateLeaf)leaves.get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.BETWEEN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals(null, (Object)leaf.getLiteral());
        Assert.assertEquals((Object)23L, leaf.getLiteralList().get(0));
        Assert.assertEquals((Object)45L, leaf.getLiteralList().get(1));
        leaf = (PredicateLeaf)leaves.get(1);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"first_name", (String)leaf.getColumnName());
        Assert.assertEquals((Object)"alan", (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(2);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"last_name", (String)leaf.getColumnName());
        Assert.assertEquals((Object)"smith", (Object)leaf.getLiteral());
        Assert.assertEquals((String)"(and leaf-0 leaf-1 leaf-2)", (String)sarg.getExpression().toString());
        TestSearchArgumentImpl.assertNoSharedNodes(sarg.getExpression(), Sets.newIdentityHashSet());
    }

    @Test
    public void testExpression4() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>id</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                <void property=\"typeName\"> \n                 <string>int</string> \n                </void> \n               </object> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <int>12</int> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n            <void property=\"typeName\"> \n             <string>boolean</string> \n            </void> \n           </object> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>first_name</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object id=\"PrimitiveTypeInfo2\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                <void property=\"typeName\"> \n                 <string>string</string> \n                </void> \n               </object> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n              <void property=\"value\"> \n               <string>john</string> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n              <void property=\"value\"> \n               <string>sue</string> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n          <void property=\"column\"> \n           <string>id</string> \n          </void> \n          <void property=\"tabAlias\"> \n           <string>orc_people</string> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <int>34</int> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <int>50</int> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo1\"/> \n  </void> \n </object> \n</java> \n\n";
        SearchArgumentImpl sarg = (SearchArgumentImpl)SearchArgument.FACTORY.create(this.getFuncDesc(exprStr));
        List leaves = sarg.getLeaves();
        Assert.assertEquals((int)3, (int)leaves.size());
        PredicateLeaf leaf = (PredicateLeaf)leaves.get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)12L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(1);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.IN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"first_name", (String)leaf.getColumnName());
        Assert.assertEquals((Object)"john", leaf.getLiteralList().get(0));
        Assert.assertEquals((Object)"sue", leaf.getLiteralList().get(1));
        leaf = (PredicateLeaf)leaves.get(2);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.IN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)34L, leaf.getLiteralList().get(0));
        Assert.assertEquals((Object)50L, leaf.getLiteralList().get(1));
        Assert.assertEquals((String)"(and (not leaf-0) leaf-1 leaf-2)", (String)sarg.getExpression().toString());
        TestSearchArgumentImpl.assertNoSharedNodes(sarg.getExpression(), Sets.newIdentityHashSet());
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NULL, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.NULL, SearchArgument.TruthValue.YES)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES_NULL, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.NULL, SearchArgument.TruthValue.YES_NO_NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO_NULL)));
    }

    @Test
    public void testExpression5() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>first_name</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                <void property=\"typeName\"> \n                 <string>string</string> \n                </void> \n               </object> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <string>owen</string> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n            <void property=\"typeName\"> \n             <string>boolean</string> \n            </void> \n           </object> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <string>foobar</string> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>last_name</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                  <void property=\"typeInfo\"> \n                   <object class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                    <void property=\"typeName\"> \n                     <string>int</string> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"value\"> \n                   <int>4</int> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge\"> \n                <void property=\"udfClassName\"> \n                 <string>org.apache.hadoop.hive.ql.udf.UDFSubstr</string> \n                </void> \n                <void property=\"udfName\"> \n                 <string>substr</string> \n                </void> \n               </object> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n          <void property=\"value\"> \n           <boolean>false</boolean> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n          <void property=\"column\"> \n           <string>first_name</string> \n          </void> \n          <void property=\"tabAlias\"> \n           <string>orc_people</string> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <string>david</string> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <string>greg</string> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo1\"/> \n  </void> \n </object> \n</java> \n";
        SearchArgumentImpl sarg = (SearchArgumentImpl)SearchArgument.FACTORY.create(this.getFuncDesc(exprStr));
        List leaves = sarg.getLeaves();
        Assert.assertEquals((int)1, (int)leaves.size());
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)((PredicateLeaf)leaves.get(0)).getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.BETWEEN, (Object)((PredicateLeaf)leaves.get(0)).getOperator());
        Assert.assertEquals((String)"first_name", (String)((PredicateLeaf)leaves.get(0)).getColumnName());
        Assert.assertEquals((Object)"david", ((PredicateLeaf)leaves.get(0)).getLiteralList().get(0));
        Assert.assertEquals((Object)"greg", ((PredicateLeaf)leaves.get(0)).getLiteralList().get(1));
        Assert.assertEquals((String)"leaf-0", (String)sarg.getExpression().toString());
        TestSearchArgumentImpl.assertNoSharedNodes(sarg.getExpression(), Sets.newIdentityHashSet());
    }

    @Test
    public void testExpression7() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                      <void property=\"children\"> \n                       <object class=\"java.util.ArrayList\"> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                          <void property=\"column\"> \n                           <string>id</string> \n                          </void> \n                          <void property=\"tabAlias\"> \n                           <string>orc_people</string> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                            <void property=\"typeName\"> \n                             <string>int</string> \n                            </void> \n                           </object> \n                          </void> \n                         </object> \n                        </void> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                          <void property=\"value\"> \n                           <int>10</int> \n                          </void> \n                         </object> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"genericUDF\"> \n                       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                        <void property=\"typeName\"> \n                         <string>boolean</string> \n                        </void> \n                       </object> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                      <void property=\"children\"> \n                       <object class=\"java.util.ArrayList\"> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                          <void property=\"column\"> \n                           <string>id</string> \n                          </void> \n                          <void property=\"tabAlias\"> \n                           <string>orc_people</string> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                         </object> \n                        </void> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                          <void property=\"value\"> \n                           <int>11</int> \n                          </void> \n                         </object> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"genericUDF\"> \n                       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo1\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                      <void property=\"column\"> \n                       <string>id</string> \n                      </void> \n                      <void property=\"tabAlias\"> \n                       <string>orc_people</string> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo0\"/> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo0\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <int>12</int> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo1\"/> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                      <void property=\"children\"> \n                       <object class=\"java.util.ArrayList\"> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                          <void property=\"column\"> \n                           <string>id</string> \n                          </void> \n                          <void property=\"tabAlias\"> \n                           <string>orc_people</string> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                         </object> \n                        </void> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                          <void property=\"value\"> \n                           <int>13</int> \n                          </void> \n                         </object> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"genericUDF\"> \n                       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                      <void property=\"children\"> \n                       <object class=\"java.util.ArrayList\"> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                          <void property=\"column\"> \n                           <string>id</string> \n                          </void> \n                          <void property=\"tabAlias\"> \n                           <string>orc_people</string> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                         </object> \n                        </void> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                          <void property=\"value\"> \n                           <int>14</int> \n                          </void> \n                         </object> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"genericUDF\"> \n                       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo1\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                      <void property=\"column\"> \n                       <string>id</string> \n                      </void> \n                      <void property=\"tabAlias\"> \n                       <string>orc_people</string> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo0\"/> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo0\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <int>15</int> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo1\"/> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>id</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                  <void property=\"value\"> \n                   <int>16</int> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>id</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                  <void property=\"value\"> \n                   <int>17</int> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n          <void property=\"column\"> \n           <string>id</string> \n          </void> \n          <void property=\"tabAlias\"> \n           <string>orc_people</string> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <int>18</int> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo1\"/> \n  </void> \n </object>\n</java>";
        SearchArgumentImpl sarg = (SearchArgumentImpl)SearchArgument.FACTORY.create(this.getFuncDesc(exprStr));
        List leaves = sarg.getLeaves();
        Assert.assertEquals((int)9, (int)leaves.size());
        PredicateLeaf leaf = (PredicateLeaf)leaves.get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)18L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(1);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)10L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(2);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)13L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(3);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)16L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(4);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)11L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(5);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)12L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(6);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)14L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(7);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)15L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(8);
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)17L, (Object)leaf.getLiteral());
        Assert.assertEquals((String)"(and (or leaf-0 leaf-1 leaf-2 leaf-3) (or leaf-0 leaf-4 leaf-2 leaf-3) (or leaf-0 leaf-5 leaf-2 leaf-3) (or leaf-0 leaf-1 leaf-6 leaf-3) (or leaf-0 leaf-4 leaf-6 leaf-3) (or leaf-0 leaf-5 leaf-6 leaf-3) (or leaf-0 leaf-1 leaf-7 leaf-3) (or leaf-0 leaf-4 leaf-7 leaf-3) (or leaf-0 leaf-5 leaf-7 leaf-3) (or leaf-0 leaf-1 leaf-2 leaf-8) (or leaf-0 leaf-4 leaf-2 leaf-8) (or leaf-0 leaf-5 leaf-2 leaf-8) (or leaf-0 leaf-1 leaf-6 leaf-8) (or leaf-0 leaf-4 leaf-6 leaf-8) (or leaf-0 leaf-5 leaf-6 leaf-8) (or leaf-0 leaf-1 leaf-7 leaf-8) (or leaf-0 leaf-4 leaf-7 leaf-8) (or leaf-0 leaf-5 leaf-7 leaf-8))", (String)sarg.getExpression().toString());
    }

    @Test
    public void testExpression8() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n      <void property=\"column\"> \n       <string>first_name</string> \n      </void> \n      <void property=\"tabAlias\"> \n       <string>orc_people</string> \n      </void> \n      <void property=\"typeInfo\"> \n       <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n        <void property=\"typeName\"> \n         <string>string</string> \n        </void> \n       </object> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n      <void property=\"column\"> \n       <string>last_name</string> \n      </void> \n      <void property=\"tabAlias\"> \n       <string>orc_people</string> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo0\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n    <void property=\"typeName\"> \n     <string>boolean</string> \n    </void> \n   </object> \n  </void> \n </object> \n</java> ";
        SearchArgumentImpl sarg = (SearchArgumentImpl)SearchArgument.FACTORY.create(this.getFuncDesc(exprStr));
        List leaves = sarg.getLeaves();
        Assert.assertEquals((int)0, (int)leaves.size());
        Assert.assertEquals((String)"YES_NO_NULL", (String)sarg.getExpression().toString());
    }

    @Test
    public void testExpression9() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n      <void property=\"column\"> \n       <string>id</string> \n      </void> \n      <void property=\"tabAlias\"> \n       <string>orc_people</string> \n      </void> \n      <void property=\"typeInfo\"> \n       <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n        <void property=\"typeName\"> \n         <string>int</string> \n        </void> \n       </object> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <int>1</int> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <int>3</int> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge\"> \n            <void property=\"operator\"> \n             <boolean>true</boolean> \n            </void> \n            <void property=\"udfClassName\"> \n             <string>org.apache.hadoop.hive.ql.udf.UDFOPPlus</string> \n            </void> \n            <void property=\"udfName\"> \n             <string>+</string> \n            </void> \n           </object> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <int>4</int> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge\"> \n        <void property=\"operator\"> \n         <boolean>true</boolean> \n        </void> \n        <void property=\"udfClassName\"> \n         <string>org.apache.hadoop.hive.ql.udf.UDFOPPlus</string> \n        </void> \n        <void property=\"udfName\"> \n         <string>+</string> \n        </void> \n       </object> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo0\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n    <void property=\"typeName\"> \n     <string>boolean</string> \n    </void> \n   </object> \n  </void> \n </object> \n</java> ";
        SearchArgumentImpl sarg = (SearchArgumentImpl)SearchArgument.FACTORY.create(this.getFuncDesc(exprStr));
        List leaves = sarg.getLeaves();
        Assert.assertEquals((int)0, (int)leaves.size());
        Assert.assertEquals((String)"YES_NO_NULL", (String)sarg.getExpression().toString());
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)sarg.evaluate(TestSearchArgumentImpl.values(new SearchArgument.TruthValue[0])));
    }

    @Test
    public void testExpression10() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n          <void property=\"column\"> \n           <string>id</string> \n          </void> \n          <void property=\"tabAlias\"> \n           <string>orc_people</string> \n          </void> \n          <void property=\"typeInfo\"> \n           <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n            <void property=\"typeName\"> \n             <string>int</string> \n            </void> \n           </object> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <int>10</int> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n        <void property=\"typeName\"> \n         <string>boolean</string> \n        </void> \n       </object> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>id</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <int>10</int> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo1\"/> \n  </void> \n </object> \n</java>";
        SearchArgumentImpl sarg = (SearchArgumentImpl)SearchArgument.FACTORY.create(this.getFuncDesc(exprStr));
        List leaves = sarg.getLeaves();
        Assert.assertEquals((int)1, (int)leaves.size());
        Assert.assertEquals((Object)PredicateLeaf.Type.INTEGER, (Object)((PredicateLeaf)leaves.get(0)).getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)((PredicateLeaf)leaves.get(0)).getOperator());
        Assert.assertEquals((String)"id", (String)((PredicateLeaf)leaves.get(0)).getColumnName());
        Assert.assertEquals((Object)10L, (Object)((PredicateLeaf)leaves.get(0)).getLiteral());
        Assert.assertEquals((String)"(and (not leaf-0) (not leaf-0))", (String)sarg.getExpression().toString());
        TestSearchArgumentImpl.assertNoSharedNodes(sarg.getExpression(), Sets.newIdentityHashSet());
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.YES)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.YES_NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.NO_NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.YES_NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)sarg.evaluate(TestSearchArgumentImpl.values(SearchArgument.TruthValue.YES_NO_NULL)));
    }

    private static SearchArgument.TruthValue[] values(SearchArgument.TruthValue ... vals) {
        return vals;
    }

    @Test
    public void testBuilder() throws Exception {
        SearchArgument sarg = SearchArgument.FACTORY.newBuilder().startAnd().lessThan("x", (Object)10).lessThanEquals("y", (Object)"hi").equals("z", (Object)1.0).end().build();
        Assert.assertEquals((String)"leaf-0 = (LESS_THAN x 10)\nleaf-1 = (LESS_THAN_EQUALS y hi)\nleaf-2 = (EQUALS z 1.0)\nexpr = (and leaf-0 leaf-1 leaf-2)", (String)sarg.toString());
        sarg = SearchArgument.FACTORY.newBuilder().startNot().startOr().isNull("x").between("y", (Object)10, (Object)20).in("z", new Object[]{1, 2, 3}).nullSafeEquals("a", (Object)"stinger").end().end().build();
        Assert.assertEquals((String)"leaf-0 = (IS_NULL x)\nleaf-1 = (BETWEEN y 10 20)\nleaf-2 = (IN z 1 2 3)\nleaf-3 = (NULL_SAFE_EQUALS a stinger)\nexpr = (and (not leaf-0) (not leaf-1) (not leaf-2) (not leaf-3))", (String)sarg.toString());
    }

    @Test
    public void testBuilderComplexTypes() throws Exception {
        SearchArgument sarg = SearchArgument.FACTORY.newBuilder().startAnd().lessThan("x", (Object)new DateWritable(10)).lessThanEquals("y", (Object)new HiveChar("hi", 10)).equals("z", (Object)HiveDecimal.create((String)"1.0")).end().build();
        Assert.assertEquals((String)"leaf-0 = (LESS_THAN x 1970-01-11)\nleaf-1 = (LESS_THAN_EQUALS y hi)\nleaf-2 = (EQUALS z 1)\nexpr = (and leaf-0 leaf-1 leaf-2)", (String)sarg.toString());
        sarg = SearchArgument.FACTORY.newBuilder().startNot().startOr().isNull("x").between("y", (Object)HiveDecimal.create((int)10), (Object)20.0).in("z", new Object[]{(byte)1, (short)2, 3}).nullSafeEquals("a", (Object)new HiveVarchar("stinger", 100)).end().end().build();
        Assert.assertEquals((String)"leaf-0 = (IS_NULL x)\nleaf-1 = (BETWEEN y 10 20.0)\nleaf-2 = (IN z 1 2 3)\nleaf-3 = (NULL_SAFE_EQUALS a stinger)\nexpr = (and (not leaf-0) (not leaf-1) (not leaf-2) (not leaf-3))", (String)sarg.toString());
    }
}

