/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.util.Properties;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.ql.io.parquet.writable.BinaryWritable;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import parquet.io.api.Binary;

public class TestParquetSerDe
extends TestCase {
    public void testParquetHiveSerDe() throws Throwable {
        try {
            System.out.println("test: testParquetHiveSerDe");
            ParquetHiveSerDe serDe = new ParquetHiveSerDe();
            Configuration conf = new Configuration();
            Properties tbl = this.createProperties();
            serDe.initialize(conf, tbl);
            Writable[] arr = new Writable[8];
            arr[0] = new ByteWritable(123);
            arr[1] = new ShortWritable(456);
            arr[2] = new IntWritable(789);
            arr[3] = new LongWritable(1000L);
            arr[4] = new DoubleWritable(5.3);
            arr[5] = new BinaryWritable(Binary.fromString((String)"hive and hadoop and parquet. Big family."));
            Writable[] mapContainer = new Writable[1];
            Writable[] map = new Writable[3];
            for (int i = 0; i < 3; ++i) {
                Writable[] pair = new Writable[]{new BinaryWritable(Binary.fromString((String)("key_" + i))), new IntWritable(i)};
                map[i] = new ArrayWritable(Writable.class, pair);
            }
            mapContainer[0] = new ArrayWritable(Writable.class, map);
            arr[6] = new ArrayWritable(Writable.class, mapContainer);
            Writable[] arrayContainer = new Writable[1];
            Writable[] array = new Writable[5];
            for (int i = 0; i < 5; ++i) {
                array[i] = new BinaryWritable(Binary.fromString((String)("elem_" + i)));
            }
            arrayContainer[0] = new ArrayWritable(Writable.class, array);
            arr[7] = new ArrayWritable(Writable.class, arrayContainer);
            ArrayWritable arrWritable = new ArrayWritable(Writable.class, arr);
            this.deserializeAndSerializeLazySimple(serDe, arrWritable);
            System.out.println("test: testParquetHiveSerDe - OK");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void deserializeAndSerializeLazySimple(ParquetHiveSerDe serDe, ArrayWritable t) throws SerDeException {
        StructObjectInspector oi = (StructObjectInspector)serDe.getObjectInspector();
        Object row = serDe.deserialize((Writable)t);
        TestParquetSerDe.assertEquals((String)"deserialization gives the wrong object class", row.getClass(), ArrayWritable.class);
        TestParquetSerDe.assertEquals((String)"size correct after deserialization", (long)serDe.getSerDeStats().getRawDataSize(), (long)t.get().length);
        TestParquetSerDe.assertEquals((String)"deserialization gives the wrong object", (Object)t, (Object)row);
        ArrayWritable serializedArr = (ArrayWritable)serDe.serialize(row, (ObjectInspector)oi);
        TestParquetSerDe.assertEquals((String)"size correct after serialization", (long)serDe.getSerDeStats().getRawDataSize(), (long)serializedArr.get().length);
        TestParquetSerDe.assertTrue((String)"serialized object should be equal to starting object", (boolean)TestParquetSerDe.arrayWritableEquals(t, serializedArr));
    }

    private Properties createProperties() {
        Properties tbl = new Properties();
        tbl.setProperty("columns", "abyte,ashort,aint,along,adouble,astring,amap,alist");
        tbl.setProperty("columns.types", "tinyint:smallint:int:bigint:double:string:map<string,int>:array<string>");
        tbl.setProperty("serialization.null.format", "NULL");
        return tbl;
    }

    public static boolean arrayWritableEquals(ArrayWritable a1, ArrayWritable a2) {
        Writable[] a2Arr;
        Writable[] a1Arr = a1.get();
        if (a1Arr.length != (a2Arr = a2.get()).length) {
            return false;
        }
        for (int i = 0; i < a1Arr.length; ++i) {
            if (a1Arr[i] instanceof ArrayWritable) {
                if (!(a2Arr[i] instanceof ArrayWritable)) {
                    return false;
                }
                if (TestParquetSerDe.arrayWritableEquals((ArrayWritable)a1Arr[i], (ArrayWritable)a2Arr[i])) continue;
                return false;
            }
            if (a1Arr[i].equals(a2Arr[i])) continue;
            return false;
        }
        return true;
    }
}

