/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.nio.ByteBuffer;
import junit.framework.Assert;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.InStream;
import org.apache.hadoop.hive.ql.io.orc.OutStream;
import org.apache.hadoop.hive.ql.io.orc.PositionProvider;
import org.apache.hadoop.hive.ql.io.orc.PositionRecorder;
import org.apache.hadoop.hive.ql.io.orc.PositionedOutputStream;
import org.apache.hadoop.hive.ql.io.orc.RunLengthByteReader;
import org.apache.hadoop.hive.ql.io.orc.RunLengthByteWriter;
import org.apache.hadoop.hive.ql.io.orc.SnappyCodec;
import org.apache.hadoop.hive.ql.io.orc.TestInStream;
import org.junit.Test;

public class TestRunLengthByteReader {
    @Test
    public void testUncompressedSeek() throws Exception {
        int x;
        int i;
        TestInStream.OutputCollector collect = new TestInStream.OutputCollector();
        RunLengthByteWriter out = new RunLengthByteWriter((PositionedOutputStream)new OutStream("test", 100, null, (OutStream.OutputReceiver)collect));
        TestInStream.PositionCollector[] positions = new TestInStream.PositionCollector[2048];
        for (int i2 = 0; i2 < 2048; ++i2) {
            positions[i2] = new TestInStream.PositionCollector();
            out.getPosition((PositionRecorder)positions[i2]);
            if (i2 < 1024) {
                out.write((byte)(i2 / 4));
                continue;
            }
            out.write((byte)i2);
        }
        out.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        RunLengthByteReader in = new RunLengthByteReader(InStream.create((String)"test", (ByteBuffer[])new ByteBuffer[]{inBuf}, (long[])new long[]{0L}, (long)inBuf.remaining(), null, (int)100));
        for (i = 0; i < 2048; ++i) {
            x = in.next() & 0xFF;
            if (i < 1024) {
                Assert.assertEquals((int)(i / 4 & 0xFF), (int)x);
                continue;
            }
            Assert.assertEquals((int)(i & 0xFF), (int)x);
        }
        for (i = 2047; i >= 0; --i) {
            in.seek((PositionProvider)positions[i]);
            x = in.next() & 0xFF;
            if (i < 1024) {
                Assert.assertEquals((int)(i / 4 & 0xFF), (int)x);
                continue;
            }
            Assert.assertEquals((int)(i & 0xFF), (int)x);
        }
    }

    @Test
    public void testCompressedSeek() throws Exception {
        int x;
        int i;
        SnappyCodec codec = new SnappyCodec();
        TestInStream.OutputCollector collect = new TestInStream.OutputCollector();
        RunLengthByteWriter out = new RunLengthByteWriter((PositionedOutputStream)new OutStream("test", 500, (CompressionCodec)codec, (OutStream.OutputReceiver)collect));
        TestInStream.PositionCollector[] positions = new TestInStream.PositionCollector[2048];
        for (int i2 = 0; i2 < 2048; ++i2) {
            positions[i2] = new TestInStream.PositionCollector();
            out.getPosition((PositionRecorder)positions[i2]);
            if (i2 < 1024) {
                out.write((byte)(i2 / 4));
                continue;
            }
            out.write((byte)i2);
        }
        out.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        RunLengthByteReader in = new RunLengthByteReader(InStream.create((String)"test", (ByteBuffer[])new ByteBuffer[]{inBuf}, (long[])new long[]{0L}, (long)inBuf.remaining(), (CompressionCodec)codec, (int)500));
        for (i = 0; i < 2048; ++i) {
            x = in.next() & 0xFF;
            if (i < 1024) {
                Assert.assertEquals((int)(i / 4 & 0xFF), (int)x);
                continue;
            }
            Assert.assertEquals((int)(i & 0xFF), (int)x);
        }
        for (i = 2047; i >= 0; --i) {
            in.seek((PositionProvider)positions[i]);
            x = in.next() & 0xFF;
            if (i < 1024) {
                Assert.assertEquals((int)(i / 4 & 0xFF), (int)x);
                continue;
            }
            Assert.assertEquals((int)(i & 0xFF), (int)x);
        }
    }

    @Test
    public void testSkips() throws Exception {
        TestInStream.OutputCollector collect = new TestInStream.OutputCollector();
        RunLengthByteWriter out = new RunLengthByteWriter((PositionedOutputStream)new OutStream("test", 100, null, (OutStream.OutputReceiver)collect));
        for (int i = 0; i < 2048; ++i) {
            if (i < 1024) {
                out.write((byte)(i / 16));
                continue;
            }
            out.write((byte)i);
        }
        out.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        RunLengthByteReader in = new RunLengthByteReader(InStream.create((String)"test", (ByteBuffer[])new ByteBuffer[]{inBuf}, (long[])new long[]{0L}, (long)inBuf.remaining(), null, (int)100));
        for (int i = 0; i < 2048; i += 10) {
            int x = in.next() & 0xFF;
            if (i < 1024) {
                Assert.assertEquals((int)(i / 16 & 0xFF), (int)x);
            } else {
                Assert.assertEquals((int)(i & 0xFF), (int)x);
            }
            if (i < 2038) {
                in.skip(9L);
            }
            in.skip(0L);
        }
    }
}

