/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.primitives.Longs;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Random;
import org.apache.hadoop.hive.ql.io.orc.InStream;
import org.apache.hadoop.hive.ql.io.orc.OutStream;
import org.apache.hadoop.hive.ql.io.orc.SerializationUtils;
import org.apache.hadoop.hive.ql.io.orc.TestInStream;
import org.junit.Assert;
import org.junit.Test;

public class TestBitPack {
    private static final int SIZE = 100;
    private static Random rand = new Random(100L);

    private long[] deltaEncode(long[] inp) {
        long[] output = new long[inp.length];
        for (int i = 0; i < inp.length; ++i) {
            output[i] = SerializationUtils.zigzagEncode((long)inp[i]);
        }
        return output;
    }

    private long nextLong(Random rng, long n) {
        long val;
        long bits;
        while ((bits = rng.nextLong() << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    private void runTest(int numBits) throws IOException {
        long[] inp = new long[100];
        for (int i = 0; i < 100; ++i) {
            long val = 0L;
            val = numBits <= 32 ? (numBits == 1 ? (long)(-1 * rand.nextInt(2)) : (long)rand.nextInt((int)Math.pow(2.0, numBits - 1))) : this.nextLong(rand, (long)Math.pow(2.0, numBits - 2));
            if (val % 2L == 0L) {
                val = -val;
            }
            inp[i] = val;
        }
        long[] deltaEncoded = this.deltaEncode(inp);
        long minInput = (Long)Collections.min(Longs.asList((long[])deltaEncoded));
        long maxInput = (Long)Collections.max(Longs.asList((long[])deltaEncoded));
        long rangeInput = maxInput - minInput;
        int fixedWidth = SerializationUtils.findClosestNumBits((long)rangeInput);
        TestInStream.OutputCollector collect = new TestInStream.OutputCollector();
        OutStream output = new OutStream("test", 100, null, (OutStream.OutputReceiver)collect);
        SerializationUtils.writeInts((long[])deltaEncoded, (int)0, (int)deltaEncoded.length, (int)fixedWidth, (OutputStream)output);
        output.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        long[] buff = new long[100];
        SerializationUtils.readInts((long[])buff, (int)0, (int)100, (int)fixedWidth, (InStream)InStream.create((String)"test", (ByteBuffer[])new ByteBuffer[]{inBuf}, (long[])new long[]{0L}, (long)inBuf.remaining(), null, (int)100));
        for (int i = 0; i < 100; ++i) {
            buff[i] = SerializationUtils.zigzagDecode((long)buff[i]);
        }
        Assert.assertEquals((long)numBits, (long)fixedWidth);
        Assert.assertArrayEquals((long[])inp, (long[])buff);
    }

    @Test
    public void test01BitPacking1Bit() throws IOException {
        this.runTest(1);
    }

    @Test
    public void test02BitPacking2Bit() throws IOException {
        this.runTest(2);
    }

    @Test
    public void test03BitPacking3Bit() throws IOException {
        this.runTest(3);
    }

    @Test
    public void test04BitPacking4Bit() throws IOException {
        this.runTest(4);
    }

    @Test
    public void test05BitPacking5Bit() throws IOException {
        this.runTest(5);
    }

    @Test
    public void test06BitPacking6Bit() throws IOException {
        this.runTest(6);
    }

    @Test
    public void test07BitPacking7Bit() throws IOException {
        this.runTest(7);
    }

    @Test
    public void test08BitPacking8Bit() throws IOException {
        this.runTest(8);
    }

    @Test
    public void test09BitPacking9Bit() throws IOException {
        this.runTest(9);
    }

    @Test
    public void test10BitPacking10Bit() throws IOException {
        this.runTest(10);
    }

    @Test
    public void test11BitPacking11Bit() throws IOException {
        this.runTest(11);
    }

    @Test
    public void test12BitPacking12Bit() throws IOException {
        this.runTest(12);
    }

    @Test
    public void test13BitPacking13Bit() throws IOException {
        this.runTest(13);
    }

    @Test
    public void test14BitPacking14Bit() throws IOException {
        this.runTest(14);
    }

    @Test
    public void test15BitPacking15Bit() throws IOException {
        this.runTest(15);
    }

    @Test
    public void test16BitPacking16Bit() throws IOException {
        this.runTest(16);
    }

    @Test
    public void test17BitPacking17Bit() throws IOException {
        this.runTest(17);
    }

    @Test
    public void test18BitPacking18Bit() throws IOException {
        this.runTest(18);
    }

    @Test
    public void test19BitPacking19Bit() throws IOException {
        this.runTest(19);
    }

    @Test
    public void test20BitPacking20Bit() throws IOException {
        this.runTest(20);
    }

    @Test
    public void test21BitPacking21Bit() throws IOException {
        this.runTest(21);
    }

    @Test
    public void test22BitPacking22Bit() throws IOException {
        this.runTest(22);
    }

    @Test
    public void test23BitPacking23Bit() throws IOException {
        this.runTest(23);
    }

    @Test
    public void test24BitPacking24Bit() throws IOException {
        this.runTest(24);
    }

    @Test
    public void test26BitPacking26Bit() throws IOException {
        this.runTest(26);
    }

    @Test
    public void test28BitPacking28Bit() throws IOException {
        this.runTest(28);
    }

    @Test
    public void test30BitPacking30Bit() throws IOException {
        this.runTest(30);
    }

    @Test
    public void test32BitPacking32Bit() throws IOException {
        this.runTest(32);
    }

    @Test
    public void test40BitPacking40Bit() throws IOException {
        this.runTest(40);
    }

    @Test
    public void test48BitPacking48Bit() throws IOException {
        this.runTest(48);
    }

    @Test
    public void test56BitPacking56Bit() throws IOException {
        this.runTest(56);
    }

    @Test
    public void test64BitPacking64Bit() throws IOException {
        this.runTest(64);
    }
}

