/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.util.FakeVectorRowBatchBase;

public class FakeVectorRowBatchFromLongIterables
extends FakeVectorRowBatchBase {
    private VectorizedRowBatch batch;
    private final int numCols;
    private final int batchSize;
    private List<Iterator<Long>> iterators;
    private boolean eof;

    public FakeVectorRowBatchFromLongIterables(int batchSize, Iterable<Long> ... iterables) {
        this.numCols = iterables.length;
        this.batchSize = batchSize;
        this.iterators = new ArrayList<Iterator<Long>>();
        this.batch = new VectorizedRowBatch(this.numCols, batchSize);
        for (int i = 0; i < this.numCols; ++i) {
            this.batch.cols[i] = new LongColumnVector(batchSize);
            this.iterators.add(iterables[i].iterator());
        }
    }

    @Override
    public VectorizedRowBatch produceNextBatch() {
        this.batch.size = 0;
        this.batch.selectedInUse = false;
        for (int i = 0; i < this.numCols; ++i) {
            ColumnVector col = this.batch.cols[i];
            col.noNulls = true;
            col.isRepeating = false;
        }
        while (!this.eof && this.batch.size < this.batchSize) {
            int r = this.batch.size;
            for (int i = 0; i < this.numCols; ++i) {
                Iterator<Long> it = this.iterators.get(i);
                if (!it.hasNext()) {
                    this.eof = true;
                    break;
                }
                LongColumnVector col = (LongColumnVector)this.batch.cols[i];
                Long value = it.next();
                if (null == value) {
                    col.noNulls = false;
                    col.isNull[this.batch.size] = true;
                    continue;
                }
                long[] vector = col.vector;
                vector[r] = value;
                col.isNull[this.batch.size] = false;
            }
            if (this.eof) continue;
            ++this.batch.size;
        }
        return this.batch;
    }
}

