/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprStringColumnStringColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprStringColumnStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprStringScalarStringColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprStringScalarStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.IfExprDoubleColumnDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.IfExprDoubleColumnDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.IfExprDoubleScalarDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.IfExprDoubleScalarDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.IfExprLongColumnLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.IfExprLongColumnLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.IfExprLongScalarLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.IfExprLongScalarLongScalar;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorConditionalExpressions {
    private VectorizedRowBatch getBatch4LongVectors() {
        VectorizedRowBatch batch = new VectorizedRowBatch(4);
        LongColumnVector v = new LongColumnVector();
        v.vector[0] = 0L;
        v.vector[1] = 0L;
        v.vector[2] = 1L;
        v.vector[3] = 1L;
        batch.cols[0] = v;
        v = new LongColumnVector();
        v.vector[0] = -1L;
        v.vector[1] = -2L;
        v.vector[2] = -3L;
        v.vector[3] = -4L;
        batch.cols[1] = v;
        v = new LongColumnVector();
        v.vector[0] = 1L;
        v.vector[1] = 2L;
        v.vector[2] = 3L;
        v.vector[3] = 4L;
        batch.cols[2] = v;
        batch.cols[3] = new LongColumnVector();
        batch.size = 4;
        return batch;
    }

    private VectorizedRowBatch getBatch1Long3DoubleVectors() {
        VectorizedRowBatch batch = new VectorizedRowBatch(4);
        LongColumnVector lv = new LongColumnVector();
        lv.vector[0] = 0L;
        lv.vector[1] = 0L;
        lv.vector[2] = 1L;
        lv.vector[3] = 1L;
        batch.cols[0] = lv;
        DoubleColumnVector v = new DoubleColumnVector();
        v.vector[0] = -1.0;
        v.vector[1] = -2.0;
        v.vector[2] = -3.0;
        v.vector[3] = -4.0;
        batch.cols[1] = v;
        v = new DoubleColumnVector();
        v.vector[0] = 1.0;
        v.vector[1] = 2.0;
        v.vector[2] = 3.0;
        v.vector[3] = 4.0;
        batch.cols[2] = v;
        batch.cols[3] = new DoubleColumnVector();
        batch.size = 4;
        return batch;
    }

    private VectorizedRowBatch getBatch1Long3BytesVectors() {
        VectorizedRowBatch batch = new VectorizedRowBatch(4);
        LongColumnVector lv = new LongColumnVector();
        lv.vector[0] = 0L;
        lv.vector[1] = 0L;
        lv.vector[2] = 1L;
        lv.vector[3] = 1L;
        batch.cols[0] = lv;
        BytesColumnVector v = new BytesColumnVector();
        v.initBuffer();
        this.setString(v, 0, "arg2_0");
        this.setString(v, 1, "arg2_1");
        this.setString(v, 2, "arg2_2");
        this.setString(v, 3, "arg2_3");
        batch.cols[1] = v;
        v = new BytesColumnVector();
        v.initBuffer();
        this.setString(v, 0, "arg3_0");
        this.setString(v, 1, "arg3_1");
        this.setString(v, 2, "arg3_2");
        this.setString(v, 3, "arg3_3");
        batch.cols[2] = v;
        v = new BytesColumnVector();
        v.initBuffer();
        batch.cols[3] = v;
        batch.size = 4;
        return batch;
    }

    private void setString(BytesColumnVector v, int i, String s) {
        byte[] b = this.getUTF8Bytes(s);
        v.setVal(i, b, 0, b.length);
    }

    private byte[] getUTF8Bytes(String s) {
        byte[] b = null;
        try {
            b = s.getBytes("UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b;
    }

    private String getString(BytesColumnVector v, int i) {
        String s = null;
        try {
            s = new String(v.vector[i], v.start[i], v.length[i], "UTF-8");
        }
        catch (Exception e) {
            // empty catch block
        }
        return s;
    }

    @Test
    public void testLongColumnColumnIfExpr() {
        VectorizedRowBatch batch = this.getBatch4LongVectors();
        IfExprLongColumnLongColumn expr = new IfExprLongColumnLongColumn(0, 1, 2, 3);
        expr.evaluate(batch);
        LongColumnVector r = (LongColumnVector)batch.cols[3];
        Assert.assertEquals((long)1L, (long)r.vector[0]);
        Assert.assertEquals((long)2L, (long)r.vector[1]);
        Assert.assertEquals((long)-3L, (long)r.vector[2]);
        Assert.assertEquals((long)-4L, (long)r.vector[3]);
        Assert.assertEquals((Object)true, (Object)r.noNulls);
        Assert.assertEquals((Object)false, (Object)r.isRepeating);
        batch = this.getBatch4LongVectors();
        r = (LongColumnVector)batch.cols[3];
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)1L, (long)r.vector[0]);
        Assert.assertEquals((long)4L, (long)r.vector[3]);
        batch = this.getBatch4LongVectors();
        r = (LongColumnVector)batch.cols[3];
        batch.cols[1].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)1L, (long)r.vector[0]);
        Assert.assertEquals((long)2L, (long)r.vector[1]);
        Assert.assertEquals((long)-1L, (long)r.vector[2]);
        Assert.assertEquals((long)-1L, (long)r.vector[3]);
        batch = this.getBatch4LongVectors();
        r = (LongColumnVector)batch.cols[3];
        batch.cols[2].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)1L, (long)r.vector[0]);
        Assert.assertEquals((long)1L, (long)r.vector[1]);
        Assert.assertEquals((long)-3L, (long)r.vector[2]);
        Assert.assertEquals((long)-4L, (long)r.vector[3]);
        batch = this.getBatch4LongVectors();
        r = (LongColumnVector)batch.cols[3];
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[1] = true;
        batch.cols[0].isNull[2] = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)1L, (long)r.vector[0]);
        Assert.assertEquals((long)2L, (long)r.vector[1]);
        Assert.assertEquals((long)3L, (long)r.vector[2]);
        Assert.assertEquals((long)-4L, (long)r.vector[3]);
        Assert.assertEquals((Object)true, (Object)r.noNulls);
        Assert.assertEquals((Object)false, (Object)r.isRepeating);
        batch = this.getBatch4LongVectors();
        r = (LongColumnVector)batch.cols[3];
        batch.cols[1].noNulls = false;
        batch.cols[1].isNull[1] = true;
        batch.cols[1].isNull[2] = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)1L, (long)r.vector[0]);
        Assert.assertEquals((long)2L, (long)r.vector[1]);
        Assert.assertEquals((Object)true, (Object)r.isNull[2]);
        Assert.assertEquals((long)-4L, (long)r.vector[3]);
        Assert.assertEquals((Object)false, (Object)r.noNulls);
        Assert.assertEquals((Object)false, (Object)r.isRepeating);
        batch = this.getBatch4LongVectors();
        r = (LongColumnVector)batch.cols[3];
        batch.cols[2].noNulls = false;
        batch.cols[2].isNull[1] = true;
        batch.cols[2].isNull[2] = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)1L, (long)r.vector[0]);
        Assert.assertEquals((Object)true, (Object)r.isNull[1]);
        Assert.assertEquals((long)-3L, (long)r.vector[2]);
        Assert.assertEquals((long)-4L, (long)r.vector[3]);
        Assert.assertEquals((Object)false, (Object)r.noNulls);
        Assert.assertEquals((Object)false, (Object)r.isRepeating);
        batch = this.getBatch4LongVectors();
        r = (LongColumnVector)batch.cols[3];
        batch.cols[1].noNulls = false;
        batch.cols[1].isNull[0] = true;
        batch.cols[1].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)1L, (long)r.vector[0]);
        Assert.assertEquals((long)2L, (long)r.vector[1]);
        Assert.assertEquals((Object)true, (Object)r.isNull[2]);
        Assert.assertEquals((Object)true, (Object)r.isNull[3]);
        Assert.assertEquals((Object)false, (Object)r.noNulls);
        Assert.assertEquals((Object)false, (Object)r.isRepeating);
        batch = this.getBatch4LongVectors();
        r = (LongColumnVector)batch.cols[3];
        batch.cols[2].noNulls = false;
        batch.cols[2].isNull[0] = true;
        batch.cols[2].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((Object)true, (Object)r.isNull[0]);
        Assert.assertEquals((Object)true, (Object)r.isNull[1]);
        Assert.assertEquals((long)-3L, (long)r.vector[2]);
        Assert.assertEquals((long)-4L, (long)r.vector[3]);
        Assert.assertEquals((Object)false, (Object)r.noNulls);
        Assert.assertEquals((Object)false, (Object)r.isRepeating);
    }

    @Test
    public void testDoubleColumnColumnIfExpr() {
        VectorizedRowBatch batch = this.getBatch1Long3DoubleVectors();
        IfExprDoubleColumnDoubleColumn expr = new IfExprDoubleColumnDoubleColumn(0, 1, 2, 3);
        expr.evaluate(batch);
        DoubleColumnVector r = (DoubleColumnVector)batch.cols[3];
        Assert.assertEquals((Object)true, (Object)(1.0 == r.vector[0] ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(2.0 == r.vector[1] ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(-3.0 == r.vector[2] ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(-4.0 == r.vector[3] ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)r.noNulls);
        Assert.assertEquals((Object)false, (Object)r.isRepeating);
    }

    @Test
    public void testLongColumnScalarIfExpr() {
        VectorizedRowBatch batch = this.getBatch4LongVectors();
        IfExprLongColumnLongScalar expr = new IfExprLongColumnLongScalar(0, 1, 100L, 3);
        LongColumnVector r = (LongColumnVector)batch.cols[3];
        expr.evaluate(batch);
        Assert.assertEquals((long)100L, (long)r.vector[0]);
        Assert.assertEquals((long)100L, (long)r.vector[1]);
        Assert.assertEquals((long)-3L, (long)r.vector[2]);
        Assert.assertEquals((long)-4L, (long)r.vector[3]);
    }

    @Test
    public void testLongScalarColumnIfExpr() {
        VectorizedRowBatch batch = this.getBatch4LongVectors();
        IfExprLongScalarLongColumn expr = new IfExprLongScalarLongColumn(0, 100L, 2, 3);
        LongColumnVector r = (LongColumnVector)batch.cols[3];
        expr.evaluate(batch);
        Assert.assertEquals((long)1L, (long)r.vector[0]);
        Assert.assertEquals((long)2L, (long)r.vector[1]);
        Assert.assertEquals((long)100L, (long)r.vector[2]);
        Assert.assertEquals((long)100L, (long)r.vector[3]);
    }

    @Test
    public void testLongScalarScalarIfExpr() {
        VectorizedRowBatch batch = this.getBatch4LongVectors();
        IfExprLongScalarLongScalar expr = new IfExprLongScalarLongScalar(0, 100L, 200L, 3);
        LongColumnVector r = (LongColumnVector)batch.cols[3];
        expr.evaluate(batch);
        Assert.assertEquals((long)200L, (long)r.vector[0]);
        Assert.assertEquals((long)200L, (long)r.vector[1]);
        Assert.assertEquals((long)100L, (long)r.vector[2]);
        Assert.assertEquals((long)100L, (long)r.vector[3]);
    }

    @Test
    public void testDoubleScalarScalarIfExpr() {
        VectorizedRowBatch batch = this.getBatch1Long3DoubleVectors();
        IfExprDoubleScalarDoubleScalar expr = new IfExprDoubleScalarDoubleScalar(0, 100.0, 200.0, 3);
        DoubleColumnVector r = (DoubleColumnVector)batch.cols[3];
        expr.evaluate(batch);
        Assert.assertEquals((Object)true, (Object)(200.0 == r.vector[0] ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(200.0 == r.vector[1] ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(100.0 == r.vector[2] ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(100.0 == r.vector[3] ? 1 : 0));
    }

    @Test
    public void testDoubleScalarColumnIfExpr() {
        VectorizedRowBatch batch = this.getBatch1Long3DoubleVectors();
        IfExprDoubleScalarDoubleColumn expr = new IfExprDoubleScalarDoubleColumn(0, 100.0, 2, 3);
        DoubleColumnVector r = (DoubleColumnVector)batch.cols[3];
        expr.evaluate(batch);
        Assert.assertEquals((Object)true, (Object)(1.0 == r.vector[0] ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(2.0 == r.vector[1] ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(100.0 == r.vector[2] ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(100.0 == r.vector[3] ? 1 : 0));
    }

    @Test
    public void testDoubleColumnScalarIfExpr() {
        VectorizedRowBatch batch = this.getBatch1Long3DoubleVectors();
        IfExprDoubleColumnDoubleScalar expr = new IfExprDoubleColumnDoubleScalar(0, 1, 200.0, 3);
        DoubleColumnVector r = (DoubleColumnVector)batch.cols[3];
        expr.evaluate(batch);
        Assert.assertEquals((Object)true, (Object)(200.0 == r.vector[0] ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(200.0 == r.vector[1] ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(-3.0 == r.vector[2] ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(-4.0 == r.vector[3] ? 1 : 0));
    }

    @Test
    public void testIfExprStringColumnStringColumn() {
        VectorizedRowBatch batch = this.getBatch1Long3BytesVectors();
        IfExprStringColumnStringColumn expr = new IfExprStringColumnStringColumn(0, 1, 2, 3);
        BytesColumnVector r = (BytesColumnVector)batch.cols[3];
        expr.evaluate(batch);
        Assert.assertTrue((boolean)this.getString(r, 0).equals("arg3_0"));
        Assert.assertTrue((boolean)this.getString(r, 1).equals("arg3_1"));
        Assert.assertTrue((boolean)this.getString(r, 2).equals("arg2_2"));
        Assert.assertTrue((boolean)this.getString(r, 3).equals("arg2_3"));
        batch = this.getBatch1Long3BytesVectors();
        batch.cols[0].isRepeating = true;
        r = (BytesColumnVector)batch.cols[3];
        expr.evaluate(batch);
        Assert.assertTrue((boolean)this.getString(r, 0).equals("arg3_0"));
        Assert.assertTrue((boolean)this.getString(r, 1).equals("arg3_1"));
        Assert.assertTrue((boolean)this.getString(r, 2).equals("arg3_2"));
        Assert.assertTrue((boolean)this.getString(r, 3).equals("arg3_3"));
        batch = this.getBatch1Long3BytesVectors();
        batch.cols[1].isRepeating = true;
        r = (BytesColumnVector)batch.cols[3];
        expr.evaluate(batch);
        Assert.assertTrue((boolean)this.getString(r, 0).equals("arg3_0"));
        Assert.assertTrue((boolean)this.getString(r, 1).equals("arg3_1"));
        Assert.assertTrue((boolean)this.getString(r, 2).equals("arg2_0"));
        Assert.assertTrue((boolean)this.getString(r, 3).equals("arg2_0"));
        batch = this.getBatch1Long3BytesVectors();
        batch.cols[2].isRepeating = true;
        r = (BytesColumnVector)batch.cols[3];
        expr.evaluate(batch);
        Assert.assertTrue((boolean)this.getString(r, 0).equals("arg3_0"));
        Assert.assertTrue((boolean)this.getString(r, 1).equals("arg3_0"));
        Assert.assertTrue((boolean)this.getString(r, 2).equals("arg2_2"));
        Assert.assertTrue((boolean)this.getString(r, 3).equals("arg2_3"));
        batch = this.getBatch1Long3BytesVectors();
        batch.cols[1].noNulls = false;
        batch.cols[1].isNull[2] = true;
        ((BytesColumnVector)batch.cols[1]).vector[2] = null;
        r = (BytesColumnVector)batch.cols[3];
        expr.evaluate(batch);
        Assert.assertTrue((boolean)this.getString(r, 0).equals("arg3_0"));
        Assert.assertTrue((boolean)this.getString(r, 1).equals("arg3_1"));
        Assert.assertTrue((!r.noNulls && r.isNull[2] ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.getString(r, 3).equals("arg2_3"));
        Assert.assertFalse((r.isNull[0] || r.isNull[1] || r.isNull[3] ? 1 : 0) != 0);
        batch = this.getBatch1Long3BytesVectors();
        batch.cols[2].noNulls = false;
        batch.cols[2].isNull[0] = true;
        ((BytesColumnVector)batch.cols[2]).vector[0] = null;
        r = (BytesColumnVector)batch.cols[3];
        expr.evaluate(batch);
        Assert.assertTrue((!r.noNulls && r.isNull[0] ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.getString(r, 1).equals("arg3_1"));
        Assert.assertTrue((boolean)this.getString(r, 2).equals("arg2_2"));
        Assert.assertTrue((boolean)this.getString(r, 3).equals("arg2_3"));
        Assert.assertFalse((r.isNull[1] || r.isNull[2] || r.isNull[3] ? 1 : 0) != 0);
        batch = this.getBatch1Long3BytesVectors();
        batch.cols[1].noNulls = false;
        batch.cols[1].isNull[0] = true;
        batch.cols[1].isRepeating = true;
        r = (BytesColumnVector)batch.cols[3];
        expr.evaluate(batch);
        Assert.assertTrue((boolean)this.getString(r, 0).equals("arg3_0"));
        Assert.assertTrue((boolean)this.getString(r, 1).equals("arg3_1"));
        Assert.assertTrue((!r.noNulls && r.isNull[2] ? 1 : 0) != 0);
        Assert.assertTrue((!r.noNulls && r.isNull[3] ? 1 : 0) != 0);
        Assert.assertFalse((r.isNull[0] || r.isNull[1] ? 1 : 0) != 0);
    }

    @Test
    public void testIfExprStringColumnStringScalar() {
        VectorizedRowBatch batch = this.getBatch1Long3BytesVectors();
        byte[] scalar = this.getUTF8Bytes("scalar");
        IfExprStringColumnStringScalar expr = new IfExprStringColumnStringScalar(0, 1, scalar, 3);
        BytesColumnVector r = (BytesColumnVector)batch.cols[3];
        expr.evaluate(batch);
        Assert.assertTrue((boolean)this.getString(r, 0).equals("scalar"));
        Assert.assertTrue((boolean)this.getString(r, 1).equals("scalar"));
        Assert.assertTrue((boolean)this.getString(r, 2).equals("arg2_2"));
        Assert.assertTrue((boolean)this.getString(r, 3).equals("arg2_3"));
        Assert.assertTrue((boolean)r.noNulls);
        batch = this.getBatch1Long3BytesVectors();
        BytesColumnVector arg2 = (BytesColumnVector)batch.cols[1];
        arg2.noNulls = false;
        arg2.isNull[2] = true;
        arg2.vector[2] = null;
        expr.evaluate(batch);
        r = (BytesColumnVector)batch.cols[3];
        Assert.assertTrue((!r.noNulls && r.isNull[2] ? 1 : 0) != 0);
    }

    @Test
    public void testIfExprStringScalarStringColumn() {
        VectorizedRowBatch batch = this.getBatch1Long3BytesVectors();
        byte[] scalar = this.getUTF8Bytes("scalar");
        IfExprStringScalarStringColumn expr = new IfExprStringScalarStringColumn(0, scalar, 2, 3);
        BytesColumnVector r = (BytesColumnVector)batch.cols[3];
        expr.evaluate(batch);
        Assert.assertTrue((boolean)this.getString(r, 0).equals("arg3_0"));
        Assert.assertTrue((boolean)this.getString(r, 1).equals("arg3_1"));
        Assert.assertTrue((boolean)this.getString(r, 2).equals("scalar"));
        Assert.assertTrue((boolean)this.getString(r, 3).equals("scalar"));
        Assert.assertTrue((boolean)r.noNulls);
        batch = this.getBatch1Long3BytesVectors();
        BytesColumnVector arg3 = (BytesColumnVector)batch.cols[2];
        arg3.noNulls = false;
        arg3.isNull[1] = true;
        arg3.vector[1] = null;
        expr.evaluate(batch);
        r = (BytesColumnVector)batch.cols[3];
        Assert.assertTrue((!r.noNulls && r.isNull[1] ? 1 : 0) != 0);
    }

    @Test
    public void testIfExprStringScalarStringScalar() {
        VectorizedRowBatch batch = this.getBatch1Long3BytesVectors();
        byte[] scalar1 = this.getUTF8Bytes("scalar1");
        byte[] scalar2 = this.getUTF8Bytes("scalar2");
        IfExprStringScalarStringScalar expr = new IfExprStringScalarStringScalar(0, scalar1, scalar2, 3);
        BytesColumnVector r = (BytesColumnVector)batch.cols[3];
        expr.evaluate(batch);
        Assert.assertTrue((boolean)this.getString(r, 0).equals("scalar2"));
        Assert.assertTrue((boolean)this.getString(r, 1).equals("scalar2"));
        Assert.assertTrue((boolean)this.getString(r, 2).equals("scalar1"));
        Assert.assertTrue((boolean)this.getString(r, 3).equals("scalar1"));
        Assert.assertFalse((boolean)r.isRepeating);
        batch = this.getBatch1Long3BytesVectors();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        r = (BytesColumnVector)batch.cols[3];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertTrue((boolean)this.getString(r, 0).equals("scalar2"));
    }
}

