/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.errors;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.errors.ErrorAndSolution;
import org.apache.hadoop.hive.ql.exec.errors.TaskLogProcessor;
import org.apache.hadoop.mapred.JobConf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestTaskLogProcessor {
    private final List<File> toBeDeletedList = new LinkedList<File>();

    @After
    public void after() {
        for (File f : this.toBeDeletedList) {
            f.delete();
        }
        this.toBeDeletedList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeTestLog(String id, String content) throws IOException {
        File scriptFile = File.createTempFile(this.getClass().getName() + "-" + id + "-", ".log");
        scriptFile.deleteOnExit();
        this.toBeDeletedList.add(scriptFile);
        PrintStream os = new PrintStream(new FileOutputStream(scriptFile));
        try {
            os.print(content);
        }
        finally {
            os.close();
        }
        return scriptFile;
    }

    private String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    private String writeThrowableAsFile(String before, Throwable t, String after, String fileSuffix, TaskLogProcessor taskLogProcessor) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (before != null) {
            sb.append(before);
        }
        String stackTraceStr = this.toString(t);
        sb.append(stackTraceStr);
        if (after != null) {
            sb.append(after);
        }
        File file = this.writeTestLog(fileSuffix, sb.toString());
        taskLogProcessor.addTaskAttemptLogUrl(file.toURI().toURL().toString());
        return stackTraceStr;
    }

    @Test
    public void testGetStackTraces() throws Exception {
        JobConf jobConf = new JobConf();
        jobConf.set(HiveConf.ConfVars.HIVEQUERYSTRING.varname, "select * from foo group by moo;");
        TaskLogProcessor taskLogProcessor = new TaskLogProcessor(jobConf);
        OutOfMemoryError oome = new OutOfMemoryError("java heap space");
        String oomeStr = this.writeThrowableAsFile("Some line in the beginning\n", oome, null, "1", taskLogProcessor);
        InvocationTargetException compositeException = new InvocationTargetException(new IOException(new NullPointerException()));
        String compositeStr = this.writeThrowableAsFile(null, compositeException, "Some line in the end.\n", "2", taskLogProcessor);
        EOFException eofe = new EOFException();
        String eofeStr = this.writeThrowableAsFile("line a\nlineb\n", eofe, " line c\nlineD\n", "3", taskLogProcessor);
        List stackTraces = taskLogProcessor.getStackTraces();
        Assert.assertEquals((long)3L, (long)stackTraces.size());
        this.checkException(oomeStr, (List)stackTraces.get(0));
        this.checkException(compositeStr, (List)stackTraces.get(1));
        this.checkException(eofeStr, (List)stackTraces.get(2));
    }

    private void checkException(String writenText, List<String> actualTrace) throws IOException {
        List<String> expectedLines = this.getLines(writenText);
        for (int i = 0; i < expectedLines.size(); ++i) {
            String expected = expectedLines.get(i);
            String actual = actualTrace.get(i);
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    private List<String> getLines(String text) throws IOException {
        String string;
        BufferedReader br = new BufferedReader(new StringReader(text));
        ArrayList<String> list = new ArrayList<String>(48);
        while ((string = br.readLine()) != null) {
            list.add(string);
        }
        br.close();
        return list;
    }

    @Test
    public void testScriptErrorHeuristic() throws Exception {
        JobConf jobConf = new JobConf();
        jobConf.set(HiveConf.ConfVars.HIVEQUERYSTRING.varname, "select * from foo group by moo;");
        TaskLogProcessor taskLogProcessor = new TaskLogProcessor(jobConf);
        String errorCode = "7874";
        String content = "line a\nlineb\nScript failed with code " + errorCode + " line c\nlineD\n";
        File log3File = this.writeTestLog("1", content);
        taskLogProcessor.addTaskAttemptLogUrl(log3File.toURI().toURL().toString());
        List errList = taskLogProcessor.getErrors();
        Assert.assertEquals((long)1L, (long)errList.size());
        ErrorAndSolution eas = (ErrorAndSolution)errList.get(0);
        String error = eas.getError();
        Assert.assertNotNull((Object)error);
        Assert.assertTrue((error.indexOf(errorCode) >= 0 ? 1 : 0) != 0);
        String solution = eas.getSolution();
        Assert.assertNotNull((Object)solution);
        Assert.assertTrue((solution.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDataCorruptErrorHeuristic() throws Exception {
        JobConf jobConf = new JobConf();
        jobConf.set(HiveConf.ConfVars.HIVEQUERYSTRING.varname, "select * from foo group by moo;");
        TaskLogProcessor taskLogProcessor = new TaskLogProcessor(jobConf);
        String badFile1 = "hdfs://localhost/foo1/moo1/zoo1";
        String badFile2 = "hdfs://localhost/foo2/moo2/zoo2";
        String content = "line a\nlineb\nsplit: " + badFile1 + " is very bad.\n" + " line c\nlineD\n" + "split: " + badFile2 + " is also very bad.\n" + " java.io.EOFException: null \n" + "line E\n";
        File log3File = this.writeTestLog("1", content);
        taskLogProcessor.addTaskAttemptLogUrl(log3File.toURI().toURL().toString());
        List errList = taskLogProcessor.getErrors();
        Assert.assertEquals((long)1L, (long)errList.size());
        ErrorAndSolution eas = (ErrorAndSolution)errList.get(0);
        String error = eas.getError();
        Assert.assertNotNull((Object)error);
        Assert.assertTrue((error.contains(badFile1) || error.contains(badFile2) ? 1 : 0) != 0);
        String solution = eas.getSolution();
        Assert.assertNotNull((Object)solution);
        Assert.assertTrue((solution.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMapAggrMemErrorHeuristic() throws Exception {
        JobConf jobConf = new JobConf();
        jobConf.set(HiveConf.ConfVars.HIVEQUERYSTRING.varname, "select * from foo group by moo;");
        TaskLogProcessor taskLogProcessor = new TaskLogProcessor(jobConf);
        OutOfMemoryError oome = new OutOfMemoryError("java heap space");
        File log1File = this.writeTestLog("1", this.toString(oome));
        taskLogProcessor.addTaskAttemptLogUrl(log1File.toURI().toURL().toString());
        List errList = taskLogProcessor.getErrors();
        Assert.assertEquals((long)1L, (long)errList.size());
        ErrorAndSolution eas = (ErrorAndSolution)errList.get(0);
        String error = eas.getError();
        Assert.assertNotNull((Object)error);
        Assert.assertTrue((boolean)error.contains("memory"));
        String solution = eas.getSolution();
        Assert.assertNotNull((Object)solution);
        Assert.assertTrue((solution.length() > 0 ? 1 : 0) != 0);
        String confName = HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY.toString();
        Assert.assertTrue((boolean)solution.contains(confName));
    }
}

