/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.pcr;

import java.util.ArrayList;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.optimizer.pcr.PcrExprProcFactory;
import org.apache.hadoop.hive.ql.optimizer.pcr.PcrOpWalkerCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public final class PcrOpProcFactory {
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.optimizer.pcr.OpProcFactory");

    public static NodeProcessor getFilterProc() {
        return new FilterPCR();
    }

    public static NodeProcessor getDefaultProc() {
        return new DefaultPCR();
    }

    private PcrOpProcFactory() {
    }

    public static class DefaultPCR
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }

    public static class FilterPCR
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            PrunedPartitionList prunedPartList;
            PcrOpWalkerCtx owc = (PcrOpWalkerCtx)procCtx;
            FilterOperator fop = (FilterOperator)nd;
            FilterOperator fop2 = null;
            Node tmp = stack.pop();
            Node tmp2 = stack.pop();
            TableScanOperator top = null;
            Operator pop = null;
            if (tmp2 instanceof TableScanOperator) {
                pop = top = (TableScanOperator)tmp2;
            } else {
                top = (TableScanOperator)stack.peek();
                fop2 = (FilterOperator)tmp2;
                pop = fop2;
            }
            stack.push(tmp2);
            stack.push(tmp);
            if (fop2 != null && !((FilterDesc)fop2.getConf()).getIsSamplingPred()) {
                return null;
            }
            if (((FilterDesc)fop.getConf()).getIsSamplingPred()) {
                return null;
            }
            if (fop.getParentOperators().size() > 1) {
                return null;
            }
            ParseContext pctx = owc.getParseContext();
            try {
                String alias = (String)owc.getParseContext().getTopOps().keySet().toArray()[0];
                prunedPartList = pctx.getPrunedPartitions(alias, top);
            }
            catch (HiveException e) {
                throw new SemanticException(e.getMessage(), e);
            }
            ExprNodeDesc predicate = ((FilterDesc)fop.getConf()).getPredicate();
            String alias = ((TableScanDesc)top.getConf()).getAlias();
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            if (prunedPartList == null) {
                return null;
            }
            for (Partition p : prunedPartList.getPartitions()) {
                if (p.getTable().isPartitioned()) continue;
                return null;
            }
            partitions.addAll(prunedPartList.getPartitions());
            PcrExprProcFactory.NodeInfoWrapper wrapper = PcrExprProcFactory.walkExprTree(alias, partitions, ((TableScanDesc)top.getConf()).getVirtualCols(), predicate);
            if (wrapper.state == PcrExprProcFactory.WalkState.TRUE) {
                owc.getOpToRemove().add(new PcrOpWalkerCtx.OpToDeleteInfo(pop, fop));
            } else if (wrapper.state != PcrExprProcFactory.WalkState.FALSE) {
                ((FilterDesc)fop.getConf()).setPredicate(wrapper.outExpr);
            } else {
                LOG.warn((Object)"Filter passes no row");
                ((FilterDesc)fop.getConf()).setPredicate(wrapper.outExpr);
            }
            return null;
        }
    }
}

