/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.rcfile.truncate;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.hive.ql.io.BucketizedHiveInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileBlockMergeInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateMapper;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.mapred.Mapper;

@Explain(displayName="Column Truncate")
public class ColumnTruncateWork
extends MapWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String inputDir;
    private String outputDir;
    private boolean hasDynamicPartitions;
    private DynamicPartitionCtx dynPartCtx;
    private boolean isListBucketingAlterTableConcatenate;
    private ListBucketingCtx listBucketingCtx;
    private List<Integer> droppedColumns;

    public ColumnTruncateWork() {
    }

    public ColumnTruncateWork(List<Integer> droppedColumns, String inputDir, String outputDir) {
        this(droppedColumns, inputDir, outputDir, false, null);
    }

    public ColumnTruncateWork(List<Integer> droppedColumns, String inputDir, String outputDir, boolean hasDynamicPartitions, DynamicPartitionCtx dynPartCtx) {
        this.droppedColumns = droppedColumns;
        this.inputDir = inputDir;
        this.outputDir = outputDir;
        this.hasDynamicPartitions = hasDynamicPartitions;
        this.dynPartCtx = dynPartCtx;
        PartitionDesc partDesc = new PartitionDesc();
        partDesc.setInputFileFormatClass(RCFileBlockMergeInputFormat.class);
        if (this.getPathToPartitionInfo() == null) {
            this.setPathToPartitionInfo(new LinkedHashMap<String, PartitionDesc>());
        }
        this.getPathToPartitionInfo().put(inputDir, partDesc);
    }

    public String getInputDir() {
        return this.inputDir;
    }

    public void setInputPaths(String inputDir) {
        this.inputDir = inputDir;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public Class<? extends Mapper> getMapperClass() {
        return ColumnTruncateMapper.class;
    }

    @Override
    public Long getMinSplitSize() {
        return null;
    }

    @Override
    public String getInputformat() {
        return BucketizedHiveInputFormat.class.getName();
    }

    @Override
    public boolean isGatheringStats() {
        return false;
    }

    public boolean hasDynamicPartitions() {
        return this.hasDynamicPartitions;
    }

    public void setHasDynamicPartitions(boolean hasDynamicPartitions) {
        this.hasDynamicPartitions = hasDynamicPartitions;
    }

    public DynamicPartitionCtx getDynPartCtx() {
        return this.dynPartCtx;
    }

    public void setDynPartCtx(DynamicPartitionCtx dynPartCtx) {
        this.dynPartCtx = dynPartCtx;
    }

    public ListBucketingCtx getListBucketingCtx() {
        return this.listBucketingCtx;
    }

    public void setListBucketingCtx(ListBucketingCtx listBucketingCtx) {
        this.listBucketingCtx = listBucketingCtx;
    }

    public boolean isListBucketingAlterTableConcatenate() {
        return this.isListBucketingAlterTableConcatenate;
    }

    public List<Integer> getDroppedColumns() {
        return this.droppedColumns;
    }

    public void setDroppedColumns(List<Integer> droppedColumns) {
        this.droppedColumns = droppedColumns;
    }
}

