/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.BitFieldWriter;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatisticsImpl;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.DynamicIntArray;
import org.apache.hadoop.hive.ql.io.orc.IntegerWriter;
import org.apache.hadoop.hive.ql.io.orc.MemoryManager;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OutStream;
import org.apache.hadoop.hive.ql.io.orc.PositionRecorder;
import org.apache.hadoop.hive.ql.io.orc.PositionedOutputStream;
import org.apache.hadoop.hive.ql.io.orc.RunLengthByteWriter;
import org.apache.hadoop.hive.ql.io.orc.RunLengthIntegerWriter;
import org.apache.hadoop.hive.ql.io.orc.RunLengthIntegerWriterV2;
import org.apache.hadoop.hive.ql.io.orc.SerializationUtils;
import org.apache.hadoop.hive.ql.io.orc.SnappyCodec;
import org.apache.hadoop.hive.ql.io.orc.StreamName;
import org.apache.hadoop.hive.ql.io.orc.StringRedBlackTree;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.io.orc.ZlibCodec;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ParameterizedPrimitiveTypeUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeParams;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.spark_project.protobuf.ByteString;
import org.spark_project.protobuf.CodedOutputStream;

class WriterImpl
implements Writer,
MemoryManager.Callback {
    private static final Log LOG = LogFactory.getLog(WriterImpl.class);
    private static final int HDFS_BUFFER_SIZE = 262144;
    private static final int MIN_ROW_INDEX_STRIDE = 1000;
    private static final long MAX_BLOCK_SIZE = 0x60000000L;
    private final FileSystem fs;
    private final Path path;
    private final long stripeSize;
    private final int rowIndexStride;
    private final CompressionKind compress;
    private final CompressionCodec codec;
    private final boolean addBlockPadding;
    private final int bufferSize;
    private final long blockSize;
    private final Map<StreamName, BufferedStream> streams = new TreeMap<StreamName, BufferedStream>();
    private FSDataOutputStream rawWriter = null;
    private OutStream writer = null;
    private CodedOutputStream protobufWriter = null;
    private long headerLength;
    private int columnCount;
    private long rowCount = 0L;
    private long rowsInStripe = 0L;
    private int rowsInIndex = 0;
    private final List<OrcProto.StripeInformation> stripes = new ArrayList<OrcProto.StripeInformation>();
    private final Map<String, ByteString> userMetadata = new TreeMap<String, ByteString>();
    private final StreamFactory streamFactory = new StreamFactory();
    private final TreeWriter treeWriter;
    private final OrcProto.RowIndex.Builder rowIndex = OrcProto.RowIndex.newBuilder();
    private final boolean buildIndex;
    private final MemoryManager memoryManager;
    private final OrcFile.Version version;
    private final Configuration conf;
    static final int MILLIS_PER_SECOND = 1000;
    static final long BASE_TIMESTAMP = Timestamp.valueOf("2015-01-01 00:00:00").getTime() / 1000L;

    WriterImpl(FileSystem fs, Path path, Configuration conf, ObjectInspector inspector, long stripeSize, CompressionKind compress, int bufferSize, int rowIndexStride, MemoryManager memoryManager, boolean addBlockPadding, OrcFile.Version version) throws IOException {
        this.fs = fs;
        this.path = path;
        this.conf = conf;
        this.stripeSize = stripeSize;
        this.version = version;
        this.addBlockPadding = addBlockPadding;
        this.blockSize = Math.min(0x60000000L, 2L * stripeSize);
        this.compress = compress;
        this.bufferSize = bufferSize;
        this.rowIndexStride = rowIndexStride;
        this.memoryManager = memoryManager;
        this.buildIndex = rowIndexStride > 0;
        this.codec = WriterImpl.createCodec(compress);
        this.treeWriter = WriterImpl.createTreeWriter(inspector, this.streamFactory, false);
        if (this.buildIndex && rowIndexStride < 1000) {
            throw new IllegalArgumentException("Row stride must be at least 1000");
        }
        memoryManager.addWriter(path, stripeSize, this);
    }

    static CompressionCodec createCodec(CompressionKind kind) {
        switch (kind) {
            case NONE: {
                return null;
            }
            case ZLIB: {
                return new ZlibCodec();
            }
            case SNAPPY: {
                return new SnappyCodec();
            }
            case LZO: {
                try {
                    Class<?> lzo = Class.forName("org.apache.hadoop.hive.ql.io.orc.LzoCodec");
                    return (CompressionCodec)lzo.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("LZO is not available.", e);
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("Problem initializing LZO", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Insufficient access to LZO", e);
                }
            }
        }
        throw new IllegalArgumentException("Unknown compression codec: " + (Object)((Object)kind));
    }

    @Override
    public synchronized boolean checkMemory(double newScale) throws IOException {
        long limit = Math.round((double)this.stripeSize * newScale);
        long size = this.estimateStripeSize();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ORC writer " + this.path + " size = " + size + " limit = " + limit));
        }
        if (size > limit) {
            this.flushStripe();
            return true;
        }
        return false;
    }

    private static TreeWriter createTreeWriter(ObjectInspector inspector, StreamFactory streamFactory, boolean nullable) throws IOException {
        switch (inspector.getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveObjectInspector)inspector).getPrimitiveCategory()) {
                    case BOOLEAN: {
                        return new BooleanTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable);
                    }
                    case BYTE: {
                        return new ByteTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable);
                    }
                    case SHORT: 
                    case INT: 
                    case LONG: {
                        return new IntegerTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable);
                    }
                    case FLOAT: {
                        return new FloatTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable);
                    }
                    case DOUBLE: {
                        return new DoubleTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable);
                    }
                    case STRING: {
                        return new StringTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable);
                    }
                    case VARCHAR: {
                        return new VarcharTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable);
                    }
                    case BINARY: {
                        return new BinaryTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable);
                    }
                    case TIMESTAMP: {
                        return new TimestampTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable);
                    }
                    case DATE: {
                        return new DateTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable);
                    }
                    case DECIMAL: {
                        return new DecimalTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable);
                    }
                }
                throw new IllegalArgumentException("Bad primitive category " + (Object)((Object)((PrimitiveObjectInspector)inspector).getPrimitiveCategory()));
            }
            case STRUCT: {
                return new StructTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable);
            }
            case MAP: {
                return new MapTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable);
            }
            case LIST: {
                return new ListTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable);
            }
            case UNION: {
                return new UnionTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable);
            }
        }
        throw new IllegalArgumentException("Bad category: " + (Object)((Object)inspector.getCategory()));
    }

    private static void writeTypes(OrcProto.Footer.Builder builder, TreeWriter treeWriter) {
        OrcProto.Type.Builder type = OrcProto.Type.newBuilder();
        block0 : switch (treeWriter.inspector.getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveObjectInspector)treeWriter.inspector).getPrimitiveCategory()) {
                    case BOOLEAN: {
                        type.setKind(OrcProto.Type.Kind.BOOLEAN);
                        break block0;
                    }
                    case BYTE: {
                        type.setKind(OrcProto.Type.Kind.BYTE);
                        break block0;
                    }
                    case SHORT: {
                        type.setKind(OrcProto.Type.Kind.SHORT);
                        break block0;
                    }
                    case INT: {
                        type.setKind(OrcProto.Type.Kind.INT);
                        break block0;
                    }
                    case LONG: {
                        type.setKind(OrcProto.Type.Kind.LONG);
                        break block0;
                    }
                    case FLOAT: {
                        type.setKind(OrcProto.Type.Kind.FLOAT);
                        break block0;
                    }
                    case DOUBLE: {
                        type.setKind(OrcProto.Type.Kind.DOUBLE);
                        break block0;
                    }
                    case STRING: {
                        type.setKind(OrcProto.Type.Kind.STRING);
                        break block0;
                    }
                    case VARCHAR: {
                        VarcharTypeParams varcharParams = (VarcharTypeParams)ParameterizedPrimitiveTypeUtils.getTypeParamsFromPrimitiveObjectInspector((PrimitiveObjectInspector)treeWriter.inspector);
                        if (varcharParams == null) {
                            throw new IllegalArgumentException("No varchar length specified in ORC type");
                        }
                        type.setKind(OrcProto.Type.Kind.VARCHAR);
                        type.setMaximumLength(varcharParams.getLength());
                        break block0;
                    }
                    case BINARY: {
                        type.setKind(OrcProto.Type.Kind.BINARY);
                        break block0;
                    }
                    case TIMESTAMP: {
                        type.setKind(OrcProto.Type.Kind.TIMESTAMP);
                        break block0;
                    }
                    case DATE: {
                        type.setKind(OrcProto.Type.Kind.DATE);
                        break block0;
                    }
                    case DECIMAL: {
                        type.setKind(OrcProto.Type.Kind.DECIMAL);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unknown primitive category: " + (Object)((Object)((PrimitiveObjectInspector)treeWriter.inspector).getPrimitiveCategory()));
            }
            case LIST: {
                type.setKind(OrcProto.Type.Kind.LIST);
                type.addSubtypes(treeWriter.childrenWriters[0].id);
                break;
            }
            case MAP: {
                type.setKind(OrcProto.Type.Kind.MAP);
                type.addSubtypes(treeWriter.childrenWriters[0].id);
                type.addSubtypes(treeWriter.childrenWriters[1].id);
                break;
            }
            case STRUCT: {
                type.setKind(OrcProto.Type.Kind.STRUCT);
                for (TreeWriter child : treeWriter.childrenWriters) {
                    type.addSubtypes(child.id);
                }
                for (StructField field : ((StructTreeWriter)treeWriter).fields) {
                    type.addFieldNames(field.getFieldName());
                }
                break;
            }
            case UNION: {
                type.setKind(OrcProto.Type.Kind.UNION);
                for (TreeWriter child : treeWriter.childrenWriters) {
                    type.addSubtypes(child.id);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown category: " + (Object)((Object)treeWriter.inspector.getCategory()));
            }
        }
        builder.addTypes(type);
        for (TreeWriter child : treeWriter.childrenWriters) {
            WriterImpl.writeTypes(builder, child);
        }
    }

    private void ensureWriter() throws IOException {
        if (this.rawWriter == null) {
            this.rawWriter = this.fs.create(this.path, false, 262144, this.fs.getDefaultReplication(), this.blockSize);
            this.rawWriter.writeBytes("ORC");
            this.headerLength = this.rawWriter.getPos();
            this.writer = new OutStream("metadata", this.bufferSize, this.codec, new DirectStream(this.rawWriter));
            this.protobufWriter = CodedOutputStream.newInstance((OutputStream)this.writer);
        }
    }

    private void createRowIndexEntry() throws IOException {
        this.treeWriter.createRowIndexEntry();
        this.rowsInIndex = 0;
    }

    private void flushStripe() throws IOException {
        this.ensureWriter();
        if (this.buildIndex && this.rowsInIndex != 0) {
            this.createRowIndexEntry();
        }
        if (this.rowsInStripe != 0L) {
            int requiredIndexEntries = this.rowIndexStride == 0 ? 0 : (int)((this.rowsInStripe + (long)this.rowIndexStride - 1L) / (long)this.rowIndexStride);
            OrcProto.StripeFooter.Builder builder = OrcProto.StripeFooter.newBuilder();
            this.treeWriter.writeStripe(builder, requiredIndexEntries);
            long indexSize = 0L;
            long dataSize = 0L;
            for (Map.Entry<StreamName, BufferedStream> pair : this.streams.entrySet()) {
                BufferedStream stream = pair.getValue();
                if (stream.isSuppressed()) continue;
                stream.flush();
                StreamName name = pair.getKey();
                long streamSize = pair.getValue().getOutputSize();
                builder.addStreams(OrcProto.Stream.newBuilder().setColumn(name.getColumn()).setKind(name.getKind()).setLength(streamSize));
                if (StreamName.Area.INDEX == name.getArea()) {
                    indexSize += streamSize;
                    continue;
                }
                dataSize += streamSize;
            }
            OrcProto.StripeFooter footer = builder.build();
            long start = this.rawWriter.getPos();
            long stripeSize = indexSize + dataSize + (long)footer.getSerializedSize();
            if (this.addBlockPadding && stripeSize < this.blockSize && start % this.blockSize + stripeSize > this.blockSize) {
                long padding = this.blockSize - start % this.blockSize;
                byte[] pad = new byte[(int)Math.min(262144L, padding)];
                start += padding;
                while (padding > 0L) {
                    int writeLen = (int)Math.min(padding, (long)pad.length);
                    this.rawWriter.write(pad, 0, writeLen);
                    padding -= (long)writeLen;
                }
            }
            for (Map.Entry<StreamName, BufferedStream> pair : this.streams.entrySet()) {
                BufferedStream stream = pair.getValue();
                if (!stream.isSuppressed()) {
                    stream.spillTo((OutputStream)this.rawWriter);
                }
                stream.clear();
            }
            footer.writeTo(this.protobufWriter);
            this.protobufWriter.flush();
            this.writer.flush();
            long footerLength = this.rawWriter.getPos() - start - dataSize - indexSize;
            OrcProto.StripeInformation dirEntry = OrcProto.StripeInformation.newBuilder().setOffset(start).setNumberOfRows(this.rowsInStripe).setIndexLength(indexSize).setDataLength(dataSize).setFooterLength(footerLength).build();
            this.stripes.add(dirEntry);
            this.rowCount += this.rowsInStripe;
            this.rowsInStripe = 0L;
        }
    }

    private OrcProto.CompressionKind writeCompressionKind(CompressionKind kind) {
        switch (kind) {
            case NONE: {
                return OrcProto.CompressionKind.NONE;
            }
            case ZLIB: {
                return OrcProto.CompressionKind.ZLIB;
            }
            case SNAPPY: {
                return OrcProto.CompressionKind.SNAPPY;
            }
            case LZO: {
                return OrcProto.CompressionKind.LZO;
            }
        }
        throw new IllegalArgumentException("Unknown compression " + (Object)((Object)kind));
    }

    private void writeFileStatistics(OrcProto.Footer.Builder builder, TreeWriter writer) throws IOException {
        builder.addStatistics(writer.fileStatistics.serialize());
        for (TreeWriter child : writer.getChildrenWriters()) {
            this.writeFileStatistics(builder, child);
        }
    }

    private int writeFooter(long bodyLength) throws IOException {
        this.ensureWriter();
        OrcProto.Footer.Builder builder = OrcProto.Footer.newBuilder();
        builder.setContentLength(bodyLength);
        builder.setHeaderLength(this.headerLength);
        builder.setNumberOfRows(this.rowCount);
        builder.setRowIndexStride(this.rowIndexStride);
        WriterImpl.writeTypes(builder, this.treeWriter);
        for (OrcProto.StripeInformation stripeInformation : this.stripes) {
            builder.addStripes(stripeInformation);
        }
        this.writeFileStatistics(builder, this.treeWriter);
        for (Map.Entry entry : this.userMetadata.entrySet()) {
            builder.addMetadata(OrcProto.UserMetadataItem.newBuilder().setName((String)entry.getKey()).setValue((ByteString)entry.getValue()));
        }
        long startPosn = this.rawWriter.getPos();
        OrcProto.Footer footer = builder.build();
        footer.writeTo(this.protobufWriter);
        this.protobufWriter.flush();
        this.writer.flush();
        return (int)(this.rawWriter.getPos() - startPosn);
    }

    private int writePostScript(int footerLength) throws IOException {
        OrcProto.PostScript.Builder builder = OrcProto.PostScript.newBuilder().setCompression(this.writeCompressionKind(this.compress)).setFooterLength(footerLength).setMagic("ORC").addVersion(this.version.getMajor()).addVersion(this.version.getMinor());
        if (this.compress != CompressionKind.NONE) {
            builder.setCompressionBlockSize(this.bufferSize);
        }
        OrcProto.PostScript ps = builder.build();
        long startPosn = this.rawWriter.getPos();
        ps.writeTo((OutputStream)this.rawWriter);
        long length = this.rawWriter.getPos() - startPosn;
        if (length > 255L) {
            throw new IllegalArgumentException("PostScript too large at " + length);
        }
        return (int)length;
    }

    private long estimateStripeSize() {
        long result = 0L;
        for (BufferedStream stream : this.streams.values()) {
            result += stream.getBufferSize();
        }
        return result += this.treeWriter.estimateMemory();
    }

    @Override
    public synchronized void addUserMetadata(String name, ByteBuffer value) {
        this.userMetadata.put(name, ByteString.copyFrom((ByteBuffer)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRow(Object row) throws IOException {
        WriterImpl writerImpl = this;
        synchronized (writerImpl) {
            this.treeWriter.write(row);
            ++this.rowsInStripe;
            if (this.buildIndex) {
                ++this.rowsInIndex;
                if (this.rowsInIndex >= this.rowIndexStride) {
                    this.createRowIndexEntry();
                }
            }
        }
        this.memoryManager.addedRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.memoryManager.removeWriter(this.path);
        WriterImpl writerImpl = this;
        synchronized (writerImpl) {
            this.flushStripe();
            int footerLength = this.writeFooter(this.rawWriter.getPos());
            this.rawWriter.writeByte(this.writePostScript(footerLength));
            this.rawWriter.close();
        }
    }

    private static class UnionTreeWriter
    extends TreeWriter {
        private final RunLengthByteWriter tags;

        UnionTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, inspector, writer, nullable);
            UnionObjectInspector insp = (UnionObjectInspector)inspector;
            List<ObjectInspector> choices = insp.getObjectInspectors();
            this.childrenWriters = new TreeWriter[choices.size()];
            for (int i = 0; i < this.childrenWriters.length; ++i) {
                this.childrenWriters[i] = WriterImpl.createTreeWriter(choices.get(i), writer, true);
            }
            this.tags = new RunLengthByteWriter(writer.createStream(columnId, OrcProto.Stream.Kind.DATA));
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj);
            if (obj != null) {
                UnionObjectInspector insp = (UnionObjectInspector)this.inspector;
                byte tag = insp.getTag(obj);
                this.tags.write(tag);
                this.childrenWriters[tag].write(insp.getField(obj));
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.tags.flush();
            for (TreeWriter child : this.childrenWriters) {
                child.writeStripe(builder, requiredIndexEntries);
            }
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.tags.getPosition(recorder);
        }
    }

    private static class MapTreeWriter
    extends TreeWriter {
        private final IntegerWriter lengths;
        private final boolean isDirectV2;

        MapTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, inspector, writer, nullable);
            this.isDirectV2 = this.isNewWriteFormat(writer);
            MapObjectInspector insp = (MapObjectInspector)inspector;
            this.childrenWriters = new TreeWriter[2];
            this.childrenWriters[0] = WriterImpl.createTreeWriter(insp.getMapKeyObjectInspector(), writer, true);
            this.childrenWriters[1] = WriterImpl.createTreeWriter(insp.getMapValueObjectInspector(), writer, true);
            this.lengths = this.createIntegerWriter(writer.createStream(columnId, OrcProto.Stream.Kind.LENGTH), false, this.isDirectV2);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        OrcProto.ColumnEncoding getEncoding() {
            if (this.isDirectV2) {
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2).build();
            }
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj);
            if (obj != null) {
                MapObjectInspector insp = (MapObjectInspector)this.inspector;
                int len = insp.getMapSize(obj);
                this.lengths.write(len);
                Map<?, ?> valueMap = insp.getMap(obj);
                for (Map.Entry<?, ?> entry : valueMap.entrySet()) {
                    this.childrenWriters[0].write(entry.getKey());
                    this.childrenWriters[1].write(entry.getValue());
                }
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.lengths.flush();
            for (TreeWriter child : this.childrenWriters) {
                child.writeStripe(builder, requiredIndexEntries);
            }
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.lengths.getPosition(recorder);
        }
    }

    private static class ListTreeWriter
    extends TreeWriter {
        private final IntegerWriter lengths;
        private final boolean isDirectV2;

        ListTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, inspector, writer, nullable);
            this.isDirectV2 = this.isNewWriteFormat(writer);
            ListObjectInspector listObjectInspector = (ListObjectInspector)inspector;
            this.childrenWriters = new TreeWriter[1];
            this.childrenWriters[0] = WriterImpl.createTreeWriter(listObjectInspector.getListElementObjectInspector(), writer, true);
            this.lengths = this.createIntegerWriter(writer.createStream(columnId, OrcProto.Stream.Kind.LENGTH), false, this.isDirectV2);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        OrcProto.ColumnEncoding getEncoding() {
            if (this.isDirectV2) {
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2).build();
            }
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj);
            if (obj != null) {
                ListObjectInspector insp = (ListObjectInspector)this.inspector;
                int len = insp.getListLength(obj);
                this.lengths.write(len);
                for (int i = 0; i < len; ++i) {
                    this.childrenWriters[0].write(insp.getListElement(obj, i));
                }
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.lengths.flush();
            for (TreeWriter child : this.childrenWriters) {
                child.writeStripe(builder, requiredIndexEntries);
            }
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.lengths.getPosition(recorder);
        }
    }

    private static class StructTreeWriter
    extends TreeWriter {
        private final List<? extends StructField> fields;

        StructTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, inspector, writer, nullable);
            StructObjectInspector structObjectInspector = (StructObjectInspector)inspector;
            this.fields = structObjectInspector.getAllStructFieldRefs();
            this.childrenWriters = new TreeWriter[this.fields.size()];
            for (int i = 0; i < this.childrenWriters.length; ++i) {
                this.childrenWriters[i] = WriterImpl.createTreeWriter(this.fields.get(i).getFieldObjectInspector(), writer, true);
            }
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj);
            if (obj != null) {
                StructObjectInspector insp = (StructObjectInspector)this.inspector;
                for (int i = 0; i < this.fields.size(); ++i) {
                    StructField field = this.fields.get(i);
                    TreeWriter writer = this.childrenWriters[i];
                    writer.write(insp.getStructFieldData(obj, field));
                }
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            for (TreeWriter child : this.childrenWriters) {
                child.writeStripe(builder, requiredIndexEntries);
            }
            this.recordPosition(this.rowIndexPosition);
        }
    }

    private static class DecimalTreeWriter
    extends TreeWriter {
        private final PositionedOutputStream valueStream;
        private final IntegerWriter scaleStream;
        private final boolean isDirectV2;

        DecimalTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, inspector, writer, nullable);
            this.isDirectV2 = this.isNewWriteFormat(writer);
            this.valueStream = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.scaleStream = this.createIntegerWriter(writer.createStream(this.id, OrcProto.Stream.Kind.SECONDARY), true, this.isDirectV2);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        OrcProto.ColumnEncoding getEncoding() {
            if (this.isDirectV2) {
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2).build();
            }
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj);
            if (obj != null) {
                HiveDecimal decimal = ((HiveDecimalObjectInspector)this.inspector).getPrimitiveJavaObject(obj);
                SerializationUtils.writeBigInteger(this.valueStream, decimal.unscaledValue());
                this.scaleStream.write(decimal.scale());
                this.indexStatistics.updateDecimal(decimal);
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.valueStream.flush();
            this.scaleStream.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.valueStream.getPosition(recorder);
            this.scaleStream.getPosition(recorder);
        }
    }

    private static class DateTreeWriter
    extends TreeWriter {
        private final IntegerWriter writer;
        private final boolean isDirectV2;

        DateTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, inspector, writer, nullable);
            OutStream out = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.isDirectV2 = this.isNewWriteFormat(writer);
            this.writer = this.createIntegerWriter(out, true, this.isDirectV2);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj);
            if (obj != null) {
                DateWritable val = ((DateObjectInspector)this.inspector).getPrimitiveWritableObject(obj);
                this.indexStatistics.updateDate(val);
                this.writer.write(val.getDays());
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.writer.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.writer.getPosition(recorder);
        }

        @Override
        OrcProto.ColumnEncoding getEncoding() {
            if (this.isDirectV2) {
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2).build();
            }
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }
    }

    private static class TimestampTreeWriter
    extends TreeWriter {
        private final IntegerWriter seconds;
        private final IntegerWriter nanos;
        private final boolean isDirectV2;

        TimestampTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, inspector, writer, nullable);
            this.isDirectV2 = this.isNewWriteFormat(writer);
            this.seconds = this.createIntegerWriter(writer.createStream(this.id, OrcProto.Stream.Kind.DATA), true, this.isDirectV2);
            this.nanos = this.createIntegerWriter(writer.createStream(this.id, OrcProto.Stream.Kind.SECONDARY), false, this.isDirectV2);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        OrcProto.ColumnEncoding getEncoding() {
            if (this.isDirectV2) {
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2).build();
            }
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj);
            if (obj != null) {
                Timestamp val = ((TimestampObjectInspector)this.inspector).getPrimitiveJavaObject(obj);
                this.seconds.write(val.getTime() / 1000L - BASE_TIMESTAMP);
                this.nanos.write(TimestampTreeWriter.formatNanos(val.getNanos()));
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.seconds.flush();
            this.nanos.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        private static long formatNanos(int nanos) {
            int trailingZeros;
            if (nanos == 0) {
                return 0L;
            }
            if (nanos % 100 != 0) {
                return (long)nanos << 3;
            }
            nanos /= 100;
            for (trailingZeros = 1; nanos % 10 == 0 && trailingZeros < 7; ++trailingZeros) {
                nanos /= 10;
            }
            return (long)nanos << 3 | (long)trailingZeros;
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.seconds.getPosition(recorder);
            this.nanos.getPosition(recorder);
        }
    }

    private static class BinaryTreeWriter
    extends TreeWriter {
        private final PositionedOutputStream stream;
        private final IntegerWriter length;
        private boolean isDirectV2 = true;

        BinaryTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, inspector, writer, nullable);
            this.stream = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.isDirectV2 = this.isNewWriteFormat(writer);
            this.length = this.createIntegerWriter(writer.createStream(this.id, OrcProto.Stream.Kind.LENGTH), false, this.isDirectV2);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        OrcProto.ColumnEncoding getEncoding() {
            if (this.isDirectV2) {
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2).build();
            }
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj);
            if (obj != null) {
                BytesWritable val = ((BinaryObjectInspector)this.inspector).getPrimitiveWritableObject(obj);
                this.stream.write(val.getBytes(), 0, val.getLength());
                this.length.write(val.getLength());
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.stream.flush();
            this.length.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.stream.getPosition(recorder);
            this.length.getPosition(recorder);
        }
    }

    private static class VarcharTreeWriter
    extends StringTreeWriter {
        VarcharTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, inspector, writer, nullable);
        }

        @Override
        String getStringValue(Object obj) {
            return ((HiveVarcharObjectInspector)this.inspector).getPrimitiveJavaObject(obj).getValue();
        }
    }

    private static class StringTreeWriter
    extends TreeWriter {
        private static final int INITIAL_DICTIONARY_SIZE = 4096;
        private final OutStream stringOutput;
        private final IntegerWriter lengthOutput;
        private final IntegerWriter rowOutput;
        private final StringRedBlackTree dictionary = new StringRedBlackTree(4096);
        private final DynamicIntArray rows = new DynamicIntArray();
        private final PositionedOutputStream directStreamOutput;
        private final IntegerWriter directLengthOutput;
        private final List<OrcProto.RowIndexEntry> savedRowIndex = new ArrayList<OrcProto.RowIndexEntry>();
        private final boolean buildIndex;
        private final List<Long> rowIndexValueCount = new ArrayList<Long>();
        private final float dictionaryKeySizeThreshold;
        private boolean useDictionaryEncoding = true;
        private boolean isDirectV2 = true;

        StringTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, inspector, writer, nullable);
            this.isDirectV2 = this.isNewWriteFormat(writer);
            this.stringOutput = writer.createStream(this.id, OrcProto.Stream.Kind.DICTIONARY_DATA);
            this.lengthOutput = this.createIntegerWriter(writer.createStream(this.id, OrcProto.Stream.Kind.LENGTH), false, this.isDirectV2);
            this.rowOutput = this.createIntegerWriter(writer.createStream(this.id, OrcProto.Stream.Kind.DATA), false, this.isDirectV2);
            this.recordPosition(this.rowIndexPosition);
            this.rowIndexValueCount.add(0L);
            this.buildIndex = writer.buildIndex();
            this.directStreamOutput = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.directLengthOutput = this.createIntegerWriter(writer.createStream(this.id, OrcProto.Stream.Kind.LENGTH), false, this.isDirectV2);
            this.dictionaryKeySizeThreshold = writer.getConfiguration().getFloat(HiveConf.ConfVars.HIVE_ORC_DICTIONARY_KEY_SIZE_THRESHOLD.varname, HiveConf.ConfVars.HIVE_ORC_DICTIONARY_KEY_SIZE_THRESHOLD.defaultFloatVal);
        }

        String getStringValue(Object obj) {
            return ((StringObjectInspector)this.inspector).getPrimitiveJavaObject(obj);
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj);
            if (obj != null) {
                String val = this.getStringValue(obj);
                this.rows.add(this.dictionary.add(val));
                this.indexStatistics.updateString(val);
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            this.useDictionaryEncoding = !this.isDirectV2 || this.rows.size() > 0 && (float)this.dictionary.size() / (float)this.rows.size() <= this.dictionaryKeySizeThreshold;
            final int[] dumpOrder = new int[this.dictionary.size()];
            if (this.useDictionaryEncoding) {
                this.dictionary.visit(new StringRedBlackTree.Visitor(){
                    private int currentId = 0;

                    @Override
                    public void visit(StringRedBlackTree.VisitorContext context) throws IOException {
                        context.writeBytes(StringTreeWriter.this.stringOutput);
                        StringTreeWriter.this.lengthOutput.write(context.getLength());
                        dumpOrder[context.getOriginalPosition()] = this.currentId++;
                    }
                });
            } else {
                this.stringOutput.suppress();
            }
            int length = this.rows.size();
            int rowIndexEntry = 0;
            OrcProto.RowIndex.Builder rowIndex = this.getRowIndex();
            Text text = new Text();
            for (int i = 0; i <= length; ++i) {
                if (this.buildIndex) {
                    while ((long)i == this.rowIndexValueCount.get(rowIndexEntry) && rowIndexEntry < this.savedRowIndex.size()) {
                        OrcProto.RowIndexEntry.Builder base = this.savedRowIndex.get(rowIndexEntry++).toBuilder();
                        if (this.useDictionaryEncoding) {
                            this.rowOutput.getPosition(new RowIndexPositionRecorder(base));
                        } else {
                            RowIndexPositionRecorder posn = new RowIndexPositionRecorder(base);
                            this.directStreamOutput.getPosition(posn);
                            this.directLengthOutput.getPosition(posn);
                        }
                        rowIndex.addEntry(base.build());
                    }
                }
                if (i == length) continue;
                if (this.useDictionaryEncoding) {
                    this.rowOutput.write(dumpOrder[this.rows.get(i)]);
                    continue;
                }
                this.dictionary.getText(text, this.rows.get(i));
                this.directStreamOutput.write(text.getBytes(), 0, text.getLength());
                this.directLengthOutput.write(text.getLength());
            }
            super.writeStripe(builder, requiredIndexEntries);
            this.stringOutput.flush();
            this.lengthOutput.flush();
            this.rowOutput.flush();
            this.directStreamOutput.flush();
            this.directLengthOutput.flush();
            this.dictionary.clear();
            this.rows.clear();
            this.savedRowIndex.clear();
            this.rowIndexValueCount.clear();
            this.recordPosition(this.rowIndexPosition);
            this.rowIndexValueCount.add(0L);
        }

        @Override
        OrcProto.ColumnEncoding getEncoding() {
            if (this.useDictionaryEncoding) {
                if (this.isDirectV2) {
                    return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DICTIONARY_V2).setDictionarySize(this.dictionary.size()).build();
                }
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DICTIONARY).setDictionarySize(this.dictionary.size()).build();
            }
            if (this.isDirectV2) {
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2).build();
            }
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        @Override
        void createRowIndexEntry() throws IOException {
            this.getFileStatistics().merge(this.indexStatistics);
            OrcProto.RowIndexEntry.Builder rowIndexEntry = this.getRowIndexEntry();
            rowIndexEntry.setStatistics(this.indexStatistics.serialize());
            this.indexStatistics.reset();
            this.savedRowIndex.add(rowIndexEntry.build());
            rowIndexEntry.clear();
            this.recordPosition(this.rowIndexPosition);
            this.rowIndexValueCount.add(Long.valueOf(this.rows.size()));
        }

        @Override
        long estimateMemory() {
            return (long)this.rows.getSizeInBytes() + this.dictionary.getSizeInBytes();
        }
    }

    private static class DoubleTreeWriter
    extends TreeWriter {
        private final PositionedOutputStream stream;

        DoubleTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, inspector, writer, nullable);
            this.stream = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj);
            if (obj != null) {
                double val = ((DoubleObjectInspector)this.inspector).get(obj);
                this.indexStatistics.updateDouble(val);
                SerializationUtils.writeDouble(this.stream, val);
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.stream.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.stream.getPosition(recorder);
        }
    }

    private static class FloatTreeWriter
    extends TreeWriter {
        private final PositionedOutputStream stream;

        FloatTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, inspector, writer, nullable);
            this.stream = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj);
            if (obj != null) {
                float val = ((FloatObjectInspector)this.inspector).get(obj);
                this.indexStatistics.updateDouble(val);
                SerializationUtils.writeFloat(this.stream, val);
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.stream.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.stream.getPosition(recorder);
        }
    }

    private static class IntegerTreeWriter
    extends TreeWriter {
        private final IntegerWriter writer;
        private final ShortObjectInspector shortInspector;
        private final IntObjectInspector intInspector;
        private final LongObjectInspector longInspector;
        private boolean isDirectV2 = true;

        IntegerTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, inspector, writer, nullable);
            OutStream out = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.isDirectV2 = this.isNewWriteFormat(writer);
            this.writer = this.createIntegerWriter(out, true, this.isDirectV2);
            if (inspector instanceof IntObjectInspector) {
                this.intInspector = (IntObjectInspector)inspector;
                this.shortInspector = null;
                this.longInspector = null;
            } else {
                this.intInspector = null;
                if (inspector instanceof LongObjectInspector) {
                    this.longInspector = (LongObjectInspector)inspector;
                    this.shortInspector = null;
                } else {
                    this.shortInspector = (ShortObjectInspector)inspector;
                    this.longInspector = null;
                }
            }
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        OrcProto.ColumnEncoding getEncoding() {
            if (this.isDirectV2) {
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2).build();
            }
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj);
            if (obj != null) {
                long val = this.intInspector != null ? (long)this.intInspector.get(obj) : (this.longInspector != null ? this.longInspector.get(obj) : (long)this.shortInspector.get(obj));
                this.indexStatistics.updateInteger(val);
                this.writer.write(val);
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.writer.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.writer.getPosition(recorder);
        }
    }

    private static class ByteTreeWriter
    extends TreeWriter {
        private final RunLengthByteWriter writer;

        ByteTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, inspector, writer, nullable);
            this.writer = new RunLengthByteWriter(writer.createStream(this.id, OrcProto.Stream.Kind.DATA));
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj);
            if (obj != null) {
                byte val = ((ByteObjectInspector)this.inspector).get(obj);
                this.indexStatistics.updateInteger(val);
                this.writer.write(val);
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.writer.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.writer.getPosition(recorder);
        }
    }

    private static class BooleanTreeWriter
    extends TreeWriter {
        private final BitFieldWriter writer;

        BooleanTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, inspector, writer, nullable);
            OutStream out = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.writer = new BitFieldWriter(out, 1);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj);
            if (obj != null) {
                boolean val = ((BooleanObjectInspector)this.inspector).get(obj);
                this.indexStatistics.updateBoolean(val);
                this.writer.write(val ? 1 : 0);
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.writer.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.writer.getPosition(recorder);
        }
    }

    private static abstract class TreeWriter {
        protected final int id;
        protected final ObjectInspector inspector;
        private final BitFieldWriter isPresent;
        private final boolean isCompressed;
        protected final ColumnStatisticsImpl indexStatistics;
        private final ColumnStatisticsImpl fileStatistics;
        protected TreeWriter[] childrenWriters;
        protected final RowIndexPositionRecorder rowIndexPosition;
        private final OrcProto.RowIndex.Builder rowIndex;
        private final OrcProto.RowIndexEntry.Builder rowIndexEntry;
        private final PositionedOutputStream rowIndexStream;
        private boolean foundNulls;
        private OutStream isPresentOutStream;
        protected final boolean useDirectV2Encoding;

        TreeWriter(int columnId, ObjectInspector inspector, StreamFactory streamFactory, boolean nullable) throws IOException {
            this.isCompressed = streamFactory.isCompressed();
            this.id = columnId;
            this.inspector = inspector;
            this.useDirectV2Encoding = true;
            if (nullable) {
                this.isPresentOutStream = streamFactory.createStream(this.id, OrcProto.Stream.Kind.PRESENT);
                this.isPresent = new BitFieldWriter(this.isPresentOutStream, 1);
            } else {
                this.isPresent = null;
            }
            this.foundNulls = false;
            this.indexStatistics = ColumnStatisticsImpl.create(inspector);
            this.fileStatistics = ColumnStatisticsImpl.create(inspector);
            this.childrenWriters = new TreeWriter[0];
            this.rowIndex = OrcProto.RowIndex.newBuilder();
            this.rowIndexEntry = OrcProto.RowIndexEntry.newBuilder();
            this.rowIndexPosition = new RowIndexPositionRecorder(this.rowIndexEntry);
            this.rowIndexStream = streamFactory.buildIndex() ? streamFactory.createStream(this.id, OrcProto.Stream.Kind.ROW_INDEX) : null;
        }

        protected OrcProto.RowIndex.Builder getRowIndex() {
            return this.rowIndex;
        }

        protected ColumnStatisticsImpl getFileStatistics() {
            return this.fileStatistics;
        }

        protected OrcProto.RowIndexEntry.Builder getRowIndexEntry() {
            return this.rowIndexEntry;
        }

        IntegerWriter createIntegerWriter(PositionedOutputStream output, boolean signed, boolean isDirectV2) {
            if (isDirectV2) {
                return new RunLengthIntegerWriterV2(output, signed);
            }
            return new RunLengthIntegerWriter(output, signed);
        }

        boolean isNewWriteFormat(StreamFactory writer) {
            return writer.getVersion() != OrcFile.Version.V_0_11;
        }

        void write(Object obj) throws IOException {
            if (obj != null) {
                this.indexStatistics.increment();
            }
            if (this.isPresent != null) {
                this.isPresent.write(obj == null ? 0 : 1);
                if (obj == null) {
                    this.foundNulls = true;
                }
            }
        }

        private void removeIsPresentPositions() {
            for (int i = 0; i < this.rowIndex.getEntryCount(); ++i) {
                OrcProto.RowIndexEntry.Builder entry = this.rowIndex.getEntryBuilder(i);
                List<Long> positions = entry.getPositionsList();
                positions = positions.subList(this.isCompressed ? 4 : 3, positions.size());
                entry.clearPositions();
                entry.addAllPositions(positions);
            }
        }

        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            if (this.isPresent != null) {
                this.isPresent.flush();
                if (!this.foundNulls) {
                    this.isPresentOutStream.suppress();
                    if (this.rowIndexStream != null) {
                        this.removeIsPresentPositions();
                    }
                }
            }
            this.foundNulls = false;
            builder.addColumns(this.getEncoding());
            if (this.rowIndexStream != null) {
                if (this.rowIndex.getEntryCount() != requiredIndexEntries) {
                    throw new IllegalArgumentException("Column has wrong number of index entries found: " + this.rowIndexEntry + " expected: " + requiredIndexEntries);
                }
                this.rowIndex.build().writeTo(this.rowIndexStream);
                this.rowIndexStream.flush();
            }
            this.rowIndex.clear();
            this.rowIndexEntry.clear();
        }

        TreeWriter[] getChildrenWriters() {
            return this.childrenWriters;
        }

        OrcProto.ColumnEncoding getEncoding() {
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        void createRowIndexEntry() throws IOException {
            this.fileStatistics.merge(this.indexStatistics);
            this.rowIndexEntry.setStatistics(this.indexStatistics.serialize());
            this.indexStatistics.reset();
            this.rowIndex.addEntry(this.rowIndexEntry);
            this.rowIndexEntry.clear();
            this.recordPosition(this.rowIndexPosition);
            for (TreeWriter child : this.childrenWriters) {
                child.createRowIndexEntry();
            }
        }

        void recordPosition(PositionRecorder recorder) throws IOException {
            if (this.isPresent != null) {
                this.isPresent.getPosition(recorder);
            }
        }

        long estimateMemory() {
            long result = 0L;
            for (TreeWriter child : this.childrenWriters) {
                result += child.estimateMemory();
            }
            return result;
        }
    }

    private class StreamFactory {
        private StreamFactory() {
        }

        public OutStream createStream(int column, OrcProto.Stream.Kind kind) throws IOException {
            StreamName name = new StreamName(column, kind);
            BufferedStream result = (BufferedStream)WriterImpl.this.streams.get(name);
            if (result == null) {
                result = new BufferedStream(name.toString(), WriterImpl.this.bufferSize, WriterImpl.this.codec);
                WriterImpl.this.streams.put(name, result);
            }
            return result.outStream;
        }

        public int getNextColumnId() {
            return WriterImpl.this.columnCount++;
        }

        public int getRowIndexStride() {
            return WriterImpl.this.rowIndexStride;
        }

        public boolean buildIndex() {
            return WriterImpl.this.buildIndex;
        }

        public boolean isCompressed() {
            return WriterImpl.this.codec != null;
        }

        public Configuration getConfiguration() {
            return WriterImpl.this.conf;
        }

        public OrcFile.Version getVersion() {
            return WriterImpl.this.version;
        }
    }

    private static class RowIndexPositionRecorder
    implements PositionRecorder {
        private final OrcProto.RowIndexEntry.Builder builder;

        RowIndexPositionRecorder(OrcProto.RowIndexEntry.Builder builder) {
            this.builder = builder;
        }

        @Override
        public void addPosition(long position) {
            this.builder.addPositions(position);
        }
    }

    private class DirectStream
    implements OutStream.OutputReceiver {
        private final FSDataOutputStream output;

        DirectStream(FSDataOutputStream output) {
            this.output = output;
        }

        @Override
        public void output(ByteBuffer buffer) throws IOException {
            this.output.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        }
    }

    private class BufferedStream
    implements OutStream.OutputReceiver {
        private final OutStream outStream;
        private final List<ByteBuffer> output = new ArrayList<ByteBuffer>();

        BufferedStream(String name, int bufferSize, CompressionCodec codec) throws IOException {
            this.outStream = new OutStream(name, bufferSize, codec, this);
        }

        @Override
        public void output(ByteBuffer buffer) {
            this.output.add(buffer);
        }

        public long getBufferSize() {
            long result = 0L;
            for (ByteBuffer buf : this.output) {
                result += (long)buf.capacity();
            }
            return this.outStream.getBufferSize() + result;
        }

        public void flush() throws IOException {
            this.outStream.flush();
        }

        public void clear() throws IOException {
            this.outStream.clear();
            this.output.clear();
        }

        public boolean isSuppressed() {
            return this.outStream.isSuppressed();
        }

        public long getOutputSize() {
            long result = 0L;
            for (ByteBuffer buffer : this.output) {
                result += (long)buffer.remaining();
            }
            return result;
        }

        void spillTo(OutputStream out) throws IOException {
            for (ByteBuffer buffer : this.output) {
                out.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
            }
        }

        public String toString() {
            return this.outStream.toString();
        }
    }
}

