/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.iq80.snappy.Snappy;

class SnappyCodec
implements CompressionCodec {
    SnappyCodec() {
    }

    @Override
    public boolean compress(ByteBuffer in, ByteBuffer out, ByteBuffer overflow) throws IOException {
        int inBytes = in.remaining();
        byte[] compressed = new byte[Snappy.maxCompressedLength((int)inBytes)];
        int outBytes = Snappy.compress((byte[])in.array(), (int)(in.arrayOffset() + in.position()), (int)inBytes, (byte[])compressed, (int)0);
        if (outBytes < inBytes) {
            int remaining = out.remaining();
            if (remaining >= outBytes) {
                System.arraycopy(compressed, 0, out.array(), out.arrayOffset() + out.position(), outBytes);
                out.position(out.position() + outBytes);
            } else {
                System.arraycopy(compressed, 0, out.array(), out.arrayOffset() + out.position(), remaining);
                out.position(out.limit());
                System.arraycopy(compressed, remaining, overflow.array(), overflow.arrayOffset(), outBytes - remaining);
                overflow.position(outBytes - remaining);
            }
            return true;
        }
        return false;
    }

    @Override
    public void decompress(ByteBuffer in, ByteBuffer out) throws IOException {
        int inOffset = in.position();
        int uncompressLen = Snappy.uncompress((byte[])in.array(), (int)(in.arrayOffset() + inOffset), (int)(in.limit() - inOffset), (byte[])out.array(), (int)(out.arrayOffset() + out.position()));
        out.position(uncompressLen + out.position());
        out.flip();
    }
}

