/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.Progressable;

public class HiveSequenceFileOutputFormat<K, V>
extends SequenceFileOutputFormat<K, V>
implements HiveOutputFormat<K, V> {
    BytesWritable EMPTY_KEY = new BytesWritable();

    @Override
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        FileSystem fs = finalOutPath.getFileSystem((Configuration)jc);
        final SequenceFile.Writer outStream = Utilities.createSequenceWriter(jc, fs, finalOutPath, BytesWritable.class, valueClass, isCompressed);
        return new FileSinkOperator.RecordWriter(){

            @Override
            public void write(Writable r) throws IOException {
                outStream.append((Writable)HiveSequenceFileOutputFormat.this.EMPTY_KEY, r);
            }

            @Override
            public void close(boolean abort) throws IOException {
                outStream.close();
            }
        };
    }
}

