/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.index;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.index.HiveIndex;
import org.apache.hadoop.hive.ql.index.IndexMetadataChangeWork;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.api.StageType;

public class IndexMetadataChangeTask
extends Task<IndexMetadataChangeWork> {
    private static final long serialVersionUID = 1L;

    @Override
    protected int execute(DriverContext driverContext) {
        try {
            Hive db = Hive.get(this.conf);
            IndexMetadataChangeWork work = (IndexMetadataChangeWork)this.getWork();
            String tblName = work.getIndexTbl();
            Table tbl = db.getTable(work.getDbName(), tblName);
            if (tbl == null) {
                this.console.printError("Index table can not be null.");
                return 1;
            }
            if (!tbl.getTableType().equals((Object)TableType.INDEX_TABLE)) {
                this.console.printError("Table " + tbl.getTableName() + " not specified.");
                return 1;
            }
            if (tbl.isPartitioned() && work.getPartSpec() == null) {
                this.console.printError("Index table is partitioned, but no partition specified.");
                return 1;
            }
            if (work.getPartSpec() != null) {
                Partition part = db.getPartition(tbl, work.getPartSpec(), false);
                if (part == null) {
                    this.console.printError("Partition " + Warehouse.makePartName(work.getPartSpec(), (boolean)false).toString() + " does not exist.");
                    return 1;
                }
                Path url = new Path(part.getPartitionPath().toString());
                FileSystem fs = url.getFileSystem((Configuration)this.conf);
                FileStatus fstat = fs.getFileStatus(url);
                part.getParameters().put(HiveIndex.INDEX_TABLE_CREATETIME, Long.toString(fstat.getModificationTime()));
                db.alterPartition(tbl.getTableName(), part);
            } else {
                Path url = new Path(tbl.getPath().toString());
                FileSystem fs = url.getFileSystem((Configuration)this.conf);
                FileStatus fstat = fs.getFileStatus(url);
                tbl.getParameters().put(HiveIndex.INDEX_TABLE_CREATETIME, Long.toString(fstat.getModificationTime()));
                db.alterTable(tbl.getTableName(), tbl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.console.printError("Error changing index table/partition metadata " + e.getMessage());
            return 1;
        }
        return 0;
    }

    @Override
    public String getName() {
        return IndexMetadataChangeTask.class.getSimpleName();
    }

    @Override
    public StageType getType() {
        return StageType.DDL;
    }
}

