/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.LateralViewJoinDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class LateralViewJoinOperator
extends Operator<LateralViewJoinDesc> {
    private static final long serialVersionUID = 1L;
    public static final int SELECT_TAG = 0;
    public static final int UDTF_TAG = 1;
    ArrayList<Object> acc = new ArrayList();
    ArrayList<Object> selectObjs = new ArrayList();

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        ArrayList<ObjectInspector> ois = new ArrayList<ObjectInspector>();
        ArrayList<String> fieldNames = ((LateralViewJoinDesc)this.conf).getOutputInternalColNames();
        StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[0];
        List<? extends StructField> sfs = soi.getAllStructFieldRefs();
        for (StructField structField : sfs) {
            ois.add(structField.getFieldObjectInspector());
        }
        soi = (StructObjectInspector)this.inputObjInspectors[1];
        sfs = soi.getAllStructFieldRefs();
        for (StructField structField : sfs) {
            ois.add(structField.getFieldObjectInspector());
        }
        this.outputObjInspector = ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, ois);
        super.initializeOp(hconf);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[tag];
        if (tag == 0) {
            this.selectObjs.clear();
            this.selectObjs.addAll(soi.getStructFieldsDataAsList(row));
        } else if (tag == 1) {
            this.acc.clear();
            this.acc.addAll(this.selectObjs);
            this.acc.addAll(soi.getStructFieldsDataAsList(row));
            this.forward(this.acc, this.outputObjInspector);
        } else {
            throw new HiveException("Invalid tag");
        }
    }

    @Override
    public String getName() {
        return LateralViewJoinOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "LVJ";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.LATERALVIEWJOIN;
    }
}

