/*
 * Decompiled with CFR 0.152.
 */
package org.soundsofscala.transport;

import cats.Show$;
import cats.effect.IO;
import cats.effect.IO$;
import java.io.Serializable;
import org.scalajs.dom.AudioContext;
import org.soundsofscala.instrument.Instrument;
import org.soundsofscala.models.AtomicMusicalEvent;
import org.soundsofscala.models.AtomicMusicalEvent$Rest$;
import org.soundsofscala.models.Duration;
import org.soundsofscala.models.MusicalEvent;
import org.soundsofscala.models.Sequence;
import org.soundsofscala.models.Types$package$LookAhead$;
import org.soundsofscala.models.Types$package$NextNoteTime$;
import org.soundsofscala.transport.NoteScheduler$;
import org.soundsofscala.transport.ScheduleStatus;
import org.soundsofscala.transport.ScheduleStatus$;
import scala.MatchError;
import scala.Product;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class NoteScheduler
implements Product,
Serializable {
    private final double tempo;
    private final double lookAheadMs;
    private final double scheduleAheadTimeSeconds;

    public static NoteScheduler apply(double d, double d2, double d3) {
        return NoteScheduler$.MODULE$.apply(d, d2, d3);
    }

    public static NoteScheduler fromProduct(Product product) {
        return NoteScheduler$.MODULE$.fromProduct(product);
    }

    public static NoteScheduler unapply(NoteScheduler noteScheduler) {
        return NoteScheduler$.MODULE$.unapply(noteScheduler);
    }

    public NoteScheduler(double tempo, double lookAheadMs, double scheduleAheadTimeSeconds) {
        this.tempo = tempo;
        this.lookAheadMs = lookAheadMs;
        this.scheduleAheadTimeSeconds = scheduleAheadTimeSeconds;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof NoteScheduler)) return false;
        NoteScheduler noteScheduler = (NoteScheduler)object;
        if (this.tempo() != noteScheduler.tempo()) return false;
        if (this.lookAheadMs() != noteScheduler.lookAheadMs()) return false;
        if (this.scheduleAheadTimeSeconds() != noteScheduler.scheduleAheadTimeSeconds()) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof NoteScheduler;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "NoteScheduler";
    }

    public Object productElement(int n) {
        double d;
        int n2 = n;
        switch (n2) {
            case 0: {
                d = this._1();
                break;
            }
            case 1: {
                d = this._2();
                break;
            }
            case 2: {
                d = this._3();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return BoxesRunTime.boxToDouble((double)d);
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "tempo";
            }
            case 1: {
                return "lookAheadMs";
            }
            case 2: {
                return "scheduleAheadTimeSeconds";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public double tempo() {
        return this.tempo;
    }

    public double lookAheadMs() {
        return this.lookAheadMs;
    }

    public double scheduleAheadTimeSeconds() {
        return this.scheduleAheadTimeSeconds;
    }

    public <Settings> IO<BoxedUnit> scheduleInstrument(MusicalEvent musicalEvent, Instrument<Settings> instrument, Settings settings, AudioContext audioContext) {
        double startingNoteTime = BoxesRunTime.unboxToDouble((Object)Types$package$NextNoteTime$.MODULE$.apply(BoxesRunTime.boxToDouble((double)audioContext.currentTime())));
        return this.scheduler(musicalEvent, startingNoteTime, instrument, settings, audioContext).$greater$greater(NoteScheduler::scheduleInstrument$$anonfun$1);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private IO scheduler(MusicalEvent musicalEvent, double nextNoteTime, Instrument instrument, Object settings, AudioContext contextual$1) {
        ScheduleStatus scheduleStatus = ScheduleStatus$.MODULE$.apply(nextNoteTime, this.scheduleAheadTimeSeconds(), contextual$1);
        ScheduleStatus scheduleStatus2 = ScheduleStatus$.Ready;
        ScheduleStatus scheduleStatus3 = scheduleStatus;
        if (!(scheduleStatus2 != null ? !scheduleStatus2.equals(scheduleStatus3) : scheduleStatus3 != null)) {
            MusicalEvent musicalEvent2 = musicalEvent;
            if (musicalEvent2 instanceof Sequence) {
                Sequence sequence = (Sequence)musicalEvent2;
                Types$package$NextNoteTime$ types$package$NextNoteTime$ = Types$package$NextNoteTime$.MODULE$;
                double typ$proxy1 = nextNoteTime;
                double nextNextNoteTime = BoxesRunTime.unboxToDouble((Object)Types$package$NextNoteTime$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(typ$proxy1 + sequence.head().durationToSeconds(this.tempo())))));
                return this.scheduleAtomicEvent(sequence.head(), nextNoteTime, instrument, settings, contextual$1).$greater$greater(() -> this.scheduler$$anonfun$1(sequence, nextNextNoteTime, instrument, settings, contextual$1));
            }
            if (musicalEvent2 instanceof AtomicMusicalEvent) {
                AtomicMusicalEvent atomicEvent = (AtomicMusicalEvent)musicalEvent2;
                return this.scheduleAtomicEvent(atomicEvent, nextNoteTime, instrument, settings, contextual$1);
            }
            throw new MatchError((Object)musicalEvent2);
        }
        ScheduleStatus scheduleStatus4 = ScheduleStatus$.Waiting;
        ScheduleStatus scheduleStatus5 = scheduleStatus;
        if (!(scheduleStatus4 != null ? !scheduleStatus4.equals(scheduleStatus5) : scheduleStatus5 != null)) {
            Types$package$LookAhead$ types$package$LookAhead$ = Types$package$LookAhead$.MODULE$;
            double typ$proxy2 = this.lookAheadMs();
            return IO$.MODULE$.sleep(new package.DurationDouble(package$.MODULE$.DurationDouble(typ$proxy2)).millis()).$greater$greater(() -> this.scheduler$$anonfun$2(musicalEvent, nextNoteTime, instrument, settings, contextual$1));
        }
        throw new MatchError((Object)scheduleStatus);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private IO scheduleAtomicEvent(AtomicMusicalEvent musicalEvent, double nextNoteTime, Instrument instrument, Object settings, AudioContext contextual$2) {
        AtomicMusicalEvent atomicMusicalEvent = musicalEvent;
        if (atomicMusicalEvent instanceof AtomicMusicalEvent.Rest) {
            AtomicMusicalEvent.Rest rest = AtomicMusicalEvent$Rest$.MODULE$.unapply((AtomicMusicalEvent.Rest)atomicMusicalEvent);
            Duration duration = rest._1();
            return IO$.MODULE$.unit();
        }
        if (atomicMusicalEvent != null) {
            AtomicMusicalEvent event = atomicMusicalEvent;
            Types$package$NextNoteTime$ types$package$NextNoteTime$ = Types$package$NextNoteTime$.MODULE$;
            double typ$proxy3 = nextNoteTime;
            return instrument.play(event, typ$proxy3, this.tempo(), settings, contextual$2);
        }
        throw new MatchError((Object)atomicMusicalEvent);
    }

    public NoteScheduler copy(double tempo, double lookAheadMs, double scheduleAheadTimeSeconds) {
        return new NoteScheduler(tempo, lookAheadMs, scheduleAheadTimeSeconds);
    }

    public double copy$default$1() {
        return this.tempo();
    }

    public double copy$default$2() {
        return this.lookAheadMs();
    }

    public double copy$default$3() {
        return this.scheduleAheadTimeSeconds();
    }

    public double _1() {
        return this.tempo();
    }

    public double _2() {
        return this.lookAheadMs();
    }

    public double _3() {
        return this.scheduleAheadTimeSeconds();
    }

    private static final IO scheduleInstrument$$anonfun$1() {
        return IO$.MODULE$.println((Object)"Sequence finished", Show$.MODULE$.catsShowForString());
    }

    private final IO scheduler$$anonfun$1(Sequence sequence$1, double nextNextNoteTime$1, Instrument instrument$1, Object settings$1, AudioContext contextual$1$1) {
        return this.scheduler(sequence$1.tail(), nextNextNoteTime$1, instrument$1, settings$1, contextual$1$1);
    }

    private final IO scheduler$$anonfun$2(MusicalEvent musicalEvent$1, double nextNoteTime$1, Instrument instrument$2, Object settings$2, AudioContext contextual$1$2) {
        return this.scheduler(musicalEvent$1, nextNoteTime$1, instrument$2, settings$2, contextual$1$2);
    }
}

