/*
 * Decompiled with CFR 0.152.
 */
package org.soundsofscala.synthesis;

import org.scalajs.dom.AudioContext;
import org.scalajs.dom.AudioNode;
import org.scalajs.dom.BiquadFilterNode;
import org.soundsofscala.models.Types$package$Bandwidth$;
import org.soundsofscala.models.Types$package$Hertz$;
import org.soundsofscala.synthesis.Filter$;
import org.soundsofscala.synthesis.Filter$AllPass$;
import org.soundsofscala.synthesis.Filter$BandPass$;
import org.soundsofscala.synthesis.Filter$HighPass$;
import org.soundsofscala.synthesis.Filter$HighShelf$;
import org.soundsofscala.synthesis.Filter$LowPass$;
import org.soundsofscala.synthesis.Filter$LowShelf$;
import org.soundsofscala.synthesis.Filter$Notch$;
import org.soundsofscala.synthesis.Filter$Peaking$;
import scala.Product;
import scala.reflect.Enum;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class Filter
implements Product,
Enum {
    private final BiquadFilterNode filterNode;

    public static Filter fromOrdinal(int n) {
        return Filter$.MODULE$.fromOrdinal(n);
    }

    public Filter(String filterType, AudioContext audioContext) {
        this.filterNode = audioContext.createBiquadFilter();
        this.filterNode.type_$eq(filterType);
        Types$package$Hertz$ types$package$Hertz$ = Types$package$Hertz$.MODULE$;
        double typ$proxy1 = frequency;
        this.filterNode.frequency().value_$eq(typ$proxy1);
        Types$package$Bandwidth$ types$package$Bandwidth$ = Types$package$Bandwidth$.MODULE$;
        double typ$proxy2 = bandwidth;
        this.filterNode.Q().value_$eq(typ$proxy2);
    }

    public void updateF(double f) {
        this.filterNode.frequency().value_$eq(f);
    }

    public void updateQ(double q) {
        this.filterNode.Q().value_$eq(q);
    }

    public void plugInTo(AudioNode node) {
        this.filterNode.connect(node);
    }

    public BiquadFilterNode plugIn(AudioNode node) {
        node.connect((AudioNode)this.filterNode);
        return this.filterNode;
    }

    public static final class AllPass
    extends Filter {
        private final double frequency;
        private final double bandwidth;

        public static AllPass apply(double d, double d2, AudioContext audioContext) {
            return Filter$AllPass$.MODULE$.apply(d, d2, audioContext);
        }

        public static AllPass unapply(AllPass allPass) {
            return Filter$AllPass$.MODULE$.unapply(allPass);
        }

        public AllPass(AudioContext audioContext) {
            this.frequency = frequency;
            this.bandwidth = bandwidth;
            super("allpass", audioContext);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AllPass)) return false;
            AllPass allPass = (AllPass)object;
            if (this.frequency() != allPass.frequency()) return false;
            if (this.bandwidth() != allPass.bandwidth()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AllPass;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "AllPass";
        }

        public Object productElement(int n) {
            double d;
            int n2 = n;
            if (0 == n2) {
                d = this._1();
            } else if (1 == n2) {
                d = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToDouble((double)d);
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "frequency";
            }
            if (1 == n2) {
                return "bandwidth";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double frequency() {
            return this.frequency;
        }

        public double bandwidth() {
            return this.bandwidth;
        }

        public AllPass copy(double frequency, double bandwidth, AudioContext audioContext) {
            return new AllPass(audioContext);
        }

        public double copy$default$1() {
            return this.frequency();
        }

        public double copy$default$2() {
            return this.bandwidth();
        }

        public int ordinal() {
            return 4;
        }

        public double _1() {
            return this.frequency();
        }

        public double _2() {
            return this.bandwidth();
        }
    }

    public static final class BandPass
    extends Filter {
        private final double frequency;
        private final double bandwidth;

        public static BandPass apply(double d, double d2, AudioContext audioContext) {
            return Filter$BandPass$.MODULE$.apply(d, d2, audioContext);
        }

        public static BandPass unapply(BandPass bandPass) {
            return Filter$BandPass$.MODULE$.unapply(bandPass);
        }

        public BandPass(AudioContext audioContext) {
            this.frequency = frequency;
            this.bandwidth = bandwidth;
            super("bandpass", audioContext);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BandPass)) return false;
            BandPass bandPass = (BandPass)object;
            if (this.frequency() != bandPass.frequency()) return false;
            if (this.bandwidth() != bandPass.bandwidth()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BandPass;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "BandPass";
        }

        public Object productElement(int n) {
            double d;
            int n2 = n;
            if (0 == n2) {
                d = this._1();
            } else if (1 == n2) {
                d = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToDouble((double)d);
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "frequency";
            }
            if (1 == n2) {
                return "bandwidth";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double frequency() {
            return this.frequency;
        }

        public double bandwidth() {
            return this.bandwidth;
        }

        public BandPass copy(double frequency, double bandwidth, AudioContext audioContext) {
            return new BandPass(audioContext);
        }

        public double copy$default$1() {
            return this.frequency();
        }

        public double copy$default$2() {
            return this.bandwidth();
        }

        public int ordinal() {
            return 2;
        }

        public double _1() {
            return this.frequency();
        }

        public double _2() {
            return this.bandwidth();
        }
    }

    public static final class HighPass
    extends Filter {
        private final double frequency;
        private final double bandwidth;

        public static HighPass apply(double d, double d2, AudioContext audioContext) {
            return Filter$HighPass$.MODULE$.apply(d, d2, audioContext);
        }

        public static HighPass unapply(HighPass highPass) {
            return Filter$HighPass$.MODULE$.unapply(highPass);
        }

        public HighPass(AudioContext audioContext) {
            this.frequency = frequency;
            this.bandwidth = bandwidth;
            super("highpass", audioContext);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HighPass)) return false;
            HighPass highPass = (HighPass)object;
            if (this.frequency() != highPass.frequency()) return false;
            if (this.bandwidth() != highPass.bandwidth()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof HighPass;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "HighPass";
        }

        public Object productElement(int n) {
            double d;
            int n2 = n;
            if (0 == n2) {
                d = this._1();
            } else if (1 == n2) {
                d = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToDouble((double)d);
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "frequency";
            }
            if (1 == n2) {
                return "bandwidth";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double frequency() {
            return this.frequency;
        }

        public double bandwidth() {
            return this.bandwidth;
        }

        public HighPass copy(double frequency, double bandwidth, AudioContext audioContext) {
            return new HighPass(audioContext);
        }

        public double copy$default$1() {
            return this.frequency();
        }

        public double copy$default$2() {
            return this.bandwidth();
        }

        public int ordinal() {
            return 1;
        }

        public double _1() {
            return this.frequency();
        }

        public double _2() {
            return this.bandwidth();
        }
    }

    public static final class HighShelf
    extends Filter {
        private final double frequency;
        private final double bandwidth;

        public static HighShelf apply(double d, double d2, AudioContext audioContext) {
            return Filter$HighShelf$.MODULE$.apply(d, d2, audioContext);
        }

        public static HighShelf unapply(HighShelf highShelf) {
            return Filter$HighShelf$.MODULE$.unapply(highShelf);
        }

        public HighShelf(AudioContext audioContext) {
            this.frequency = frequency;
            this.bandwidth = bandwidth;
            super("highshelf", audioContext);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HighShelf)) return false;
            HighShelf highShelf = (HighShelf)object;
            if (this.frequency() != highShelf.frequency()) return false;
            if (this.bandwidth() != highShelf.bandwidth()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof HighShelf;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "HighShelf";
        }

        public Object productElement(int n) {
            double d;
            int n2 = n;
            if (0 == n2) {
                d = this._1();
            } else if (1 == n2) {
                d = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToDouble((double)d);
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "frequency";
            }
            if (1 == n2) {
                return "bandwidth";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double frequency() {
            return this.frequency;
        }

        public double bandwidth() {
            return this.bandwidth;
        }

        public HighShelf copy(double frequency, double bandwidth, AudioContext audioContext) {
            return new HighShelf(audioContext);
        }

        public double copy$default$1() {
            return this.frequency();
        }

        public double copy$default$2() {
            return this.bandwidth();
        }

        public int ordinal() {
            return 7;
        }

        public double _1() {
            return this.frequency();
        }

        public double _2() {
            return this.bandwidth();
        }
    }

    public static final class LowPass
    extends Filter {
        private final double frequency;
        private final double bandwidth;

        public static LowPass apply(double d, double d2, AudioContext audioContext) {
            return Filter$LowPass$.MODULE$.apply(d, d2, audioContext);
        }

        public static LowPass unapply(LowPass lowPass) {
            return Filter$LowPass$.MODULE$.unapply(lowPass);
        }

        public LowPass(AudioContext audioContext) {
            this.frequency = frequency;
            this.bandwidth = bandwidth;
            super("lowpass", audioContext);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LowPass)) return false;
            LowPass lowPass = (LowPass)object;
            if (this.frequency() != lowPass.frequency()) return false;
            if (this.bandwidth() != lowPass.bandwidth()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LowPass;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "LowPass";
        }

        public Object productElement(int n) {
            double d;
            int n2 = n;
            if (0 == n2) {
                d = this._1();
            } else if (1 == n2) {
                d = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToDouble((double)d);
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "frequency";
            }
            if (1 == n2) {
                return "bandwidth";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double frequency() {
            return this.frequency;
        }

        public double bandwidth() {
            return this.bandwidth;
        }

        public LowPass copy(double frequency, double bandwidth, AudioContext audioContext) {
            return new LowPass(audioContext);
        }

        public double copy$default$1() {
            return this.frequency();
        }

        public double copy$default$2() {
            return this.bandwidth();
        }

        public int ordinal() {
            return 0;
        }

        public double _1() {
            return this.frequency();
        }

        public double _2() {
            return this.bandwidth();
        }
    }

    public static final class LowShelf
    extends Filter {
        private final double frequency;
        private final double bandwidth;

        public static LowShelf apply(double d, double d2, AudioContext audioContext) {
            return Filter$LowShelf$.MODULE$.apply(d, d2, audioContext);
        }

        public static LowShelf unapply(LowShelf lowShelf) {
            return Filter$LowShelf$.MODULE$.unapply(lowShelf);
        }

        public LowShelf(AudioContext audioContext) {
            this.frequency = frequency;
            this.bandwidth = bandwidth;
            super("lowshelf", audioContext);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LowShelf)) return false;
            LowShelf lowShelf = (LowShelf)object;
            if (this.frequency() != lowShelf.frequency()) return false;
            if (this.bandwidth() != lowShelf.bandwidth()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LowShelf;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "LowShelf";
        }

        public Object productElement(int n) {
            double d;
            int n2 = n;
            if (0 == n2) {
                d = this._1();
            } else if (1 == n2) {
                d = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToDouble((double)d);
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "frequency";
            }
            if (1 == n2) {
                return "bandwidth";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double frequency() {
            return this.frequency;
        }

        public double bandwidth() {
            return this.bandwidth;
        }

        public LowShelf copy(double frequency, double bandwidth, AudioContext audioContext) {
            return new LowShelf(audioContext);
        }

        public double copy$default$1() {
            return this.frequency();
        }

        public double copy$default$2() {
            return this.bandwidth();
        }

        public int ordinal() {
            return 6;
        }

        public double _1() {
            return this.frequency();
        }

        public double _2() {
            return this.bandwidth();
        }
    }

    public static final class Notch
    extends Filter {
        private final double frequency;
        private final double bandwidth;

        public static Notch apply(double d, double d2, AudioContext audioContext) {
            return Filter$Notch$.MODULE$.apply(d, d2, audioContext);
        }

        public static Notch unapply(Notch notch) {
            return Filter$Notch$.MODULE$.unapply(notch);
        }

        public Notch(AudioContext audioContext) {
            this.frequency = frequency;
            this.bandwidth = bandwidth;
            super("notch", audioContext);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Notch)) return false;
            Notch notch = (Notch)object;
            if (this.frequency() != notch.frequency()) return false;
            if (this.bandwidth() != notch.bandwidth()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Notch;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "Notch";
        }

        public Object productElement(int n) {
            double d;
            int n2 = n;
            if (0 == n2) {
                d = this._1();
            } else if (1 == n2) {
                d = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToDouble((double)d);
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "frequency";
            }
            if (1 == n2) {
                return "bandwidth";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double frequency() {
            return this.frequency;
        }

        public double bandwidth() {
            return this.bandwidth;
        }

        public Notch copy(double frequency, double bandwidth, AudioContext audioContext) {
            return new Notch(audioContext);
        }

        public double copy$default$1() {
            return this.frequency();
        }

        public double copy$default$2() {
            return this.bandwidth();
        }

        public int ordinal() {
            return 3;
        }

        public double _1() {
            return this.frequency();
        }

        public double _2() {
            return this.bandwidth();
        }
    }

    public static final class Peaking
    extends Filter {
        private final double frequency;
        private final double bandwidth;

        public static Peaking apply(double d, double d2, AudioContext audioContext) {
            return Filter$Peaking$.MODULE$.apply(d, d2, audioContext);
        }

        public static Peaking unapply(Peaking peaking) {
            return Filter$Peaking$.MODULE$.unapply(peaking);
        }

        public Peaking(AudioContext audioContext) {
            this.frequency = frequency;
            this.bandwidth = bandwidth;
            super("peaking", audioContext);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Peaking)) return false;
            Peaking peaking = (Peaking)object;
            if (this.frequency() != peaking.frequency()) return false;
            if (this.bandwidth() != peaking.bandwidth()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Peaking;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "Peaking";
        }

        public Object productElement(int n) {
            double d;
            int n2 = n;
            if (0 == n2) {
                d = this._1();
            } else if (1 == n2) {
                d = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToDouble((double)d);
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "frequency";
            }
            if (1 == n2) {
                return "bandwidth";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double frequency() {
            return this.frequency;
        }

        public double bandwidth() {
            return this.bandwidth;
        }

        public Peaking copy(double frequency, double bandwidth, AudioContext audioContext) {
            return new Peaking(audioContext);
        }

        public double copy$default$1() {
            return this.frequency();
        }

        public double copy$default$2() {
            return this.bandwidth();
        }

        public int ordinal() {
            return 5;
        }

        public double _1() {
            return this.frequency();
        }

        public double _2() {
            return this.bandwidth();
        }
    }
}

