/*
 * Decompiled with CFR 0.152.
 */
package org.soundsofscala.synthesis;

import cats.effect.IO;
import cats.effect.IO$;
import java.io.Serializable;
import org.scalajs.dom.AudioBuffer;
import org.scalajs.dom.AudioBufferSourceNode;
import org.scalajs.dom.AudioContext;
import org.scalajs.dom.AudioNode;
import org.scalajs.dom.BiquadFilterNode;
import org.scalajs.dom.GainNode;
import org.scalajs.dom.OscillatorNode;
import org.soundsofscala.models.AtomicMusicalEvent;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.scalajs.js.typedarray.Float32Array;

public final class DrumGeneration$
implements Serializable {
    public static final DrumGeneration$ MODULE$ = new DrumGeneration$();

    private DrumGeneration$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DrumGeneration$.class);
    }

    public IO<BoxedUnit> generateKick808(AtomicMusicalEvent.DrumStroke drumStroke, double when, AudioContext audioContext) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            DrumGeneration$.generateKick808$$anonfun$1(drumStroke, audioContext, when);
            return BoxedUnit.UNIT;
        });
    }

    public IO<BoxedUnit> generateClap808(AtomicMusicalEvent.DrumStroke drumStroke, double when, AudioContext audioContext) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.generateClap808$$anonfun$1(drumStroke, audioContext, when);
            return BoxedUnit.UNIT;
        });
    }

    public IO<BoxedUnit> generateHats808(AtomicMusicalEvent.DrumStroke drumStroke, double when, AudioContext audioContext) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            DrumGeneration$.generateHats808$$anonfun$1(drumStroke, audioContext, when);
            return BoxedUnit.UNIT;
        });
    }

    public IO<BoxedUnit> generateSnare808(AtomicMusicalEvent.DrumStroke drumStroke, double when, AudioContext audioContext) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            DrumGeneration$.generateSnare808$$anonfun$1(drumStroke, audioContext, when);
            return BoxedUnit.UNIT;
        });
    }

    private static final void generateKick808$$anonfun$1(AtomicMusicalEvent.DrumStroke drumStroke$1, AudioContext audioContext$1, double when$1) {
        double velocity = drumStroke$1.velocity().getNormalisedVelocity();
        OscillatorNode osc = audioContext$1.createOscillator();
        osc.type_$eq("sine");
        osc.frequency().setValueAtTime(80.0, when$1);
        osc.frequency().exponentialRampToValueAtTime(30.0, when$1 + 0.2);
        GainNode gain = audioContext$1.createGain();
        BiquadFilterNode filterShelf = audioContext$1.createBiquadFilter();
        filterShelf.type_$eq("lowshelf");
        filterShelf.frequency().value_$eq(300.0);
        filterShelf.gain().value_$eq(5.0);
        gain.gain().linearRampToValueAtTime(velocity * 0.5, when$1 + 0.01);
        gain.gain().exponentialRampToValueAtTime(0.001, when$1 + 0.9);
        osc.connect((AudioNode)filterShelf);
        filterShelf.connect((AudioNode)gain);
        gain.connect((AudioNode)audioContext$1.destination());
        osc.start(when$1);
        osc.stop(when$1 + 0.9);
    }

    private final AudioBuffer createNoiseBuffer$1(AudioContext audioContext) {
        float bufferSize = (float)audioContext.sampleRate();
        AudioBuffer buffer = audioContext.createBuffer(1, (int)bufferSize, (int)audioContext.sampleRate());
        Float32Array output = buffer.getChannelData(0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), output.length()).foreach((Function1 & Serializable)v1 -> {
            output.update(BoxesRunTime.unboxToInt((Object)v1), (Object)BoxesRunTime.boxToFloat((float)((float)(package$.MODULE$.random() * (double)2 - 1.0))));
            return BoxedUnit.UNIT;
        });
        return buffer;
    }

    private final void generateClap808$$anonfun$1(AtomicMusicalEvent.DrumStroke drumStroke$2, AudioContext audioContext$2, double when$2) {
        double velocity = drumStroke$2.velocity().getNormalisedVelocity();
        AudioBuffer noiseBuffer = this.createNoiseBuffer$1(audioContext$2);
        AudioBufferSourceNode noiseSource = audioContext$2.createBufferSource();
        noiseSource.buffer_$eq(noiseBuffer);
        BiquadFilterNode bandpass = audioContext$2.createBiquadFilter();
        bandpass.type_$eq("bandpass");
        bandpass.frequency().value_$eq(1000.0);
        bandpass.Q().value_$eq(0.2);
        BiquadFilterNode highpass = audioContext$2.createBiquadFilter();
        highpass.type_$eq("highpass");
        highpass.frequency().value_$eq(2000.0);
        GainNode gain = audioContext$2.createGain();
        gain.gain().setValueAtTime(0.0, when$2);
        gain.gain().linearRampToValueAtTime(velocity, when$2 + 0.01);
        gain.gain().exponentialRampToValueAtTime(0.01, when$2 + 0.2);
        noiseSource.connect((AudioNode)bandpass);
        bandpass.connect((AudioNode)highpass);
        highpass.connect((AudioNode)gain);
        gain.connect((AudioNode)audioContext$2.destination());
        noiseSource.start(when$2, noiseSource.start$default$2(), noiseSource.start$default$3());
        noiseSource.stop(when$2 + 0.2);
    }

    private static final void generateHats808$$anonfun$1(AtomicMusicalEvent.DrumStroke drumStroke$3, AudioContext audioContext$3, double when$3) {
        double velocity = drumStroke$3.velocity().getNormalisedVelocity();
        double bufferSize = audioContext$3.sampleRate() * 2.0;
        AudioBuffer noiseBuffer = audioContext$3.createBuffer(1, (int)bufferSize, (int)audioContext$3.sampleRate());
        Float32Array output = noiseBuffer.getChannelData(0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), output.length()).foreach((Function1 & Serializable)v1 -> {
            output.update(BoxesRunTime.unboxToInt((Object)v1), (Object)BoxesRunTime.boxToFloat((float)((float)(package$.MODULE$.random() * (double)2 - 1.0))));
            return BoxedUnit.UNIT;
        });
        AudioBufferSourceNode noise = audioContext$3.createBufferSource();
        noise.buffer_$eq(noiseBuffer);
        BiquadFilterNode highPass = audioContext$3.createBiquadFilter();
        highPass.type_$eq("highpass");
        highPass.frequency().setValueAtTime(10000.0, when$3);
        GainNode gain = audioContext$3.createGain();
        gain.gain().setValueAtTime(velocity, when$3);
        gain.gain().exponentialRampToValueAtTime(0.01, when$3 + 0.05);
        noise.connect((AudioNode)highPass);
        highPass.connect((AudioNode)gain);
        gain.connect((AudioNode)audioContext$3.destination());
        noise.start(when$3, noise.start$default$2(), noise.start$default$3());
        noise.stop(when$3 + 0.05);
    }

    private static final void generateSnare808$$anonfun$1(AtomicMusicalEvent.DrumStroke drumStroke$4, AudioContext audioContext$4, double when$4) {
        double velocity = drumStroke$4.velocity().getNormalisedVelocity();
        OscillatorNode bodyOsc = audioContext$4.createOscillator();
        bodyOsc.type_$eq("triangle");
        bodyOsc.frequency().setValueAtTime(170.0, when$4);
        GainNode bodyGain = audioContext$4.createGain();
        bodyGain.gain().setValueAtTime(velocity, when$4);
        bodyGain.gain().linearRampToValueAtTime(0.01, when$4 + 0.1);
        bodyOsc.connect((AudioNode)bodyGain);
        int bufferSize = (int)audioContext$4.sampleRate() * 2;
        AudioBuffer noiseBuffer = audioContext$4.createBuffer(1, bufferSize, (int)audioContext$4.sampleRate());
        Float32Array output = noiseBuffer.getChannelData(0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), output.length()).foreach((Function1 & Serializable)v1 -> {
            output.update(BoxesRunTime.unboxToInt((Object)v1), (Object)BoxesRunTime.boxToFloat((float)((float)(package$.MODULE$.random() * (double)2 - 1.0))));
            return BoxedUnit.UNIT;
        });
        AudioBufferSourceNode noise = audioContext$4.createBufferSource();
        noise.buffer_$eq(noiseBuffer);
        BiquadFilterNode noiseFilter = audioContext$4.createBiquadFilter();
        noiseFilter.type_$eq("bandpass");
        noiseFilter.frequency().setValueAtTime(1000.0, when$4);
        noise.connect((AudioNode)noiseFilter);
        GainNode noiseGain = audioContext$4.createGain();
        noiseGain.gain().setValueAtTime(velocity * 0.8, when$4);
        noiseGain.gain().linearRampToValueAtTime(0.01, when$4 + 0.3);
        noiseFilter.connect((AudioNode)noiseGain);
        bodyGain.connect((AudioNode)audioContext$4.destination());
        noiseGain.connect((AudioNode)audioContext$4.destination());
        bodyOsc.start(when$4);
        noise.start(when$4, noise.start$default$2(), noise.start$default$3());
        bodyOsc.stop(when$4 + 0.3);
        noise.stop(when$4 + 0.3);
    }
}

