/*
 * Decompiled with CFR 0.152.
 */
package org.soundsofscala.models;

import cats.data.NonEmptyList;
import java.io.Serializable;
import org.soundsofscala.TransformMusicalEvents$;
import org.soundsofscala.models.Accidental;
import org.soundsofscala.models.AtomicMusicalEvent$;
import org.soundsofscala.models.AtomicMusicalEvent$DrumStroke$;
import org.soundsofscala.models.AtomicMusicalEvent$Harmony$;
import org.soundsofscala.models.AtomicMusicalEvent$Note$;
import org.soundsofscala.models.AtomicMusicalEvent$Rest$;
import org.soundsofscala.models.DrumVoice;
import org.soundsofscala.models.Duration;
import org.soundsofscala.models.Duration$;
import org.soundsofscala.models.HarmonyTiming;
import org.soundsofscala.models.MusicalEvent;
import org.soundsofscala.models.Pitch;
import org.soundsofscala.models.Sequence;
import org.soundsofscala.models.Sequence$;
import org.soundsofscala.models.Types$package$Octave$;
import org.soundsofscala.models.Velocity;
import org.soundsofscala.models.Velocity$;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.reflect.Enum;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class AtomicMusicalEvent
implements MusicalEvent,
Product,
Enum {
    private final Duration duration;
    private final Velocity velocity;

    public static Note flat(Note note) {
        return AtomicMusicalEvent$.MODULE$.flat(note);
    }

    public static double frequency(Note note) {
        return AtomicMusicalEvent$.MODULE$.frequency(note);
    }

    public static AtomicMusicalEvent fromOrdinal(int n) {
        return AtomicMusicalEvent$.MODULE$.fromOrdinal(n);
    }

    public static Note sharp(Note note) {
        return AtomicMusicalEvent$.MODULE$.sharp(note);
    }

    public AtomicMusicalEvent() {
        this.duration = duration;
        this.velocity = velocity;
    }

    public double durationToSeconds(double tempo) {
        return this.duration.toSeconds(tempo);
    }

    public double normalizedVelocity() {
        return this.velocity.getNormalisedVelocity();
    }

    public String toString() {
        return AtomicMusicalEvent.loop$5(this, "");
    }

    private String printCondensed() {
        AtomicMusicalEvent atomicMusicalEvent = this;
        if (atomicMusicalEvent instanceof Note) {
            Note note = AtomicMusicalEvent$Note$.MODULE$.unapply((Note)atomicMusicalEvent);
            Pitch pitch = note._1();
            Accidental accidental = note._2();
            Duration duration = note._3();
            int n = note._4();
            Velocity velocity = note._5();
            double d = note._6();
            Pitch pitch2 = pitch;
            Accidental accidental2 = accidental;
            int octave = n;
            Velocity velocity2 = velocity;
            double offset = d;
            Types$package$Octave$ types$package$Octave$ = Types$package$Octave$.MODULE$;
            int typ$proxy2 = octave;
            return new StringBuilder(0).append(pitch2).append(TransformMusicalEvents$.MODULE$.accidentalToString(accidental2)).append(BoxesRunTime.boxToInteger((int)typ$proxy2)).toString();
        }
        if (atomicMusicalEvent instanceof Rest) {
            Rest rest = AtomicMusicalEvent$Rest$.MODULE$.unapply((Rest)atomicMusicalEvent);
            Duration duration = rest._1();
            return "R";
        }
        if (atomicMusicalEvent instanceof DrumStroke) {
            DrumStroke drumStroke = AtomicMusicalEvent$DrumStroke$.MODULE$.unapply((DrumStroke)atomicMusicalEvent);
            DrumVoice drumVoice = drumStroke._1();
            Duration duration = drumStroke._2();
            Velocity velocity = drumStroke._3();
            DrumVoice drum = drumVoice;
            Velocity velocity3 = velocity;
            return new StringBuilder(0).append(TransformMusicalEvents$.MODULE$.drumVoiceToString(drum)).append(velocity3).toString();
        }
        if (atomicMusicalEvent instanceof Harmony) {
            Harmony harmony = AtomicMusicalEvent$Harmony$.MODULE$.unapply((Harmony)atomicMusicalEvent);
            NonEmptyList<HarmonyTiming> nonEmptyList = harmony._1();
            Duration duration = harmony._2();
            return "CHORD";
        }
        throw new MatchError((Object)atomicMusicalEvent);
    }

    private String printAtomicEvent() {
        AtomicMusicalEvent atomicMusicalEvent = this;
        if (atomicMusicalEvent instanceof Note) {
            Note note = AtomicMusicalEvent$Note$.MODULE$.unapply((Note)atomicMusicalEvent);
            Pitch pitch = note._1();
            Accidental accidental = note._2();
            Duration duration = note._3();
            int n = note._4();
            Velocity velocity = note._5();
            double d = note._6();
            Pitch pitch2 = pitch;
            Accidental accidental2 = accidental;
            Duration duration2 = duration;
            int octave = n;
            Velocity velocity2 = velocity;
            double offset = d;
            Types$package$Octave$ types$package$Octave$ = Types$package$Octave$.MODULE$;
            int typ$proxy3 = octave;
            String firstSection = new StringBuilder(1).append(pitch2).append(TransformMusicalEvents$.MODULE$.accidentalToString(accidental2)).append(BoxesRunTime.boxToInteger((int)typ$proxy3)).append(velocity2).append("_").toString();
            return TransformMusicalEvents$.MODULE$.durationToString(duration2, firstSection);
        }
        if (atomicMusicalEvent instanceof Rest) {
            Duration duration;
            Rest rest = AtomicMusicalEvent$Rest$.MODULE$.unapply((Rest)atomicMusicalEvent);
            Duration duration3 = duration = rest._1();
            return TransformMusicalEvents$.MODULE$.durationToString(duration3, "");
        }
        if (atomicMusicalEvent instanceof DrumStroke) {
            DrumStroke drumStroke = AtomicMusicalEvent$DrumStroke$.MODULE$.unapply((DrumStroke)atomicMusicalEvent);
            DrumVoice drumVoice = drumStroke._1();
            Duration duration = drumStroke._2();
            Velocity velocity = drumStroke._3();
            DrumVoice drum = drumVoice;
            Duration duration4 = duration;
            Velocity velocity3 = velocity;
            String firstSection = new StringBuilder(1).append(TransformMusicalEvents$.MODULE$.drumVoiceToString(drum)).append(velocity3).append("_").toString();
            return TransformMusicalEvents$.MODULE$.durationToString(duration4, firstSection);
        }
        if (atomicMusicalEvent instanceof Harmony) {
            Harmony harmony = AtomicMusicalEvent$Harmony$.MODULE$.unapply((Harmony)atomicMusicalEvent);
            NonEmptyList<HarmonyTiming> nonEmptyList = harmony._1();
            Duration duration = harmony._2();
            NonEmptyList<HarmonyTiming> notes = nonEmptyList;
            Duration duration5 = duration;
            return TransformMusicalEvents$.MODULE$.durationToString(duration5, new StringBuilder(2).append("[").append(notes.toList().map((Function1 & Serializable)_$1 -> _$1.note().printCondensed()).mkString(",")).append("]").toString());
        }
        throw new MatchError((Object)atomicMusicalEvent);
    }

    public AtomicMusicalEvent withVelocity(Velocity newVelocity) {
        AtomicMusicalEvent atomicMusicalEvent = this;
        if (atomicMusicalEvent instanceof Note) {
            Note note = (Note)atomicMusicalEvent;
            return note.copy(note.copy$default$1(), note.copy$default$2(), note.copy$default$3(), note.copy$default$4(), newVelocity, note.copy$default$6());
        }
        if (atomicMusicalEvent instanceof Rest) {
            Rest rest = (Rest)atomicMusicalEvent;
            return rest;
        }
        if (atomicMusicalEvent instanceof DrumStroke) {
            DrumStroke drum = (DrumStroke)atomicMusicalEvent;
            return drum.copy(drum.copy$default$1(), drum.copy$default$2(), newVelocity);
        }
        if (atomicMusicalEvent instanceof Harmony) {
            Harmony harmony = (Harmony)atomicMusicalEvent;
            return AtomicMusicalEvent$.MODULE$.org$soundsofscala$models$AtomicMusicalEvent$$$updateVelocity(harmony, newVelocity);
        }
        throw new MatchError((Object)atomicMusicalEvent);
    }

    public AtomicMusicalEvent withDuration(Duration newDuration) {
        AtomicMusicalEvent atomicMusicalEvent = this;
        if (atomicMusicalEvent instanceof Note) {
            Note note = (Note)atomicMusicalEvent;
            return note.copy(note.copy$default$1(), note.copy$default$2(), newDuration, note.copy$default$4(), note.copy$default$5(), note.copy$default$6());
        }
        if (atomicMusicalEvent instanceof Rest) {
            Rest rest = (Rest)atomicMusicalEvent;
            return rest.copy(newDuration);
        }
        if (atomicMusicalEvent instanceof DrumStroke) {
            DrumStroke drum = (DrumStroke)atomicMusicalEvent;
            return drum.copy(drum.copy$default$1(), newDuration, drum.copy$default$3());
        }
        if (atomicMusicalEvent instanceof Harmony) {
            Harmony harmony = (Harmony)atomicMusicalEvent;
            return harmony.copy(harmony.copy$default$1(), newDuration);
        }
        throw new MatchError((Object)atomicMusicalEvent);
    }

    public AtomicMusicalEvent whole() {
        return this.withDuration(Duration$.Whole);
    }

    public AtomicMusicalEvent half() {
        return this.withDuration(Duration$.Half);
    }

    public AtomicMusicalEvent quarter() {
        return this.withDuration(Duration$.Quarter);
    }

    public AtomicMusicalEvent eighth() {
        return this.withDuration(Duration$.Eighth);
    }

    public AtomicMusicalEvent sixteenth() {
        return this.withDuration(Duration$.Sixteenth);
    }

    public AtomicMusicalEvent thirtySecond() {
        return this.withDuration(Duration$.ThirtySecond);
    }

    public AtomicMusicalEvent halfTriplet() {
        return this.withDuration(Duration$.HalfTriplet);
    }

    public AtomicMusicalEvent quarterTriplet() {
        return this.withDuration(Duration$.QuarterTriplet);
    }

    public AtomicMusicalEvent eighthTriplet() {
        return this.withDuration(Duration$.EighthTriplet);
    }

    public AtomicMusicalEvent sixteenthTriplet() {
        return this.withDuration(Duration$.SixteenthTriplet);
    }

    public AtomicMusicalEvent thirtySecondTriplet() {
        return this.withDuration(Duration$.ThirtySecondTriplet);
    }

    public AtomicMusicalEvent wholeDotted() {
        return this.withDuration(Duration$.WholeDotted);
    }

    public AtomicMusicalEvent halfDotted() {
        return this.withDuration(Duration$.HalfDotted);
    }

    public AtomicMusicalEvent quarterDotted() {
        return this.withDuration(Duration$.QuarterDotted);
    }

    public AtomicMusicalEvent eighthDotted() {
        return this.withDuration(Duration$.EighthDotted);
    }

    public AtomicMusicalEvent sixteenthDotted() {
        return this.withDuration(Duration$.SixteenthDotted);
    }

    public AtomicMusicalEvent thirtySecondDotted() {
        return this.withDuration(Duration$.ThirtySecondDotted);
    }

    public AtomicMusicalEvent ppp() {
        return this.withVelocity(Velocity$.Pianississimo);
    }

    public AtomicMusicalEvent pp() {
        return this.withVelocity(Velocity$.Pianissimo);
    }

    public AtomicMusicalEvent p() {
        return this.withVelocity(Velocity$.Piano);
    }

    public AtomicMusicalEvent mp() {
        return this.withVelocity(Velocity$.MezzoPiano);
    }

    public AtomicMusicalEvent mf() {
        return this.withVelocity(Velocity$.MezzoForte);
    }

    public AtomicMusicalEvent f() {
        return this.withVelocity(Velocity$.Forte);
    }

    public AtomicMusicalEvent ff() {
        return this.withVelocity(Velocity$.Fortissimo);
    }

    public AtomicMusicalEvent fff() {
        return this.withVelocity(Velocity$.Fortississimo);
    }

    public AtomicMusicalEvent muted() {
        return this.withVelocity(Velocity$.TheSilentTreatment);
    }

    public AtomicMusicalEvent softest() {
        return this.withVelocity(Velocity$.Softest);
    }

    public AtomicMusicalEvent soft() {
        return this.withVelocity(Velocity$.Soft);
    }

    public AtomicMusicalEvent medium() {
        return this.withVelocity(Velocity$.Medium);
    }

    public AtomicMusicalEvent assertively() {
        return this.withVelocity(Velocity$.Assertively);
    }

    public AtomicMusicalEvent loud() {
        return this.withVelocity(Velocity$.Loud);
    }

    public AtomicMusicalEvent onFull() {
        return this.withVelocity(Velocity$.OnFull);
    }

    private static final String loop$5(MusicalEvent current, String accumulator) {
        MusicalEvent musicalEvent;
        while ((musicalEvent = current) instanceof Sequence) {
            MusicalEvent tail;
            Sequence sequence = Sequence$.MODULE$.unapply((Sequence)musicalEvent);
            AtomicMusicalEvent atomicMusicalEvent = sequence._1();
            MusicalEvent musicalEvent2 = sequence._2();
            AtomicMusicalEvent head = atomicMusicalEvent;
            MusicalEvent musicalEvent3 = tail = musicalEvent2;
            String string = new StringBuilder(0).append(accumulator).append(head.printAtomicEvent()).toString();
            current = musicalEvent3;
            accumulator = string;
        }
        if (musicalEvent instanceof AtomicMusicalEvent) {
            AtomicMusicalEvent event = (AtomicMusicalEvent)musicalEvent;
            return new StringBuilder(0).append(accumulator).append(event.printAtomicEvent()).toString();
        }
        throw new MatchError((Object)musicalEvent);
    }

    public static final class DrumStroke
    extends AtomicMusicalEvent {
        private final DrumVoice drum;
        private final Duration duration;
        private final Velocity velocity;

        public static DrumStroke apply(DrumVoice drumVoice, Duration duration, Velocity velocity) {
            return AtomicMusicalEvent$DrumStroke$.MODULE$.apply(drumVoice, duration, velocity);
        }

        public static DrumStroke fromProduct(Product product) {
            return AtomicMusicalEvent$DrumStroke$.MODULE$.fromProduct(product);
        }

        public static DrumStroke unapply(DrumStroke drumStroke) {
            return AtomicMusicalEvent$DrumStroke$.MODULE$.unapply(drumStroke);
        }

        public DrumStroke(Velocity velocity) {
            this.drum = drum;
            this.duration = duration;
            this.velocity = velocity;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DrumStroke)) return false;
            DrumStroke drumStroke = (DrumStroke)object;
            DrumVoice drumVoice = this.drum();
            DrumVoice drumVoice2 = drumStroke.drum();
            if (drumVoice == null) {
                if (drumVoice2 != null) {
                    return false;
                }
            } else if (!drumVoice.equals(drumVoice2)) return false;
            Duration duration = this.duration();
            Duration duration2 = drumStroke.duration();
            if (duration == null) {
                if (duration2 != null) {
                    return false;
                }
            } else if (!duration.equals(duration2)) return false;
            Velocity velocity = this.velocity();
            Velocity velocity2 = drumStroke.velocity();
            if (velocity == null) {
                if (velocity2 == null) return true;
                return false;
            } else {
                if (!velocity.equals(velocity2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof DrumStroke;
        }

        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "DrumStroke";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "drum";
                }
                case 1: {
                    return "duration";
                }
                case 2: {
                    return "velocity";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public DrumVoice drum() {
            return this.drum;
        }

        public Duration duration() {
            return this.duration;
        }

        public Velocity velocity() {
            return this.velocity;
        }

        public DrumStroke copy(DrumVoice drum, Duration duration, Velocity velocity) {
            return new DrumStroke(velocity);
        }

        public DrumVoice copy$default$1() {
            return this.drum();
        }

        public Duration copy$default$2() {
            return this.duration();
        }

        public Velocity copy$default$3() {
            return this.velocity();
        }

        public int ordinal() {
            return 2;
        }

        public DrumVoice _1() {
            return this.drum();
        }

        public Duration _2() {
            return this.duration();
        }

        public Velocity _3() {
            return this.velocity();
        }
    }

    public static final class Harmony
    extends AtomicMusicalEvent {
        private final NonEmptyList<HarmonyTiming> notes;
        private final Duration duration;

        public static Harmony apply(NonEmptyList<HarmonyTiming> nonEmptyList, Duration duration) {
            return AtomicMusicalEvent$Harmony$.MODULE$.apply(nonEmptyList, duration);
        }

        public static Harmony fromProduct(Product product) {
            return AtomicMusicalEvent$Harmony$.MODULE$.fromProduct(product);
        }

        public static Harmony unapply(Harmony harmony) {
            return AtomicMusicalEvent$Harmony$.MODULE$.unapply(harmony);
        }

        public Harmony(NonEmptyList<HarmonyTiming> nonEmptyList, Duration duration2) {
            this.notes = notes;
            this.duration = (Duration)duration;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Harmony)) return false;
            Harmony harmony = (Harmony)object;
            NonEmptyList<HarmonyTiming> nonEmptyList = this.notes();
            NonEmptyList<HarmonyTiming> nonEmptyList2 = harmony.notes();
            if (nonEmptyList == null) {
                if (nonEmptyList2 != null) {
                    return false;
                }
            } else if (!nonEmptyList.equals(nonEmptyList2)) return false;
            Duration duration = this.duration();
            Duration duration2 = harmony.duration();
            if (duration == null) {
                if (duration2 == null) return true;
                return false;
            } else {
                if (!duration.equals(duration2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof Harmony;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "Harmony";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "notes";
            }
            if (1 == n2) {
                return "duration";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public NonEmptyList<HarmonyTiming> notes() {
            return this.notes;
        }

        public Duration duration() {
            return this.duration;
        }

        public Harmony copy(NonEmptyList<HarmonyTiming> notes, Duration duration) {
            return new Harmony(notes, duration);
        }

        public NonEmptyList<HarmonyTiming> copy$default$1() {
            return this.notes();
        }

        public Duration copy$default$2() {
            return this.duration();
        }

        public int ordinal() {
            return 3;
        }

        public NonEmptyList<HarmonyTiming> _1() {
            return this.notes();
        }

        public Duration _2() {
            return this.duration();
        }
    }

    public static final class Note
    extends AtomicMusicalEvent {
        private final Pitch pitch;
        private final Accidental accidental;
        private final Duration duration;
        private final int octave;
        private final Velocity velocity;
        private final double offset;

        public static Note apply(Pitch pitch, Accidental accidental, Duration duration, int n, Velocity velocity, double d) {
            return AtomicMusicalEvent$Note$.MODULE$.apply(pitch, accidental, duration, n, velocity, d);
        }

        public static Note fromProduct(Product product) {
            return AtomicMusicalEvent$Note$.MODULE$.fromProduct(product);
        }

        public static Note unapply(Note note) {
            return AtomicMusicalEvent$Note$.MODULE$.unapply(note);
        }

        public static double $lessinit$greater$default$6() {
            return AtomicMusicalEvent$Note$.MODULE$.$lessinit$greater$default$6();
        }

        public Note(Duration duration, int octave, Velocity velocity, double offset) {
            this.pitch = pitch;
            this.accidental = accidental;
            this.duration = duration;
            this.octave = octave;
            this.velocity = velocity;
            this.offset = offset;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Note)) return false;
            Note note = (Note)object;
            Pitch pitch = this.pitch();
            Pitch pitch2 = note.pitch();
            if (pitch == null) {
                if (pitch2 != null) {
                    return false;
                }
            } else if (!pitch.equals(pitch2)) return false;
            Accidental accidental = this.accidental();
            Accidental accidental2 = note.accidental();
            if (accidental == null) {
                if (accidental2 != null) {
                    return false;
                }
            } else if (!accidental.equals(accidental2)) return false;
            Duration duration = this.duration();
            Duration duration2 = note.duration();
            if (duration == null) {
                if (duration2 != null) {
                    return false;
                }
            } else if (!duration.equals(duration2)) return false;
            if (this.octave() != note.octave()) return false;
            Velocity velocity = this.velocity();
            Velocity velocity2 = note.velocity();
            if (velocity == null) {
                if (velocity2 != null) {
                    return false;
                }
            } else if (!velocity.equals(velocity2)) return false;
            if (this.offset() != note.offset()) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Note;
        }

        public int productArity() {
            return 6;
        }

        @Override
        public String productPrefix() {
            return "Note";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return BoxesRunTime.boxToDouble((double)this._6());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "pitch";
                }
                case 1: {
                    return "accidental";
                }
                case 2: {
                    return "duration";
                }
                case 3: {
                    return "octave";
                }
                case 4: {
                    return "velocity";
                }
                case 5: {
                    return "offset";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Pitch pitch() {
            return this.pitch;
        }

        public Accidental accidental() {
            return this.accidental;
        }

        public Duration duration() {
            return this.duration;
        }

        public int octave() {
            return this.octave;
        }

        public Velocity velocity() {
            return this.velocity;
        }

        public double offset() {
            return this.offset;
        }

        public Note copy(Pitch pitch, Accidental accidental, Duration duration, int octave, Velocity velocity, double offset) {
            return new Note(duration, octave, velocity, offset);
        }

        public Pitch copy$default$1() {
            return this.pitch();
        }

        public Accidental copy$default$2() {
            return this.accidental();
        }

        public Duration copy$default$3() {
            return this.duration();
        }

        public int copy$default$4() {
            return this.octave();
        }

        public Velocity copy$default$5() {
            return this.velocity();
        }

        public double copy$default$6() {
            return this.offset();
        }

        public int ordinal() {
            return 0;
        }

        public Pitch _1() {
            return this.pitch();
        }

        public Accidental _2() {
            return this.accidental();
        }

        public Duration _3() {
            return this.duration();
        }

        public int _4() {
            return this.octave();
        }

        public Velocity _5() {
            return this.velocity();
        }

        public double _6() {
            return this.offset();
        }
    }

    public static final class Rest
    extends AtomicMusicalEvent {
        private final Duration duration;

        public static Rest apply(Duration duration) {
            return AtomicMusicalEvent$Rest$.MODULE$.apply(duration);
        }

        public static Rest fromProduct(Product product) {
            return AtomicMusicalEvent$Rest$.MODULE$.fromProduct(product);
        }

        public static Rest unapply(Rest rest) {
            return AtomicMusicalEvent$Rest$.MODULE$.unapply(rest);
        }

        public Rest() {
            this.duration = duration;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Rest)) return false;
            Rest rest = (Rest)object;
            Duration duration = this.duration();
            Duration duration2 = rest.duration();
            if (duration != null) {
                if (!duration.equals(duration2)) return false;
                return true;
            }
            if (duration2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Rest;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Rest";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "duration";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Duration duration() {
            return this.duration;
        }

        public Rest copy(Duration duration) {
            return new Rest();
        }

        public Duration copy$default$1() {
            return this.duration();
        }

        public int ordinal() {
            return 1;
        }

        public Duration _1() {
            return this.duration();
        }
    }
}

