/*
 * Decompiled with CFR 0.152.
 */
package org.soundsofscala.instrument;

import cats.Applicative;
import cats.Foldable;
import cats.effect.IO;
import cats.effect.IO$;
import cats.implicits$;
import cats.kernel.Order;
import java.io.Serializable;
import org.scalajs.dom.AudioBuffer;
import org.scalajs.dom.AudioContext;
import org.soundsofscala.instrument.Instrument;
import org.soundsofscala.instrument.SampleKey;
import org.soundsofscala.instrument.SamplePlayer;
import org.soundsofscala.instrument.SamplePlayer$;
import org.soundsofscala.instrument.Sampler$;
import org.soundsofscala.models.AtomicMusicalEvent;
import org.soundsofscala.models.AtomicMusicalEvent$;
import org.soundsofscala.models.Types$package$TimingOffset$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Sampler
implements Instrument,
SamplePlayer,
Product,
Serializable {
    private final Map<SampleKey, AudioBuffer> samples;
    private final Tuple3<Object, SampleKey, AudioBuffer>[] orderedSamples;

    public static Sampler apply(Map<SampleKey, AudioBuffer> map) {
        return Sampler$.MODULE$.apply(map);
    }

    public static IO<Sampler> fromPaths(List<Tuple2<SampleKey, String>> list, AudioContext audioContext) {
        return Sampler$.MODULE$.fromPaths(list, audioContext);
    }

    public static Sampler fromProduct(Product product) {
        return Sampler$.MODULE$.fromProduct(product);
    }

    public static IO<Sampler> guitar(AudioContext audioContext) {
        return Sampler$.MODULE$.guitar(audioContext);
    }

    public static IO<Sampler> kickDrum(AudioContext audioContext) {
        return Sampler$.MODULE$.kickDrum(audioContext);
    }

    public static IO<Sampler> piano(AudioContext audioContext) {
        return Sampler$.MODULE$.piano(audioContext);
    }

    public static IO<Sampler> rhubarb(AudioContext audioContext) {
        return Sampler$.MODULE$.rhubarb(audioContext);
    }

    public static IO<Sampler> rimShot(AudioContext audioContext) {
        return Sampler$.MODULE$.rimShot(audioContext);
    }

    public static IO<Sampler> snareDrum(AudioContext audioContext) {
        return Sampler$.MODULE$.snareDrum(audioContext);
    }

    public static IO<Sampler> sparkles(AudioContext audioContext) {
        return Sampler$.MODULE$.sparkles(audioContext);
    }

    public static Sampler unapply(Sampler sampler) {
        return Sampler$.MODULE$.unapply(sampler);
    }

    public static IO<Sampler> vinyl(AudioContext audioContext) {
        return Sampler$.MODULE$.vinyl(audioContext);
    }

    public Sampler(Map<SampleKey, AudioBuffer> samples) {
        this.samples = samples;
        Object object = Predef$.MODULE$.refArrayOps((Object[])((IterableOnceOps)samples.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                SampleKey key = (SampleKey)tuple2._1();
                AudioBuffer buffer = (AudioBuffer)tuple2._2();
                return Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)key.frequency()), (Object)key, (Object)buffer);
            }
            throw new MatchError((Object)tuple2);
        })).toArray(ClassTag$.MODULE$.apply(Tuple3.class)));
        this.orderedSamples = (Tuple3[])ArrayOps$.MODULE$.sortBy$extension(object, (Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                double f = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                SampleKey key = (SampleKey)tuple3._2();
                AudioBuffer buffer = (AudioBuffer)tuple3._3();
                return f;
            }
            throw new MatchError((Object)tuple3);
        }, implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForDouble()));
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Sampler)) return false;
        Sampler sampler = (Sampler)object;
        Map<SampleKey, AudioBuffer> map = this.samples();
        Map<SampleKey, AudioBuffer> map2 = sampler.samples();
        if (map != null) {
            if (!map.equals(map2)) return false;
            return true;
        }
        if (map2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Sampler;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "Sampler";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "samples";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Map<SampleKey, AudioBuffer> samples() {
        return this.samples;
    }

    private Tuple3<Object, SampleKey, AudioBuffer> closestFrequency(Tuple3<Object, SampleKey, AudioBuffer>[] sampleFreqs, double target) {
        return Sampler.binarySearch$1(sampleFreqs, target, 0, sampleFreqs.length - 1, sampleFreqs[0]);
    }

    @Override
    public IO<BoxedUnit> playWithSettings(AtomicMusicalEvent musicEvent, double when, double tempo, SamplePlayer.Settings settings, AudioContext audioContext) {
        AtomicMusicalEvent atomicMusicalEvent = musicEvent;
        if (atomicMusicalEvent instanceof AtomicMusicalEvent.Note) {
            AtomicMusicalEvent.Note note = (AtomicMusicalEvent.Note)atomicMusicalEvent;
            double frequency = AtomicMusicalEvent$.MODULE$.frequency(note);
            Tuple3<Object, SampleKey, AudioBuffer> tuple3 = this.closestFrequency(this.orderedSamples, frequency);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            double closestF = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            SampleKey closestKey = (SampleKey)tuple3._2();
            AudioBuffer buffer = (AudioBuffer)tuple3._3();
            Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)closestF), (Object)closestKey, (Object)buffer);
            double closestF2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
            SampleKey closestKey2 = (SampleKey)tuple32._2();
            AudioBuffer buffer2 = (AudioBuffer)tuple32._3();
            double playbackRatePitchFix = frequency / closestF2;
            return SamplePlayer$.MODULE$.playSample(buffer2, playbackRatePitchFix, musicEvent, when, settings, tempo, audioContext);
        }
        if (atomicMusicalEvent instanceof AtomicMusicalEvent.Harmony) {
            AtomicMusicalEvent.Harmony harmony = (AtomicMusicalEvent.Harmony)atomicMusicalEvent;
            return (IO)implicits$.MODULE$.toFoldableOps((Object)harmony.notes().toList(), (Foldable)implicits$.MODULE$.catsStdInstancesForList()).traverse_((Function1 & Serializable)harmonyTiming -> {
                Types$package$TimingOffset$ types$package$TimingOffset$ = Types$package$TimingOffset$.MODULE$;
                double typ$proxy1 = harmonyTiming.timingOffset();
                return this.playWithSettings(harmonyTiming.note(), when + typ$proxy1, tempo, settings, audioContext);
            }, (Applicative)IO$.MODULE$.asyncForIO());
        }
        return IO$.MODULE$.println((Object)"This musical event is not a note.", implicits$.MODULE$.catsStdShowForString());
    }

    public Sampler copy(Map<SampleKey, AudioBuffer> samples) {
        return new Sampler(samples);
    }

    public Map<SampleKey, AudioBuffer> copy$default$1() {
        return this.samples();
    }

    public Map<SampleKey, AudioBuffer> _1() {
        return this.samples();
    }

    private static final Tuple3 binarySearch$1(Tuple3[] sampleFreqs$1, double target$1, int left, int right, Tuple3 closest) {
        while (left <= right) {
            Tuple3 newClosest;
            int mid = left + (right - left) / 2;
            Tuple3 current = sampleFreqs$1[mid];
            Tuple3 tuple3 = newClosest = Math.abs(BoxesRunTime.unboxToDouble((Object)current._1()) - target$1) < Math.abs(BoxesRunTime.unboxToDouble((Object)closest._1()) - target$1) ? current : closest;
            if (BoxesRunTime.unboxToDouble((Object)current._1()) == target$1) {
                return current;
            }
            if (BoxesRunTime.unboxToDouble((Object)current._1()) < target$1) {
                int n = mid + 1;
                Tuple3 tuple32 = newClosest;
                left = n;
                closest = tuple32;
                continue;
            }
            int n = mid - 1;
            Tuple3 tuple33 = newClosest;
            right = n;
            closest = tuple33;
        }
        return closest;
    }
}

