/*
 * Decompiled with CFR 0.152.
 */
package org.soundsofscala.instrument;

import cats.effect.IO;
import cats.effect.IO$;
import java.io.Serializable;
import org.scalajs.dom.AudioBuffer;
import org.scalajs.dom.AudioBufferSourceNode;
import org.scalajs.dom.AudioContext;
import org.scalajs.dom.AudioNode;
import org.scalajs.dom.GainNode;
import org.soundsofscala.instrument.SamplePlayer;
import org.soundsofscala.instrument.SamplePlayer$Settings$;
import org.soundsofscala.models.AtomicMusicalEvent;
import org.soundsofscala.playback.Loop;
import org.soundsofscala.playback.Loop$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Iterable;
import scala.scalajs.js.JSConverters;
import scala.scalajs.js.JSConverters$;
import scala.scalajs.js.typedarray.Float32Array;

public final class SamplePlayer$
implements Serializable {
    public static final SamplePlayer$Settings$ Settings;
    public static final SamplePlayer$ MODULE$;

    private SamplePlayer$() {
    }

    static {
        MODULE$ = new SamplePlayer$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SamplePlayer$.class);
    }

    public IO<BoxedUnit> playSample(AudioBuffer buffer, double playbackRate, AtomicMusicalEvent musicalEvent, double when, SamplePlayer.Settings settings, double tempo, AudioContext audioContext) {
        double offset = settings.offset();
        double duration = musicalEvent.durationToSeconds(tempo);
        return this.createGainNode$1(audioContext, settings.volume()).flatMap((Function1 & Serializable)gainNode -> this.createSourceNode$1(audioContext, buffer, settings.playbackRate() * playbackRate, settings.reversed()).flatMap((Function1 & Serializable)sourceNode -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
            SamplePlayer$.playSample$$anonfun$1$$anonfun$1$$anonfun$1(sourceNode, gainNode);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.configureGainNode$1(duration, when, (GainNode)gainNode, settings).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.configureSourceNode$1(duration, offset, when, (AudioBufferSourceNode)sourceNode, settings).map((Function1 & Serializable)x$1 -> {
                    boxedUnit = BoxedUnit.UNIT;
                    return BoxedUnit.UNIT;
                });
            });
        })));
    }

    private static final GainNode createGainNode$1$$anonfun$1(AudioContext audioContext$2) {
        return audioContext$2.createGain();
    }

    private static final void createGainNode$1$$anonfun$2$$anonfun$1(GainNode gainNode$1, double volume$1) {
        gainNode$1.gain().value_$eq(volume$1);
    }

    private static final void createGainNode$1$$anonfun$2$$anonfun$2$$anonfun$1(GainNode gainNode$3, AudioContext audioContext$5) {
        gainNode$3.connect((AudioNode)audioContext$5.destination());
    }

    private final IO createGainNode$1(AudioContext audioContext$1, double volume) {
        return IO$.MODULE$.apply(() -> SamplePlayer$.createGainNode$1$$anonfun$1(audioContext$1)).flatMap((Function1 & Serializable)gainNode -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
            SamplePlayer$.createGainNode$1$$anonfun$2$$anonfun$1(gainNode, volume);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                SamplePlayer$.createGainNode$1$$anonfun$2$$anonfun$2$$anonfun$1(gainNode, audioContext$1);
                return BoxedUnit.UNIT;
            }).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return gainNode;
            });
        }));
    }

    private static final AudioBufferSourceNode createSourceNode$1$$anonfun$1(AudioContext audioContext$7) {
        return audioContext$7.createBufferSource();
    }

    private static final void createSourceNode$1$$anonfun$2$$anonfun$1(AudioBufferSourceNode sourceNode$1, double playbackRate$1) {
        sourceNode$1.playbackRate().value_$eq(playbackRate$1);
    }

    private final void createSourceNode$1$$anonfun$2$$anonfun$2$$anonfun$1(AudioBufferSourceNode sourceNode$3, boolean reversed$3, AudioBuffer buffer$3, AudioContext audioContext$10) {
        sourceNode$3.buffer_$eq(reversed$3 ? this.reverseBuffer$1(audioContext$10, buffer$3) : buffer$3);
    }

    private final IO createSourceNode$1(AudioContext audioContext$6, AudioBuffer buffer, double playbackRate, boolean reversed) {
        return IO$.MODULE$.apply(() -> SamplePlayer$.createSourceNode$1$$anonfun$1(audioContext$6)).flatMap((Function1 & Serializable)sourceNode -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
            SamplePlayer$.createSourceNode$1$$anonfun$2$$anonfun$1(sourceNode, playbackRate);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.createSourceNode$1$$anonfun$2$$anonfun$2$$anonfun$1((AudioBufferSourceNode)sourceNode, reversed, buffer, audioContext$6);
                return BoxedUnit.UNIT;
            }).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return sourceNode;
            });
        }));
    }

    private static final /* synthetic */ void reverseBuffer$1$$anonfun$1(AudioBuffer buffer$4, AudioBuffer newBuffer$1, int channel) {
        Float32Array data = buffer$4.getChannelData(channel);
        Object object = Predef$.MODULE$.floatArrayOps((float[])Any$.MODULE$.iterableOps((Iterable)data).toArray(ClassTag$.MODULE$.apply(Float.TYPE)));
        float[] reversedData = (float[])ArrayOps$.MODULE$.reverse$extension(object);
        IterableOnce iterableOnce = JSConverters$.MODULE$.iterableOnceConvertible2JSRichIterableOnce((Object)reversedData, (Function1 & Serializable)xs -> Predef$.MODULE$.wrapFloatArray(xs));
        Float32Array typedArr = new Float32Array((Iterable)JSConverters.JSRichIterableOnce$.MODULE$.toJSArray$extension(iterableOnce));
        newBuffer$1.copyToChannel(typedArr, channel, 0);
    }

    private final AudioBuffer reverseBuffer$1(AudioContext audioContext$11, AudioBuffer buffer) {
        AudioBuffer newBuffer = audioContext$11.createBuffer(buffer.numberOfChannels(), buffer.length(), (int)buffer.sampleRate());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), buffer.numberOfChannels()).foreach((Function1 & Serializable)v1 -> {
            SamplePlayer$.reverseBuffer$1$$anonfun$1(buffer, newBuffer, BoxesRunTime.unboxToInt((Object)v1));
            return BoxedUnit.UNIT;
        });
        return newBuffer;
    }

    private static final void configureGainNode$1$$anonfun$1(SamplePlayer.Settings settings$1, GainNode gainNode$5, double when$1, double duration$1) {
        if (settings$1.fadeIn() > 0.0) {
            gainNode$5.gain().setValueAtTime(0.0, when$1);
            gainNode$5.gain().linearRampToValueAtTime(settings$1.volume(), when$1 + settings$1.fadeIn());
        } else {
            gainNode$5.gain().setValueAtTime(settings$1.volume(), when$1);
        }
        if (settings$1.fadeOut() > 0.0) {
            gainNode$5.gain().setValueAtTime(settings$1.volume(), when$1 + duration$1 - settings$1.fadeOut());
            gainNode$5.gain().linearRampToValueAtTime(0.0, when$1 + (duration$1 - 0.01));
            return;
        }
        gainNode$5.gain().exponentialRampToValueAtTime(0.001, when$1 + duration$1 + 0.4);
    }

    private final IO configureGainNode$1(double duration$2, double when, GainNode gainNode, SamplePlayer.Settings settings) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            SamplePlayer$.configureGainNode$1$$anonfun$1(settings, gainNode, when, duration$2);
            return BoxedUnit.UNIT;
        });
    }

    private static final void configureSourceNode$1$$anonfun$1(SamplePlayer.Settings settings$2, AudioBufferSourceNode sourceNode$5, double when$2, double duration$3, double offset$1) {
        Loop loop;
        Option<Loop> option = settings$2.loop();
        if (option instanceof Some && (loop = (Loop)((Some)option).value()) != null) {
            Loop loop2 = Loop$.MODULE$.unapply(loop);
            double d = loop2._1();
            double d2 = loop2._2();
            double start = d;
            double end = d2;
            sourceNode$5.loop_$eq(true);
            sourceNode$5.loopStart_$eq(start);
            sourceNode$5.loopEnd_$eq(end);
            sourceNode$5.start(when$2, start, duration$3);
            sourceNode$5.stop(when$2 + duration$3);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            sourceNode$5.loop_$eq(false);
            sourceNode$5.start(when$2, offset$1, duration$3);
            sourceNode$5.stop(when$2 + (duration$3 + 0.1));
            return;
        }
        throw new MatchError(option);
    }

    private final IO configureSourceNode$1(double duration$4, double offset$2, double when, AudioBufferSourceNode sourceNode, SamplePlayer.Settings settings) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            SamplePlayer$.configureSourceNode$1$$anonfun$1(settings, sourceNode, when, duration$4, offset$2);
            return BoxedUnit.UNIT;
        });
    }

    private static final void playSample$$anonfun$1$$anonfun$1$$anonfun$1(AudioBufferSourceNode sourceNode$6, GainNode gainNode$6) {
        sourceNode$6.connect((AudioNode)gainNode$6);
    }
}

