/*
 * Decompiled with CFR 0.152.
 */
package org.soundsofscala.instrument;

import java.io.Serializable;
import org.soundsofscala.instrument.SampleKey$;
import org.soundsofscala.models.Accidental;
import org.soundsofscala.models.Freq$;
import org.soundsofscala.models.Pitch;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SampleKey
implements Product,
Serializable {
    private final Pitch pitch;
    private final Accidental accidental;
    private final int octave;

    public static SampleKey apply(Pitch pitch, Accidental accidental, int n) {
        return SampleKey$.MODULE$.apply(pitch, accidental, n);
    }

    public static SampleKey fromProduct(Product product) {
        return SampleKey$.MODULE$.fromProduct(product);
    }

    public static SampleKey unapply(SampleKey sampleKey) {
        return SampleKey$.MODULE$.unapply(sampleKey);
    }

    public SampleKey(Pitch pitch, Accidental accidental, int octave) {
        this.pitch = pitch;
        this.accidental = accidental;
        this.octave = octave;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof SampleKey)) return false;
        SampleKey sampleKey = (SampleKey)object;
        Pitch pitch = this.pitch();
        Pitch pitch2 = sampleKey.pitch();
        if (pitch == null) {
            if (pitch2 != null) {
                return false;
            }
        } else if (!pitch.equals(pitch2)) return false;
        Accidental accidental = this.accidental();
        Accidental accidental2 = sampleKey.accidental();
        if (accidental == null) {
            if (accidental2 != null) {
                return false;
            }
        } else if (!accidental.equals(accidental2)) return false;
        if (this.octave() != sampleKey.octave()) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof SampleKey;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "SampleKey";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this._3());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "pitch";
            }
            case 1: {
                return "accidental";
            }
            case 2: {
                return "octave";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Pitch pitch() {
        return this.pitch;
    }

    public Accidental accidental() {
        return this.accidental;
    }

    public int octave() {
        return this.octave;
    }

    public String toString() {
        return new StringBuilder(0).append(this.pitch().toString()).append(this.accidental().toString()).append(BoxesRunTime.boxToInteger((int)this.octave()).toString()).toString();
    }

    public double frequency() {
        return Freq$.MODULE$.calculate(this.pitch(), this.accidental(), this.octave());
    }

    public SampleKey copy(Pitch pitch, Accidental accidental, int octave) {
        return new SampleKey(pitch, accidental, octave);
    }

    public Pitch copy$default$1() {
        return this.pitch();
    }

    public Accidental copy$default$2() {
        return this.accidental();
    }

    public int copy$default$3() {
        return this.octave();
    }

    public Pitch _1() {
        return this.pitch();
    }

    public Accidental _2() {
        return this.accidental();
    }

    public int _3() {
        return this.octave();
    }
}

